/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.RemovedImage;

final class ImmutableRemovedImage
implements RemovedImage {
    private final RemovedImage.Type type;
    @Nullable
    private final String imageId;

    private ImmutableRemovedImage(RemovedImage.Type type, @Nullable String imageId) {
        this.type = type;
        this.imageId = imageId;
    }

    @Override
    public RemovedImage.Type type() {
        return this.type;
    }

    @Override
    @Nullable
    public String imageId() {
        return this.imageId;
    }

    public final ImmutableRemovedImage withType(RemovedImage.Type value) {
        if (this.type == value) {
            return this;
        }
        RemovedImage.Type newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRemovedImage(newValue, this.imageId);
    }

    public final ImmutableRemovedImage withImageId(@Nullable String value) {
        if (Objects.equals(this.imageId, value)) {
            return this;
        }
        return new ImmutableRemovedImage(this.type, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRemovedImage && this.equalTo((ImmutableRemovedImage)another);
    }

    private boolean equalTo(ImmutableRemovedImage another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.imageId, another.imageId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.imageId);
        return h;
    }

    public String toString() {
        return "RemovedImage{type=" + (Object)((Object)this.type) + ", imageId=" + this.imageId + "}";
    }

    public static ImmutableRemovedImage copyOf(RemovedImage instance) {
        if (instance instanceof ImmutableRemovedImage) {
            return (ImmutableRemovedImage)instance;
        }
        return ImmutableRemovedImage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private RemovedImage.Type type;
        private String imageId;

        private Builder() {
        }

        public final Builder from(RemovedImage instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            String imageIdValue = instance.imageId();
            if (imageIdValue != null) {
                this.imageId(imageIdValue);
            }
            return this;
        }

        public final Builder type(RemovedImage.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder imageId(@Nullable String imageId) {
            this.imageId = imageId;
            return this;
        }

        public ImmutableRemovedImage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRemovedImage(this.type, this.imageId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build RemovedImage, some of required attributes are not set " + attributes;
        }
    }
}

