/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.client;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.logging.LogRecord;

public class JsonLogRecordClientUtil {
    public static String logRecordAsJson(LogRecord lr) {
        return JsonLogRecordClientUtil.logRecordAsJsonObject(lr).toString();
    }

    private static JSONString getJsonString(String s) {
        if (s == null) {
            return new JSONString("");
        }
        return new JSONString(s);
    }

    private static JSONObject logRecordAsJsonObject(LogRecord lr) {
        JSONObject obj = new JSONObject();
        obj.put("level", (JSONValue)JsonLogRecordClientUtil.getJsonString(lr.getLevel().toString()));
        obj.put("loggerName", (JSONValue)JsonLogRecordClientUtil.getJsonString(lr.getLoggerName()));
        obj.put("msg", (JSONValue)JsonLogRecordClientUtil.getJsonString(lr.getMessage()));
        obj.put("timestamp", (JSONValue)new JSONString("" + lr.getMillis()));
        obj.put("thrown", (JSONValue)JsonLogRecordClientUtil.throwableAsJsonObject(lr.getThrown()));
        return obj;
    }

    private static JSONObject stackTraceElementAsJsonObject(StackTraceElement e) {
        JSONObject obj = new JSONObject();
        if (e != null) {
            obj.put("className", (JSONValue)JsonLogRecordClientUtil.getJsonString(e.getClassName()));
            obj.put("fileName", (JSONValue)JsonLogRecordClientUtil.getJsonString(e.getFileName()));
            obj.put("methodName", (JSONValue)JsonLogRecordClientUtil.getJsonString(e.getMethodName()));
            obj.put("lineNumber", (JSONValue)JsonLogRecordClientUtil.getJsonString("" + e.getLineNumber()));
        }
        return obj;
    }

    private static JSONObject throwableAsJsonObject(Throwable t) {
        JSONObject obj = new JSONObject();
        if (t != null) {
            obj.put("message", (JSONValue)JsonLogRecordClientUtil.getJsonString(t.getMessage()));
            obj.put("cause", (JSONValue)JsonLogRecordClientUtil.throwableAsJsonObject(t.getCause()));
            StackTraceElement[] stackTrace = t.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                JSONArray arr = new JSONArray();
                for (int i = 0; i < stackTrace.length; ++i) {
                    arr.set(i, (JSONValue)JsonLogRecordClientUtil.stackTraceElementAsJsonObject(stackTrace[i]));
                }
                obj.put("stackTrace", (JSONValue)arr);
            }
        }
        return obj;
    }
}

