/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class TabPanelParser
implements ElementParser {
    private static final String TAG_TAB = "Tab";
    private static final String TAG_TABHTML = "TabHTML";

    public void parse(XMLElement panelElem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        writer.warn(panelElem, "%1$s:%2$s is deprecated. Use the %1$s:TabLayoutPanel instead.", new Object[]{panelElem.getPrefix(), panelElem.getLocalName()});
        for (XMLElement tabElem : panelElem.consumeChildElements()) {
            if (!this.isElementType(panelElem, tabElem, TAG_TAB)) {
                writer.die(tabElem, "Only <%s:%s> children are allowed.", new Object[]{panelElem.getPrefix(), TAG_TAB});
            }
            String tabCaption = tabElem.consumeStringAttribute("text");
            String tabHTML = null;
            String childFieldName = null;
            for (XMLElement tabChild : tabElem.consumeChildElements()) {
                if (tabChild.getLocalName().equals(TAG_TABHTML)) {
                    if (tabCaption != null || tabHTML != null) {
                        writer.die(tabElem, "May have only one \"text\" attribute or <%1$s:%2$s>", new Object[]{tabElem.getPrefix(), TAG_TABHTML});
                    }
                    HtmlInterpreter interpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                    tabHTML = tabChild.consumeInnerHtml((XMLElement.Interpreter)interpreter);
                    continue;
                }
                if (childFieldName != null) {
                    writer.die(tabChild, "May only have a single child widget", new Object[0]);
                }
                if (!writer.isWidgetElement(tabChild)) {
                    writer.die(tabChild, "Must be a widget", new Object[0]);
                }
                childFieldName = writer.parseElementToField(tabChild);
            }
            if (childFieldName == null) {
                writer.die(tabElem, "Must have a child widget", new Object[0]);
            }
            if (tabHTML != null) {
                writer.addStatement("%1$s.add(%2$s, \"%3$s\", true);", new Object[]{fieldName, childFieldName, tabHTML});
                continue;
            }
            if (tabCaption != null) {
                writer.addStatement("%1$s.add(%2$s, %3$s);", new Object[]{fieldName, childFieldName, tabCaption});
                continue;
            }
            writer.die(tabElem, "Requires either a \"text\" attribute or <%1$s:%2$s>", new Object[]{tabElem.getPrefix(), TAG_TABHTML});
        }
    }

    private boolean isElementType(XMLElement parent, XMLElement child, String type) {
        return parent.getNamespaceUri().equals(child.getNamespaceUri()) && type.equals(child.getLocalName());
    }
}

