/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import org.apache.wsil.util.WSDLDocument;

public class WSDLDocumentIdentifier {
    public static boolean isInterfaceDocument(WSDLDocument wsdlDocument) {
        Definition definition = wsdlDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasMessageElement(definition) && WSDLDocumentIdentifier.hasPortTypeElement(definition) && WSDLDocumentIdentifier.hasBindingElement(definition);
    }

    public static boolean isBindingInterfaceDocument(WSDLDocument wsdlDocument) {
        Definition definition = wsdlDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasBindingElement(definition);
    }

    public static boolean isImplementationDocument(WSDLDocument wsdlDocument) {
        Definition definition = wsdlDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasImportElement(definition) && WSDLDocumentIdentifier.hasServiceElement(definition);
    }

    public static boolean isCompleteDocument(WSDLDocument wsdlDocument) {
        Definition definition = wsdlDocument.getDefinitions();
        return WSDLDocumentIdentifier.hasMessageElement(definition) && WSDLDocumentIdentifier.hasPortTypeElement(definition) && WSDLDocumentIdentifier.hasBindingElement(definition) && WSDLDocumentIdentifier.hasServiceElement(definition);
    }

    private static boolean hasMessageElement(Definition definition) {
        Iterator theIterator = definition.getMessages().values().iterator();
        while (theIterator.hasNext()) {
            Message x = (Message)theIterator.next();
            if (x.isUndefined()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPortTypeElement(Definition definition) {
        Iterator theIterator = definition.getPortTypes().values().iterator();
        while (theIterator.hasNext()) {
            PortType x = (PortType)theIterator.next();
            if (x.isUndefined()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasBindingElement(Definition definition) {
        Iterator theIterator = definition.getBindings().values().iterator();
        while (theIterator.hasNext()) {
            Binding x = (Binding)theIterator.next();
            if (x.isUndefined()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasImportElement(Definition definition) {
        return !definition.getImports().isEmpty();
    }

    private static boolean hasServiceElement(Definition definition) {
        return !definition.getServices().isEmpty();
    }
}

