/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.flatpak.launcher.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.cdt.flatpak.launcher.FlatpakCommandLauncherFactory;
import org.eclipse.cdt.flatpak.launcher.FlatpakLaunchPlugin;
import org.eclipse.cdt.internal.flatpak.launcher.ui.preferences.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class FlatpakHeaderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Table hdrTable;
    private TableViewer hdrTableViewer;
    private HeaderContentProvider provider;
    private Button removeButton;
    private List<String> directories;

    public FlatpakHeaderPreferencePage() {
        this.noDefaultAndApplyButton();
        this.provider = new HeaderContentProvider();
    }

    public void init(IWorkbench workbench) {
        this.directories = FlatpakCommandLauncherFactory.getDirs();
    }

    protected Control createContents(Composite parent) {
        Composite page = FlatpakHeaderPreferencePage.createComposite(parent, 1, 2, false, null, -1, -1, 4);
        GridData gd = (GridData)page.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.hdrTable = new Table(page, 68354);
        this.hdrTable.setLinesVisible(true);
        this.hdrTable.setHeaderVisible(true);
        this.hdrTable.addListener(13, (Listener)this);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        this.hdrTable.setLayout((Layout)tableLayout);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.hdrTable.setLayoutData((Object)gd);
        TableColumn directoriesColumn = new TableColumn(this.hdrTable, 0);
        directoriesColumn.setText(Messages.FlatpakDirectories_label);
        this.hdrTableViewer = new TableViewer(this.hdrTable);
        this.hdrTableViewer.setContentProvider((IContentProvider)this.provider);
        this.hdrTableViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.hdrTableViewer.setInput(this.directories);
        Composite buttonBar = FlatpakHeaderPreferencePage.createComposite(page, 1, 1, false, null, -1, -1, 4);
        gd = (GridData)buttonBar.getLayoutData();
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = true;
        this.removeButton = FlatpakHeaderPreferencePage.createPushButton(buttonBar, this, Messages.FlatpakRemoveHeaders_label, Messages.FlatpakRemoveHeaders_tooltip);
        this.removeButton.setEnabled(false);
        return parent;
    }

    private static Composite createComposite(Composite parent, int parentSpan, int numColumns, boolean border, String label, int marginSize, int spacingSize, int verticalAlignment) {
        boolean borderNeeded = border;
        if (label != null) {
            borderNeeded = true;
        }
        int style = 0;
        if (borderNeeded) {
            style |= 0x10;
        }
        Group composite = null;
        if (borderNeeded) {
            composite = new Group(parent, style);
            if (label != null) {
                composite.setText(label);
            }
        } else {
            composite = new Composite(parent, style);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        if (marginSize != -1) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        if (spacingSize != -1) {
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalSpan = parentSpan;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = verticalAlignment;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Button createPushButton(Composite group, Listener listener, String label, String tooltip) {
        Button button = new Button(group, 8);
        button.setText(label);
        if (listener != null) {
            button.addListener(13, listener);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            if (event.widget == this.removeButton) {
                DialogStatus confirmed = new DialogStatus(false);
                Display.getDefault().syncExec(() -> {
                    boolean status = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.FlatpakConfirmRemoval_title, (String)Messages.FlatpakConfirmRemoval_msg);
                    confirmed.setStatus(status);
                });
                if (!confirmed.getStatus()) {
                    return;
                }
                int[] indicies = this.hdrTable.getSelectionIndices();
                IPath pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.flatpak.launcher")).append("HEADERS");
                int idx = indicies.length - 1;
                while (idx >= 0) {
                    String dirPath = this.directories.get(indicies[idx]);
                    File f = pluginPath.append(dirPath).toFile();
                    if (f.exists() && f.isDirectory()) {
                        this.recursiveDelete(f);
                    }
                    this.directories.remove(dirPath);
                    try {
                        FlatpakCommandLauncherFactory.removeDir(dirPath);
                    }
                    catch (IOException e) {
                        FlatpakLaunchPlugin.log(e);
                    }
                    --idx;
                }
                this.hdrTable.remove(indicies);
                this.hdrTable.redraw();
                this.hdrTableViewer.refresh();
            }
            if (this.hdrTable.getSelectionCount() > 0) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    private void recursiveDelete(File dir) {
        File[] contents = dir.listFiles();
        if (contents != null) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.recursiveDelete(f);
                ++n2;
            }
        }
        dir.delete();
    }

    private class DialogStatus {
        private boolean status;

        public DialogStatus(boolean status) {
            this.status = status;
        }

        public void setStatus(boolean status) {
            this.status = status;
        }

        public boolean getStatus() {
            return this.status;
        }
    }

    private final class HeaderContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private HeaderContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return FlatpakHeaderPreferencePage.this.directories.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

