/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.cdt.ui.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.cdt.ui.contentassist.CCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class DOMCompletionProposalComputer
extends ParsingBasedProposalComputer {
    protected List<ICompletionProposal> computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (this.inPreprocessorDirective(context)) {
            if (!this.inPreprocessorKeyword(context)) {
                if (prefix.length() == 0) {
                    try {
                        prefix = context.computeIdentifierPrefix().toString();
                    }
                    catch (BadLocationException exc) {
                        CUIPlugin.log((Throwable)exc);
                    }
                }
                this.addMacroProposals(context, prefix, proposals);
            }
        } else {
            IASTName[] names;
            boolean handleMacros = false;
            IASTName[] iASTNameArray = names = completionNode.getNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IASTCompletionContext astContext;
                IASTName name = iASTNameArray[n2];
                if (name.getTranslationUnit() != null && (astContext = name.getCompletionContext()) != null) {
                    IBinding[] bindings;
                    if (astContext instanceof IASTIdExpression || astContext instanceof IASTNamedTypeSpecifier) {
                        handleMacros = prefix.length() > 0;
                    }
                    if ((bindings = astContext.findBindings(name, !context.isContextInformationStyle())) != null) {
                        IBinding[] iBindingArray = bindings;
                        int n3 = bindings.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IBinding binding = iBindingArray[n4];
                            this.handleBinding(binding, context, prefix, astContext, proposals);
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            if (handleMacros) {
                this.addMacroProposals(context, prefix, proposals);
            }
        }
        return proposals;
    }

    private boolean inPreprocessorKeyword(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            String ppPrefix;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType()) && (ppPrefix = doc.get(partition.getOffset(), offset - partition.getOffset())).matches("\\s*#\\s*\\w*")) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    private boolean inPreprocessorDirective(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType())) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    private void addMacroProposals(CContentAssistInvocationContext context, String prefix, List<ICompletionProposal> proposals) {
        char[] macroName;
        IASTPreprocessorMacroDefinition element;
        int n;
        int n2;
        IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray;
        char[] prefixChars = prefix.toCharArray();
        boolean matchPrefix = !context.isContextInformationStyle();
        IASTCompletionNode completionNode = context.getCompletionNode();
        IASTPreprocessorMacroDefinition[] macros = completionNode.getTranslationUnit().getMacroDefinitions();
        if (macros != null) {
            iASTPreprocessorMacroDefinitionArray = macros;
            n2 = macros.length;
            n = 0;
            while (n < n2) {
                element = iASTPreprocessorMacroDefinitionArray[n];
                macroName = element.getName().toCharArray();
                if (CharArrayUtils.equals((char[])macroName, (int)0, (int)(matchPrefix ? prefixChars.length : macroName.length), (char[])prefixChars, (boolean)true)) {
                    this.handleMacro(element, context, prefix, proposals);
                }
                ++n;
            }
        }
        if ((macros = completionNode.getTranslationUnit().getBuiltinMacroDefinitions()) != null) {
            iASTPreprocessorMacroDefinitionArray = macros;
            n2 = macros.length;
            n = 0;
            while (n < n2) {
                element = iASTPreprocessorMacroDefinitionArray[n];
                macroName = element.getName().toCharArray();
                if (CharArrayUtils.equals((char[])macroName, (int)0, (int)(matchPrefix ? prefixChars.length : macroName.length), (char[])prefixChars, (boolean)true)) {
                    this.handleMacro(element, context, prefix, proposals);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleMacro(IASTPreprocessorMacroDefinition macro, CContentAssistInvocationContext context, String prefix, List<ICompletionProposal> proposals) {
        String macroName = macro.getName().toString();
        int baseRelevance = this.computeBaseRelevance(prefix, macroName);
        Image image = this.getImage(CElementImageProvider.getMacroImageDescriptor());
        IASTPreprocessorMacroDefinition iASTPreprocessorMacroDefinition = macro;
        if (iASTPreprocessorMacroDefinition instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            void functionMacro;
            IASTPreprocessorFunctionStyleMacroDefinition iASTPreprocessorFunctionStyleMacroDefinition = (IASTPreprocessorFunctionStyleMacroDefinition)iASTPreprocessorMacroDefinition;
            IASTPreprocessorFunctionStyleMacroDefinition cfr_ignored_0 = (IASTPreprocessorFunctionStyleMacroDefinition)iASTPreprocessorMacroDefinition;
            StringBuilder repStringBuff = new StringBuilder();
            repStringBuff.append(macroName);
            repStringBuff.append('(');
            StringBuilder args = new StringBuilder();
            IASTFunctionStyleMacroParameter[] params = functionMacro.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    if (i > 0) {
                        args.append(", ");
                    }
                    args.append(params[i].getParameter());
                    ++i;
                }
            }
            String argString = args.toString();
            StringBuilder descStringBuff = new StringBuilder(repStringBuff.toString());
            descStringBuff.append(argString);
            descStringBuff.append(')');
            repStringBuff.append(')');
            String repString = repStringBuff.toString();
            String descString = descStringBuff.toString();
            CCompletionProposal proposal = this.createProposal(repString, descString, prefix.length(), image, baseRelevance + 15, context, this.getCElement(macro), macro.getName().toString());
            if (!context.isContextInformationStyle()) {
                proposal.setCursorPosition(repString.length() - 1);
            }
            if (argString.length() > 0) {
                CProposalContextInformation info = new CProposalContextInformation(image, descString, argString);
                info.setContextInformationPosition(context.getContextInformationOffset());
                proposal.setContextInformation((IContextInformation)info);
            }
            proposals.add((ICompletionProposal)proposal);
        } else {
            proposals.add((ICompletionProposal)this.createProposal(macroName, macroName, prefix.length(), image, baseRelevance + 15, context, this.getCElement(macro), macro.getName().toString()));
        }
    }

    protected void handleBinding(IBinding binding, CContentAssistInvocationContext cContext, String prefix, IASTCompletionContext astContext, List<ICompletionProposal> proposals) {
        if ((binding instanceof CPPImplicitFunction || binding instanceof CPPImplicitTypedef) && !(binding instanceof CPPImplicitMethod)) {
            return;
        }
        if (!this.isAnonymousBinding(binding)) {
            String name = binding.getName();
            int baseRelevance = this.computeBaseRelevance(prefix, name);
            if (binding instanceof ICPPClassType) {
                this.handleClass((ICPPClassType)binding, astContext, cContext, baseRelevance, proposals);
            } else if (binding instanceof IFunction) {
                this.handleFunction((IFunction)binding, cContext, baseRelevance, proposals);
            } else if (!cContext.isContextInformationStyle()) {
                if (binding instanceof IVariable) {
                    this.handleVariable((IVariable)binding, cContext, baseRelevance, proposals);
                } else if (binding instanceof ITypedef) {
                    proposals.add((ICompletionProposal)this.createProposal(name, name, this.getImage(binding), baseRelevance + 60, cContext, this.getCElement(binding), binding.getName()));
                } else if (binding instanceof ICPPNamespace) {
                    this.handleNamespace((ICPPNamespace)binding, astContext, cContext, baseRelevance, proposals);
                } else if (binding instanceof IEnumeration) {
                    proposals.add((ICompletionProposal)this.createProposal(name, name, this.getImage(binding), baseRelevance + 30, cContext, this.getCElement(binding), binding.getName()));
                } else if (binding instanceof IEnumerator) {
                    proposals.add((ICompletionProposal)this.createProposal(name, name, this.getImage(binding), baseRelevance + 40, cContext, this.getCElement(binding), binding.getName()));
                } else {
                    proposals.add((ICompletionProposal)this.createProposal(name, name, this.getImage(binding), baseRelevance + 20, cContext, this.getCElement(binding), binding.getName()));
                }
            }
        }
    }

    private boolean isAnonymousBinding(IBinding binding) {
        char[] name = binding.getNameCharArray();
        return name.length == 0 || name[0] == '{';
    }

    /*
     * WARNING - void declaration
     */
    private void handleClass(ICPPClassType classType, IASTCompletionContext astContext, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        if (context.isContextInformationStyle()) {
            try {
                ICPPConstructor[] constructors;
                ICPPConstructor[] iCPPConstructorArray = constructors = classType.getConstructors();
                int n = constructors.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPConstructor constructor = iCPPConstructorArray[n2];
                    this.handleFunction((IFunction)constructor, context, baseRelevance, proposals);
                    ++n2;
                }
            }
            catch (Exception e) {
                this.handle(e);
            }
        } else {
            int relevance = 0;
            try {
                switch (classType.getKey()) {
                    case 3: {
                        relevance = 90;
                        break;
                    }
                    case 1: {
                        relevance = 80;
                        break;
                    }
                    case 2: {
                        relevance = 70;
                    }
                }
            }
            catch (Exception e) {
                this.handle(e);
            }
            IASTCompletionContext iASTCompletionContext = astContext;
            if (iASTCompletionContext instanceof IASTName) {
                void name;
                IASTName e = (IASTName)iASTCompletionContext;
                IASTName cfr_ignored_0 = (IASTName)iASTCompletionContext;
                if (!(astContext instanceof ICPPASTQualifiedName) && name.getParent() instanceof IASTDeclarator) {
                    proposals.add((ICompletionProposal)this.createProposal(classType.getName() + "::", classType.getName(), this.getImage((IBinding)classType), baseRelevance + relevance, context, this.getCElement(classType), classType.getName()));
                }
            }
            proposals.add((ICompletionProposal)this.createProposal(classType.getName(), classType.getName(), this.getImage((IBinding)classType), baseRelevance + 90, context, this.getCElement(classType), classType.getName()));
        }
    }

    private void handle(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
    }

    private void handleFunction(IFunction function, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        Image image = this.getImage((IBinding)function);
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(function.getName());
        repStringBuff.append('(');
        StringBuilder dispargs = new StringBuilder();
        StringBuilder idargs = new StringBuilder();
        String returnTypeStr = null;
        try {
            IType returnType;
            IFunctionType functionType;
            IParameter[] params = function.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    IType paramType = params[i].getType();
                    if (i > 0) {
                        dispargs.append(',');
                        idargs.append(',');
                    }
                    dispargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                    idargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                    String paramName = params[i].getName();
                    if (paramName != null && paramName.length() > 0) {
                        dispargs.append(' ');
                        dispargs.append(paramName);
                    }
                    ++i;
                }
                if (function.takesVarArgs()) {
                    if (params.length > 0) {
                        dispargs.append(',');
                        idargs.append(',');
                    }
                    dispargs.append("...");
                    idargs.append("...");
                } else if (params.length == 0) {
                    dispargs.append("void");
                    idargs.append("void");
                }
            }
            if ((functionType = function.getType()) != null && (returnType = functionType.getReturnType()) != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)returnType, (boolean)false);
            }
        }
        catch (Exception params) {
            // empty catch block
        }
        String dispargString = dispargs.toString();
        String idargString = idargs.toString();
        StringBuilder dispStringBuff = new StringBuilder(repStringBuff.toString());
        dispStringBuff.append(dispargString);
        dispStringBuff.append(')');
        if (returnTypeStr != null && returnTypeStr.length() > 0) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuilder idStringBuff = new StringBuilder(repStringBuff.toString());
        idStringBuff.append(idargString);
        idStringBuff.append(')');
        String idString = idStringBuff.toString();
        repStringBuff.append(')');
        String repString = repStringBuff.toString();
        int relevance = function instanceof ICPPMethod ? 120 : 100;
        CCompletionProposal proposal = this.createProposal(repString, dispString, idString, context.getCompletionNode().getLength(), image, baseRelevance + relevance, context, this.getCElement(function), function.getName());
        if (!context.isContextInformationStyle()) {
            proposal.setCursorPosition(repString.length() - 1);
        }
        if (dispargString.length() > 0) {
            CProposalContextInformation info = new CProposalContextInformation(image, dispString, dispargString);
            info.setContextInformationPosition(context.getContextInformationOffset());
            proposal.setContextInformation((IContextInformation)info);
        }
        proposals.add((ICompletionProposal)proposal);
    }

    private void handleVariable(IVariable variable, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(variable.getName());
        String returnTypeStr = "<unknown>";
        try {
            IType varType = variable.getType();
            if (varType != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)varType, (boolean)false);
            }
        }
        catch (Exception varType) {
            // empty catch block
        }
        StringBuilder dispStringBuff = new StringBuilder(repStringBuff.toString());
        if (returnTypeStr != null) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuilder idStringBuff = new StringBuilder(repStringBuff.toString());
        String idString = idStringBuff.toString();
        String repString = repStringBuff.toString();
        Image image = this.getImage((IBinding)variable);
        int relevance = DOMCompletionProposalComputer.isLocalVariable(variable) ? 140 : (DOMCompletionProposalComputer.isField(variable) ? 130 : 110);
        CCompletionProposal proposal = this.createProposal(repString, dispString, idString, context.getCompletionNode().getLength(), image, baseRelevance + relevance, context, this.getCElement(variable), variable.getName());
        proposals.add((ICompletionProposal)proposal);
    }

    private static boolean isField(IVariable variable) {
        return variable instanceof IField;
    }

    private static boolean isLocalVariable(IVariable variable) {
        try {
            return DOMCompletionProposalComputer.isLocalScope(variable.getScope());
        }
        catch (DOMException exc) {
            return false;
        }
    }

    private static boolean isLocalScope(IScope scope) {
        while (scope != null) {
            if (scope instanceof ICPPFunctionScope || scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                return true;
            }
            try {
                scope = scope.getParent();
            }
            catch (DOMException e) {
                scope = null;
            }
        }
        return false;
    }

    private void handleNamespace(ICPPNamespace namespace, IASTCompletionContext astContext, CContentAssistInvocationContext cContext, int baseRelevance, List<ICompletionProposal> proposals) {
        if (astContext instanceof ICPPASTQualifiedName) {
            IASTCompletionContext parent = ((ICPPASTQualifiedName)astContext).getCompletionContext();
            this.handleNamespace(namespace, parent, cContext, baseRelevance, proposals);
            return;
        }
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(namespace.getName());
        if (!(astContext instanceof ICPPASTUsingDeclaration) && !(astContext instanceof ICPPASTUsingDirective)) {
            repStringBuff.append("::");
        }
        String repString = repStringBuff.toString();
        proposals.add((ICompletionProposal)this.createProposal(repString, namespace.getName(), this.getImage((IBinding)namespace), baseRelevance + 50, cContext, this.getCElement(namespace), namespace.getName()));
    }

    private ICElement getCElement(ICPPNamespace namespace) {
        return null;
    }

    private ICElement getCElement(IVariable variable) {
        return null;
    }

    private ICElement getCElement(IFunction function) {
        return null;
    }

    private ICElement getCElement(ICPPClassType classType) {
        return null;
    }

    private ICElement getCElement(IASTPreprocessorMacroDefinition macro) {
        if (macro != null && macro.getFileLocation() != null) {
            try {
                return this.getCElement(macro.getFileLocation().getFileName(), macro.getFileLocation().getNodeOffset());
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "Unable to get CElement for Macro", (Throwable)e));
            }
        }
        return null;
    }

    private ICElement getCElement(IBinding binding) {
        IASTNode[] declarations;
        IASTNode definition = null;
        if (binding instanceof ICInternalBinding) {
            declarations = ((ICInternalBinding)binding).getDeclarations();
            if (declarations != null && declarations.length > 0) {
                definition = declarations[0];
            }
        } else if (binding instanceof ICPPInternalBinding && (declarations = ((ICPPInternalBinding)binding).getDeclarations()) != null && declarations.length > 0) {
            definition = declarations[0];
        }
        if (definition != null && definition.getFileLocation() != null) {
            try {
                return this.getCElement(definition.getFileLocation().getFileName(), definition.getFileLocation().getNodeOffset());
            }
            catch (CModelException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "Unable to get CElement for Binding", (Throwable)e));
            }
        }
        return null;
    }

    private ICElement getCElement(String filename, int offset) throws CModelException {
        IFile res = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filename));
        ITranslationUnit cu = null;
        if (res instanceof IFile) {
            IFile file = res;
            if (CoreModel.isValidTranslationUnitName(null, (String)file.getName())) {
                cu = CoreModelUtil.findTranslationUnit((IFile)file);
            } else {
                return null;
            }
        }
        if (cu != null) {
            ICElement ce = cu.getElementAtOffset(offset);
            return ce;
        }
        return null;
    }

    private CCompletionProposal createProposal(String repString, String dispString, Image image, int relevance, CContentAssistInvocationContext context, ICElement element, String bindingName) {
        return this.createProposal(repString, dispString, null, context.getCompletionNode().getLength(), image, relevance, context, element, bindingName);
    }

    private CCompletionProposal createProposal(String repString, String dispString, int prefixLength, Image image, int relevance, CContentAssistInvocationContext context, ICElement element, String bindingName) {
        return this.createProposal(repString, dispString, null, prefixLength, image, relevance, context, element, bindingName);
    }

    private CCompletionProposal createProposal(String repString, String dispString, String idString, int prefixLength, Image image, int relevance, CContentAssistInvocationContext context, ICElement element, String bindingName) {
        int parseOffset = context.getParseOffset();
        int invocationOffset = context.getInvocationOffset();
        boolean doReplacement = !context.isContextInformationStyle();
        int repLength = doReplacement ? prefixLength : 0;
        int repOffset = doReplacement ? parseOffset - repLength : invocationOffset;
        repString = doReplacement ? repString : "";
        return new CCompletionProposal(repString, repOffset, repLength, image, dispString, idString, relevance, context.getViewer(), element, bindingName);
    }

    private Image getImage(ImageDescriptor desc) {
        return desc != null ? CommonImages.getImage((ImageDescriptor)desc) : null;
    }

    private Image getImage(IBinding binding) {
        ImageDescriptor imageDescriptor = null;
        try {
            IBinding[] delegates;
            if (binding instanceof ITypedef) {
                imageDescriptor = CElementImageProvider.getTypedefImageDescriptor();
            } else if (binding instanceof ICompositeType) {
                if (((ICompositeType)binding).getKey() == 3 || binding instanceof ICPPClassTemplate) {
                    imageDescriptor = CElementImageProvider.getClassImageDescriptor();
                } else if (((ICompositeType)binding).getKey() == 1) {
                    imageDescriptor = CElementImageProvider.getStructImageDescriptor();
                } else if (((ICompositeType)binding).getKey() == 2) {
                    imageDescriptor = CElementImageProvider.getUnionImageDescriptor();
                }
            } else if (binding instanceof ICPPMethod) {
                imageDescriptor = switch (((ICPPMethod)binding).getVisibility()) {
                    case 3 -> CElementImageProvider.getMethodImageDescriptor((ASTAccessVisibility)ASTAccessVisibility.PRIVATE);
                    case 2 -> CElementImageProvider.getMethodImageDescriptor((ASTAccessVisibility)ASTAccessVisibility.PROTECTED);
                    default -> CElementImageProvider.getMethodImageDescriptor((ASTAccessVisibility)ASTAccessVisibility.PUBLIC);
                };
            } else if (binding instanceof IFunction) {
                imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
            } else if (binding instanceof ICPPField) {
                imageDescriptor = switch (((ICPPField)binding).getVisibility()) {
                    case 3 -> CElementImageProvider.getFieldImageDescriptor((ASTAccessVisibility)ASTAccessVisibility.PRIVATE);
                    case 2 -> CElementImageProvider.getFieldImageDescriptor((ASTAccessVisibility)ASTAccessVisibility.PROTECTED);
                    default -> CElementImageProvider.getFieldImageDescriptor((ASTAccessVisibility)ASTAccessVisibility.PUBLIC);
                };
            } else if (binding instanceof IField) {
                imageDescriptor = CElementImageProvider.getFieldImageDescriptor((ASTAccessVisibility)ASTAccessVisibility.PUBLIC);
            } else if (binding instanceof IVariable) {
                imageDescriptor = CElementImageProvider.getVariableImageDescriptor();
            } else if (binding instanceof IEnumeration) {
                imageDescriptor = CElementImageProvider.getEnumerationImageDescriptor();
            } else if (binding instanceof IEnumerator) {
                imageDescriptor = CElementImageProvider.getEnumeratorImageDescriptor();
            } else if (binding instanceof ICPPNamespace) {
                imageDescriptor = CElementImageProvider.getNamespaceImageDescriptor();
            } else if (binding instanceof ICPPFunctionTemplate) {
                imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
            } else if (binding instanceof ICPPUsingDeclaration && (delegates = ((ICPPUsingDeclaration)binding).getDelegates()).length > 0) {
                return this.getImage(delegates[0]);
            }
        }
        catch (Exception e) {
            this.handle(e);
        }
        return imageDescriptor != null ? CommonImages.getImage((ImageDescriptor)imageDescriptor) : null;
    }
}

