/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.OpenFileAction;

public class OpenCElementAction
extends OpenFileAction {
    private ICElement fOpenElement;

    public OpenCElementAction(IWorkbenchPage page) {
        super(page);
    }

    public void run() {
        if (this.fOpenElement != null) {
            try {
                IEditorPart part = EditorUtility.openInEditor(this.fOpenElement);
                if (this.fOpenElement instanceof ISourceReference && !(this.fOpenElement instanceof ITranslationUnit)) {
                    EditorUtility.revealInEditor(part, this.fOpenElement);
                }
            }
            catch (CoreException exc) {
                CUIPlugin.log(exc.getStatus());
            }
        } else {
            super.run();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean updateSelection(IStructuredSelection selection) {
        this.fOpenElement = null;
        if (selection.size() == 1) {
            Object object;
            Object element = selection.getFirstElement();
            if (!(element instanceof ICElement) && element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(ICElement.class);
            }
            if ((object = element) instanceof ICElement) {
                void cElement;
                ICElement iCElement = (ICElement)object;
                ICElement cfr_ignored_0 = (ICElement)object;
                if (this.canOpenCElement((ICElement)cElement)) {
                    this.fOpenElement = (ICElement)element;
                }
            }
        }
        return this.fOpenElement != null || super.updateSelection(selection);
    }

    /*
     * WARNING - void declaration
     */
    private boolean canOpenCElement(ICElement element) {
        ICElement iCElement = element;
        if (iCElement instanceof ISourceReference) {
            void sourceReference;
            ISourceReference iSourceReference = (ISourceReference)iCElement;
            ISourceReference cfr_ignored_0 = (ISourceReference)iCElement;
            if (sourceReference.getTranslationUnit() == null) {
                return false;
            }
            ICElement iCElement2 = element;
            if (iCElement2 instanceof ITranslationUnit) {
                void tu;
                ITranslationUnit iTranslationUnit = (ITranslationUnit)iCElement2;
                ITranslationUnit cfr_ignored_1 = (ITranslationUnit)iCElement2;
                if (tu.getResource() == null && !tu.exists()) {
                    return false;
                }
            }
            return true;
        }
        if (element instanceof IBinary) {
            IResource resource = element.getResource();
            return resource != null && resource.exists();
        }
        return false;
    }
}

