/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.manipulation.ScriptManipulationPlugin;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.text.edits.UndoEdit;

public class UndoSourceModuleChange
extends UndoTextFileChange {
    private ISourceModule fCUnit;

    public UndoSourceModuleChange(String name, ISourceModule unit, UndoEdit undo, ContentStamp stampToRestore, int saveMode) throws CoreException {
        super(name, UndoSourceModuleChange.getFile(unit), undo, stampToRestore, saveMode);
        this.fCUnit = unit;
    }

    private static IFile getFile(ISourceModule cunit) throws CoreException {
        IFile file = (IFile)cunit.getResource();
        if (file == null) {
            throw new CoreException((IStatus)new Status(4, ScriptManipulationPlugin.getPluginId(), 4, MessageFormat.format(RefactoringCoreMessages.UndoSourceModuleChange_no_resource, cunit.getElementName()), null));
        }
        return file;
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) throws CoreException {
        return new UndoSourceModuleChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy(null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        try {
            Change change = super.perform((IProgressMonitor)new SubProgressMonitor(pm, 1));
            return change;
        }
        finally {
            this.fCUnit.discardWorkingCopy();
        }
    }
}

