/*******************************************************************************
 * Copyright (c) 2000, 2017 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.internal.ui.scriptview;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.action.Action;

/**
 * Collapse all nodes.
 */
class CollapseAllAction extends Action {

	private ScriptExplorerPart fPackageExplorer;

	CollapseAllAction(ScriptExplorerPart part) {
		super(ScriptMessages.CollapseAllAction_label);
		setDescription(ScriptMessages.CollapseAllAction_description);
		setToolTipText(ScriptMessages.CollapseAllAction_tooltip);
		DLTKPluginImages.setLocalImageDescriptors(this, "collapseall.png"); //$NON-NLS-1$

		fPackageExplorer= part;
		if (DLTKCore.DEBUG) {
			System.err.println("Add help support here..."); //$NON-NLS-1$
		}

		//PlatformUI.getWorkbench().getHelpSystem().setHelp(this, IScriptHelpContextIds.COLLAPSE_ALL_ACTION);
	}

	@Override
	public void run() {
		fPackageExplorer.collapseAll();
	}
}
