/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.hyperlinking;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.util.ITextRegion;

public class DotHyperlinkHelper
extends HyperlinkHelper {
    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        EObject eObject = this.getEObjectAtOffsetHelper().resolveElementAt(resource, offset);
        if (eObject instanceof NodeId) {
            NodeId nodeId = (NodeId)eObject;
            IRegion hyperlinkRegion = this.getHyperlinkRegion(nodeId);
            EObject container = nodeId.eContainer();
            if (container instanceof EdgeStmtNode || container instanceof EdgeRhsNode) {
                this.createHyperlinkToNodeDefinition(resource, hyperlinkRegion, nodeId, acceptor);
            }
        }
    }

    private void createHyperlinkToNodeDefinition(XtextResource resource, IRegion hyperlinkRegion, NodeId nodeId, IHyperlinkAcceptor acceptor) {
        NodeId targetSemanticObject = DotAstHelper.getNodeId((NodeId)nodeId);
        if (targetSemanticObject != null) {
            this.createHyperlinksTo(resource, (Region)hyperlinkRegion, (EObject)targetSemanticObject, acceptor);
        }
    }

    private IRegion getHyperlinkRegion(NodeId nodeId) {
        ITextRegion textRegion = NodeModelUtils.findActualNodeFor((EObject)nodeId).getTextRegion();
        int offset = textRegion.getOffset();
        int length = textRegion.getLength();
        if (nodeId.getName().getType() == ID.Type.QUOTED_STRING) {
            ++offset;
            length -= 2;
        }
        return new Region(offset, length);
    }
}

