/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.labeling;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhs;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.label.DefaultDescriptionLabelProvider;

public class DotDescriptionLabelProvider
extends DefaultDescriptionLabelProvider {
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;

    public Object image(IEObjectDescription element) {
        String result = "";
        EObject eObject = this.getEObject(element);
        if (eObject instanceof NodeId) {
            EObject container = eObject.eContainer();
            if (container instanceof NodeStmt) {
                result = "node.png";
            }
            if (container instanceof EdgeStmtNode || container instanceof EdgeRhs) {
                result = "edge.png";
            }
        }
        return !result.isEmpty() ? result : super.image(element);
    }

    public Object text(IEObjectDescription element) {
        String resultText;
        StringBuilder result = new StringBuilder();
        EObject eObject = this.getEObject(element);
        if (eObject instanceof NodeId) {
            NodeId node1 = (NodeId)eObject;
            EObject container = eObject.eContainer();
            if (container instanceof NodeStmt) {
                result.append(node1.getName().toString());
                result.append(": Node");
            }
            EdgeStmtNode firstNode = null;
            if (container instanceof EdgeStmtNode) {
                firstNode = (EdgeStmtNode)container;
            }
            if (container instanceof EdgeRhs) {
                firstNode = (EdgeStmtNode)container.eContainer();
            }
            if (firstNode != null) {
                result.append(firstNode.getNode().getName().toString());
                for (EdgeRhs edgeRhs : firstNode.getEdgeRHS()) {
                    if (!(edgeRhs instanceof EdgeRhsNode)) continue;
                    result.append(" ");
                    result.append(edgeRhs.getOp());
                    result.append(" ");
                    NodeId node = ((EdgeRhsNode)edgeRhs).getNode();
                    result.append(node.getName().toString());
                }
                result.append(": Edge");
            }
        }
        return !(resultText = result.toString()).isEmpty() ? DotEditorUtils.style(resultText, new Object[0]) : super.text(element);
    }

    private EObject getEObject(IEObjectDescription element) {
        EObject eObject = element.getEObjectOrProxy();
        if (eObject.eIsProxy()) {
            XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
            eObject = EcoreUtil.resolve((EObject)eObject, (ResourceSet)resourceSet);
        }
        return eObject;
    }
}

