/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gef.MouseWheelHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ViewportExposeHelper;
import org.eclipse.gef.editparts.ViewportMouseWheelHelper;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.ui.palette.editparts.IPinnableEditPart;
import org.eclipse.gef.ui.palette.editparts.PaletteAnimator;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class DrawerEditPart
extends PaletteEditPart
implements IPinnableEditPart {
    private static final String PROPERTY_EXPANSION_STATE = "expansion";
    private static final String PROPERTY_PINNED_STATE = "pinned";

    public DrawerEditPart(PaletteDrawer drawer) {
        super(drawer);
    }

    @Override
    public IFigure createFigure() {
        DrawerFigure fig = new DrawerFigure(this.getViewer().getControl()){

            @Override
            IFigure buildTooltip() {
                return DrawerEditPart.this.createToolTip();
            }
        };
        fig.setExpanded(this.getModel().isInitiallyOpen());
        fig.setPinned(this.getModel().isInitiallyPinned());
        fig.getCollapseToggle().addFocusListener((FocusListener)new FocusListener.Stub(){

            public void focusGained(FocusEvent fe) {
                DrawerEditPart.this.getViewer().select(DrawerEditPart.this);
            }
        });
        fig.getScrollpane().getContents().addLayoutListener((LayoutListener)this.getPaletteAnimator());
        return fig;
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key == ExposeHelper.class) {
            ViewportExposeHelper helper = new ViewportExposeHelper(this);
            helper.setMinimumFrameCount(6);
            helper.setMargin(new Insets(7, 0, 7, 0));
            return key.cast(helper);
        }
        if (key == MouseWheelHelper.class) {
            return key.cast(new ViewportMouseWheelHelper(this));
        }
        return super.getAdapter(key);
    }

    private PaletteAnimator getPaletteAnimator() {
        return (PaletteAnimator)((Object)this.getViewer().getEditPartRegistry().get(PaletteAnimator.class));
    }

    @Override
    public PaletteDrawer getModel() {
        return (PaletteDrawer)super.getModel();
    }

    public DrawerFigure getFigure() {
        return (DrawerFigure)super.getFigure();
    }

    @Override
    public IFigure getContentPane() {
        return this.getFigure().getContentPane();
    }

    @Override
    public boolean isExpanded() {
        return this.getFigure().isExpanded();
    }

    @Override
    public boolean isPinnedOpen() {
        return this.getFigure().isPinnedOpen();
    }

    @Override
    protected boolean nameNeededInToolTip() {
        return false;
    }

    @Override
    public boolean canBePinned() {
        return this.getFigure().isPinShowing();
    }

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            @Override
            public void getDescription(AccessibleEvent e) {
                e.result = DrawerEditPart.this.getModel().getDescription();
            }

            @Override
            public void getName(AccessibleEvent e) {
                e.result = DrawerEditPart.this.getModel().getLabel();
            }

            @Override
            public void getRole(AccessibleControlEvent e) {
                e.detail = 35;
            }

            @Override
            public void getState(AccessibleControlEvent e) {
                super.getState(e);
                e.detail = e.detail | (DrawerEditPart.this.isExpanded() ? 512 : 1024);
            }
        };
    }

    @Override
    protected void refreshVisuals() {
        this.getFigure().setToolTip(this.createToolTip());
        ImageDescriptor img = this.getModel().getSmallIcon();
        if (img == null && this.getModel().showDefaultIcon()) {
            img = InternalImages.DESC_FOLDER_OPEN;
        }
        this.setImageDescriptor(img);
        this.getFigure().setTitle(this.getModel().getLabel());
        this.getFigure().setLayoutMode(this.getLayoutSetting());
        boolean showPin = this.getPreferenceSource().getAutoCollapseSetting() == 0;
        this.getFigure().showPin(showPin);
        Color background = this.getModel().getDrawerType().equals("$Palette Template") ? PaletteColorUtil.WIDGET_LIST_BACKGROUND : null;
        this.getFigure().getScrollpane().setBackgroundColor(background);
    }

    @Override
    protected void register() {
        super.register();
        this.getPaletteAnimator().addDrawer(this);
        this.getFigure().addLayoutListener((LayoutListener)this.getPaletteAnimator());
    }

    @Override
    public void restoreState(IMemento memento) {
        this.setExpanded(Boolean.parseBoolean(memento.getString(PROPERTY_EXPANSION_STATE)));
        this.setPinnedOpen(Boolean.parseBoolean(memento.getString(PROPERTY_PINNED_STATE)));
        RangeModel rModel = this.getFigure().getScrollpane().getViewport().getVerticalRangeModel();
        rModel.setMinimum(memento.getInteger("minimum").intValue());
        rModel.setMaximum(memento.getInteger("maximum").intValue());
        rModel.setExtent(memento.getInteger("extent").intValue());
        rModel.setValue(memento.getInteger("value").intValue());
        super.restoreState(memento);
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putString(PROPERTY_EXPANSION_STATE, Boolean.toString(this.isExpanded()));
        memento.putString(PROPERTY_PINNED_STATE, Boolean.toString(this.isPinnedOpen()));
        RangeModel rModel = this.getFigure().getScrollpane().getViewport().getVerticalRangeModel();
        memento.putInteger("minimum", rModel.getMinimum());
        memento.putInteger("maximum", rModel.getMaximum());
        memento.putInteger("extent", rModel.getExtent());
        memento.putInteger("value", rModel.getValue());
        super.saveState(memento);
    }

    public void setExpanded(boolean expanded) {
        this.getFigure().setExpanded(expanded);
    }

    @Override
    protected void setImageInFigure(Image image) {
        this.getFigure().setTitleIcon(image);
    }

    @Override
    public void setPinnedOpen(boolean pinned) {
        this.getFigure().setPinned(pinned);
    }

    @Override
    public void setSelected(int value) {
        super.setSelected(value);
        this.getFigure().getCollapseToggle().requestFocus();
    }

    @Override
    protected void unregister() {
        this.getPaletteAnimator().removeDrawer(this);
        super.unregister();
    }
}

