/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.chess;

import org.eclipse.graphiti.examples.mm.chess.Board;
import org.eclipse.graphiti.examples.mm.chess.Colors;
import org.eclipse.graphiti.examples.mm.chess.Files;
import org.eclipse.graphiti.examples.mm.chess.Piece;
import org.eclipse.graphiti.examples.mm.chess.Ranks;
import org.eclipse.graphiti.examples.mm.chess.Square;
import org.eclipse.graphiti.examples.mm.chess.Types;

public final class MoveUtil {
    public static final String PROPERTY_MOVE = "move";

    private MoveUtil() {
    }

    public static boolean isMoveAllowed(Piece piece, Square sourceSquare, Square targetSquare) {
        if (targetSquare.getPiece() != null && targetSquare.getPiece().getOwner().equals((Object)piece.getOwner())) {
            return false;
        }
        int fileSteps = targetSquare.getFile().getValue() - sourceSquare.getFile().getValue();
        int rankSteps = targetSquare.getRank().getValue() - sourceSquare.getRank().getValue();
        if (Types.PAWN.equals((Object)piece.getType())) {
            if (fileSteps == 0) {
                if (Colors.LIGHT.equals((Object)piece.getOwner())) {
                    if (rankSteps == 1 || rankSteps == 2 && Ranks.TWO.equals((Object)sourceSquare.getRank()) && sourceSquare.getBoard().getSquare(Ranks.THREE, sourceSquare.getFile()).getPiece() == null) {
                        return targetSquare.getPiece() == null;
                    }
                } else if (rankSteps == -1 || rankSteps == -2 && Ranks.SEVEN.equals((Object)sourceSquare.getRank()) && sourceSquare.getBoard().getSquare(Ranks.SIX, sourceSquare.getFile()).getPiece() == null) {
                    return targetSquare.getPiece() == null;
                }
            } else if (fileSteps == 1 || fileSteps == -1) {
                if (Colors.LIGHT.equals((Object)piece.getOwner())) {
                    if (rankSteps == 1) {
                        return targetSquare.getPiece() != null && targetSquare.getPiece().getOwner() != piece.getOwner();
                    }
                } else if (rankSteps == -1) {
                    return targetSquare.getPiece() != null && targetSquare.getPiece().getOwner() != piece.getOwner();
                }
            }
            return false;
        }
        if (Types.KING.equals((Object)piece.getType())) {
            if (rankSteps >= -1 && rankSteps <= 1 && fileSteps >= -1 && fileSteps <= 1) {
                return targetSquare.getPiece() == null || targetSquare.getPiece().getOwner() != piece.getOwner();
            }
            return false;
        }
        if (Types.ROOK.equals((Object)piece.getType())) {
            return MoveUtil.allowMovingToSides(sourceSquare, targetSquare, fileSteps, rankSteps);
        }
        if (Types.BISHOP.equals((Object)piece.getType())) {
            return MoveUtil.allowDiagonalMoving(sourceSquare, targetSquare, fileSteps, rankSteps);
        }
        if (Types.QUEEN.equals((Object)piece.getType())) {
            return MoveUtil.allowMovingToSides(sourceSquare, targetSquare, fileSteps, rankSteps) || MoveUtil.allowDiagonalMoving(sourceSquare, targetSquare, fileSteps, rankSteps);
        }
        if (Types.KNIGHT.equals((Object)piece.getType())) {
            return Math.abs(rankSteps) == 2 && Math.abs(fileSteps) == 1 || Math.abs(rankSteps) == 1 && Math.abs(fileSteps) == 2;
        }
        throw new IllegalStateException("Invalid Piece type: " + (Object)((Object)piece.getType()));
    }

    private static boolean allowMovingToSides(Square sourceSquare, Square targetSquare, int fileGap, int rankGap) {
        Board board = sourceSquare.getBoard();
        if (rankGap == 0) {
            int from = Math.min(sourceSquare.getFile().getValue(), targetSquare.getFile().getValue());
            int to = Math.max(sourceSquare.getFile().getValue(), targetSquare.getFile().getValue());
            int i = from + 1;
            while (i < to) {
                if (board.getSquare(sourceSquare.getRank(), Files.get(i)).getPiece() != null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (fileGap == 0) {
            int from = Math.min(sourceSquare.getRank().getValue(), targetSquare.getRank().getValue());
            int to = Math.max(sourceSquare.getRank().getValue(), targetSquare.getRank().getValue());
            int i = from + 1;
            while (i < to) {
                if (board.getSquare(Ranks.get(i), sourceSquare.getFile()).getPiece() != null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean allowDiagonalMoving(Square sourceSquare, Square targetSquare, int fileGap, int rankGap) {
        Board board = sourceSquare.getBoard();
        if (Math.abs(rankGap) == Math.abs(fileGap)) {
            int fromRank = Math.min(sourceSquare.getRank().getValue(), targetSquare.getRank().getValue());
            int toRank = Math.max(sourceSquare.getRank().getValue(), targetSquare.getRank().getValue());
            int fileDirection = 1;
            if (sourceSquare.getFile().getValue() > targetSquare.getFile().getValue()) {
                fileDirection = -1;
            }
            int i = 1;
            while (i < toRank - fromRank) {
                if (board.getSquare(Ranks.get(fromRank + i), Files.get(sourceSquare.getFile().getValue() + i * fileDirection)).getPiece() != null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

