/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.astview.ASTViewImages;
import org.eclipse.jdt.astview.ASTViewPlugin;
import org.eclipse.jdt.astview.EditorUtility;
import org.eclipse.jdt.astview.TreeInfoCollector;
import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.astview.views.ASTViewContentProvider;
import org.eclipse.jdt.astview.views.ASTViewLabelProvider;
import org.eclipse.jdt.astview.views.Binding;
import org.eclipse.jdt.astview.views.DynamicAttributeProperty;
import org.eclipse.jdt.astview.views.DynamicBindingProperty;
import org.eclipse.jdt.astview.views.Error;
import org.eclipse.jdt.astview.views.ExceptionAttribute;
import org.eclipse.jdt.astview.views.JavaElement;
import org.eclipse.jdt.astview.views.NodeProperty;
import org.eclipse.jdt.astview.views.NonRelevantFilter;
import org.eclipse.jdt.astview.views.ProblemNode;
import org.eclipse.jdt.astview.views.TrayContentProvider;
import org.eclipse.jdt.astview.views.TrayLabelProvider;
import org.eclipse.jdt.astview.views.TreeCopyAction;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ASTView
extends ViewPart
implements IShowInSource,
IShowInTargetList {
    static final int JLS_LATEST = AST.getJLSLatest();
    private static final int JLS21 = 21;
    private static final int JLS20 = 20;
    private static final int JLS19 = 19;
    private static final int JLS18 = 18;
    private static final int JLS17 = 17;
    private static final int JLS16 = 16;
    private static final int JLS15 = 15;
    private static final int JLS14 = 14;
    private static final int JLS13 = 13;
    private static final int JLS12 = 12;
    private static final int JLS11 = 11;
    private static final int JLS10 = 10;
    private static final int JLS9 = 9;
    private static final int JLS8 = 8;
    private static final int JLS4 = 4;
    private static final int JLS3 = 3;
    private static final int JLS2 = 2;
    private static final String SETTINGS_LINK_WITH_EDITOR = "link_with_editor";
    private static final String SETTINGS_INPUT_KIND = "input_kind";
    private static final String SETTINGS_NO_BINDINGS = "create_bindings";
    private static final String SETTINGS_NO_STATEMENTS_RECOVERY = "no_statements_recovery";
    private static final String SETTINGS_NO_BINDINGS_RECOVERY = "no_bindings_recovery";
    private static final String SETTINGS_IGNORE_METHOD_BODIES = "ignore_method_bodies";
    private static final String SETTINGS_SHOW_NON_RELEVANT = "show_non_relevant";
    private static final String SETTINGS_JLS = "jls";
    private SashForm fSash;
    private TreeViewer fViewer;
    private ASTViewLabelProvider fASTLabelProvider;
    private TreeViewer fTray;
    private DrillDownAdapter fDrillDownAdapter;
    private Action fFocusAction;
    private Action fRefreshAction;
    private Action fCreateBindingsAction;
    private Action fStatementsRecoveryAction;
    private Action fBindingsRecoveryAction;
    private Action fIgnoreMethodBodiesAction;
    private Action fFilterNonRelevantAction;
    private Action fFindDeclaringNodeAction;
    private Action fParseBindingFromKeyAction;
    private Action fParseBindingFromElementAction;
    private Action fCollapseAction;
    private Action fExpandAction;
    private Action fClearAction;
    private TreeCopyAction fCopyAction;
    private Action fDoubleClickAction;
    private Action fLinkWithEditor;
    private Action fAddToTrayAction;
    private Action fDeleteAction;
    private ASTLevelToggle[] fASTVersionToggleActions;
    private int fCurrentASTLevel;
    private ASTInputKindAction[] fASTInputKindActions;
    private int fCurrentInputKind;
    private ITextEditor fEditor;
    private ITypeRoot fTypeRoot;
    private CompilationUnit fRoot;
    private IDocument fCurrentDocument;
    private ArrayList<Object> fTrayRoots;
    private boolean fDoLinkWithEditor;
    private boolean fCreateBindings;
    private NonRelevantFilter fNonRelevantFilter;
    private boolean fStatementsRecovery;
    private boolean fBindingsRecovery;
    private boolean fIgnoreMethodBodies;
    private Object fPreviousDouble;
    private ListenerMix fSuperListener = null;
    private ISelectionChangedListener fTrayUpdater;
    private IDialogSettings fDialogSettings = ASTViewPlugin.getDefault().getDialogSettings();

    public ASTView() {
        this.fDoLinkWithEditor = this.fDialogSettings.getBoolean(SETTINGS_LINK_WITH_EDITOR);
        try {
            this.fCurrentInputKind = this.fDialogSettings.getInt(SETTINGS_INPUT_KIND);
        }
        catch (NumberFormatException e) {
            this.fCurrentInputKind = 1;
        }
        this.fCreateBindings = !this.fDialogSettings.getBoolean(SETTINGS_NO_BINDINGS);
        this.fStatementsRecovery = !this.fDialogSettings.getBoolean(SETTINGS_NO_STATEMENTS_RECOVERY);
        this.fBindingsRecovery = !this.fDialogSettings.getBoolean(SETTINGS_NO_BINDINGS_RECOVERY);
        this.fIgnoreMethodBodies = this.fDialogSettings.getBoolean(SETTINGS_IGNORE_METHOD_BODIES);
        this.fCurrentASTLevel = JLS_LATEST;
        try {
            int level = this.fDialogSettings.getInt(SETTINGS_JLS);
            switch (level) {
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    this.fCurrentASTLevel = level;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.fNonRelevantFilter = new NonRelevantFilter();
        this.fNonRelevantFilter.setShowNonRelevant(this.fDialogSettings.getBoolean(SETTINGS_SHOW_NON_RELEVANT));
    }

    final void notifyWorkbenchPartClosed(IWorkbenchPartReference partRef) {
        if (this.fEditor != null && this.fEditor.equals(partRef.getPart(false))) {
            try {
                this.setInput(null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        if (this.fSuperListener == null) {
            this.fSuperListener = new ListenerMix(this);
            ISelectionService service = site.getWorkbenchWindow().getSelectionService();
            service.addPostSelectionListener((ISelectionListener)this.fSuperListener);
            site.getPage().addPartListener((IPartListener2)this.fSuperListener);
            FileBuffers.getTextFileBufferManager().addFileBufferListener((IFileBufferListener)this.fSuperListener);
        }
    }

    public int getCurrentASTLevel() {
        return this.fCurrentASTLevel;
    }

    public int getCurrentInputKind() {
        return this.fCurrentInputKind;
    }

    public void setInput(ITextEditor editor) throws CoreException {
        if (this.fEditor != null) {
            this.uninstallModificationListener();
        }
        this.fEditor = null;
        this.fRoot = null;
        if (editor != null) {
            ITypeRoot typeRoot = EditorUtility.getJavaInput((IEditorPart)editor);
            if (typeRoot == null) {
                throw new CoreException(this.getErrorStatus("Editor not showing a CU or class file", null));
            }
            this.fTypeRoot = typeRoot;
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                this.fRoot = this.internalSetInput(typeRoot, textSelection.getOffset(), textSelection.getLength());
                this.fEditor = editor;
            }
            this.installModificationListener();
        }
    }

    private CompilationUnit internalSetInput(ITypeRoot input, int offset, int length) throws CoreException {
        CompilationUnit root;
        block9: {
            if (input.getBuffer() == null) {
                throw new CoreException(this.getErrorStatus("Input has no buffer", null));
            }
            try {
                root = this.createAST(input, offset);
                this.resetView(root);
                if (root == null) {
                    this.setContentDescription("AST could not be created.");
                    return null;
                }
            }
            catch (RuntimeException e) {
                throw new CoreException(this.getErrorStatus("Could not create AST:\n" + e.getMessage(), e));
            }
            try {
                ASTNode node = NodeFinder.perform((ASTNode)root, (int)offset, (int)length);
                if (node == null) break block9;
                this.fViewer.getTree().setRedraw(false);
                try {
                    this.fASTLabelProvider.setSelectedRange(node.getStartPosition(), node.getLength());
                    this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
                }
                finally {
                    this.fViewer.getTree().setRedraw(true);
                }
            }
            catch (RuntimeException e) {
                this.showAndLogError("Could not select node for editor selection", e);
            }
        }
        return root;
    }

    private void clearView() {
        this.resetView(null);
        this.setContentDescription("Open a Java editor and press the 'Show AST of active editor' toolbar button");
    }

    private void resetView(CompilationUnit root) {
        this.fViewer.setInput((Object)root);
        this.fViewer.getTree().setEnabled(root != null);
        this.fSash.setMaximizedControl((Control)this.fViewer.getTree());
        this.fTrayRoots = new ArrayList();
        if (this.fTray != null) {
            this.fTray.setInput(this.fTrayRoots);
        }
        this.setASTUptoDate(root != null);
        this.fClearAction.setEnabled(root != null);
        this.fFindDeclaringNodeAction.setEnabled(root != null);
        this.fPreviousDouble = null;
    }

    private CompilationUnit createAST(ITypeRoot input, int offset) throws JavaModelException, CoreException {
        long endTime;
        CompilationUnit root;
        long startTime;
        if (this.getCurrentInputKind() == 2) {
            final IProblemRequestor problemRequestor = new IProblemRequestor(){

                public void acceptProblem(IProblem problem) {
                }

                public void beginReporting() {
                }

                public void endReporting() {
                }

                public boolean isActive() {
                    return true;
                }
            };
            WorkingCopyOwner workingCopyOwner = new WorkingCopyOwner(){

                public IProblemRequestor getProblemRequestor(ICompilationUnit workingCopy) {
                    return problemRequestor;
                }
            };
            ICompilationUnit wc = input.getWorkingCopy(workingCopyOwner, null);
            try {
                int reconcileFlags = 1;
                if (this.fStatementsRecovery) {
                    reconcileFlags |= 2;
                }
                if (this.fBindingsRecovery) {
                    reconcileFlags |= 4;
                }
                if (this.fIgnoreMethodBodies) {
                    reconcileFlags |= 8;
                }
                startTime = System.currentTimeMillis();
                root = wc.reconcile(this.fCurrentASTLevel, reconcileFlags, null, null);
                endTime = System.currentTimeMillis();
            }
            finally {
                wc.discardWorkingCopy();
            }
        } else if (input instanceof ICompilationUnit && this.getCurrentInputKind() == 3) {
            ICompilationUnit cu = (ICompilationUnit)input;
            startTime = System.currentTimeMillis();
            root = SharedASTProviderCore.getAST((ITypeRoot)cu, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, null);
            endTime = System.currentTimeMillis();
        } else {
            ASTParser parser = ASTParser.newParser((int)this.fCurrentASTLevel);
            parser.setResolveBindings(this.fCreateBindings);
            parser.setSource(input);
            parser.setStatementsRecovery(this.fStatementsRecovery);
            parser.setBindingsRecovery(this.fBindingsRecovery);
            parser.setIgnoreMethodBodies(this.fIgnoreMethodBodies);
            if (this.getCurrentInputKind() == 4) {
                parser.setFocalPosition(offset);
            }
            startTime = System.currentTimeMillis();
            root = (CompilationUnit)parser.createAST(null);
            endTime = System.currentTimeMillis();
        }
        if (root != null) {
            root.accept((ASTVisitor)new StatementChecker());
            this.updateContentDescription((IJavaElement)input, root, endTime - startTime);
        }
        return root;
    }

    protected void refreshASTSettingsActions() {
        boolean enabled;
        switch (this.getCurrentInputKind()) {
            case 3: {
                enabled = false;
                break;
            }
            default: {
                enabled = true;
            }
        }
        this.fCreateBindingsAction.setEnabled(enabled && this.getCurrentInputKind() != 2);
        this.fStatementsRecoveryAction.setEnabled(enabled);
        this.fBindingsRecoveryAction.setEnabled(enabled);
        this.fIgnoreMethodBodiesAction.setEnabled(enabled);
        ASTLevelToggle[] aSTLevelToggleArray = this.fASTVersionToggleActions;
        int n = this.fASTVersionToggleActions.length;
        int n2 = 0;
        while (n2 < n) {
            ASTLevelToggle action = aSTLevelToggleArray[n2];
            action.setEnabled(enabled);
            ++n2;
        }
    }

    private void updateContentDescription(IJavaElement element, CompilationUnit root, long time) {
        StringBuilder version = new StringBuilder("AST Level ").append(root.getAST().apiLevel());
        switch (this.getCurrentInputKind()) {
            case 2: {
                version.append(", from reconciler");
                break;
            }
            case 3: {
                version.append(", from ASTProvider");
                break;
            }
            case 4: {
                version.append(", using focal position");
                break;
            }
        }
        TreeInfoCollector collector = new TreeInfoCollector(root);
        String msg = "{0} ({1}).  Creation time: {2,number} ms.  Size: {3,number} nodes, {4,number} bytes (AST nodes only).";
        Object[] args = new Object[]{element.getElementName(), version.toString(), time, collector.getNumberOfNodes(), collector.getSize()};
        this.setContentDescription(MessageFormat.format(msg, args));
    }

    public void dispose() {
        if (this.fSuperListener != null) {
            if (this.fEditor != null) {
                this.uninstallModificationListener();
            }
            ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
            service.removePostSelectionListener((ISelectionListener)this.fSuperListener);
            this.getSite().getPage().removePartListener((IPartListener2)this.fSuperListener);
            FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)this.fSuperListener);
            this.fSuperListener.dispose();
            this.fSuperListener = null;
        }
        if (this.fTrayUpdater != null) {
            this.fViewer.removePostSelectionChangedListener(this.fTrayUpdater);
            this.fTray.removePostSelectionChangedListener(this.fTrayUpdater);
            this.fTrayUpdater = null;
        }
        super.dispose();
    }

    private IStatus getErrorStatus(String message, Throwable th) {
        return new Status(4, ASTViewPlugin.getPluginId(), 4, message, th);
    }

    public void createPartControl(Composite parent) {
        this.fSash = new SashForm(parent, 66048);
        this.fViewer = new TreeViewer((Composite)this.fSash, 770);
        this.fDrillDownAdapter = new DrillDownAdapter(this.fViewer);
        this.fViewer.setContentProvider((IContentProvider)new ASTViewContentProvider());
        this.fASTLabelProvider = new ASTViewLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fASTLabelProvider);
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.fSuperListener);
        this.fViewer.addDoubleClickListener((IDoubleClickListener)this.fSuperListener);
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ASTView.this.fCreateBindings || !(element instanceof Binding);
            }
        });
        this.fViewer.addFilter((ViewerFilter)this.fNonRelevantFilter);
        ViewForm trayForm = new ViewForm((Composite)this.fSash, 0);
        Label label = new Label((Composite)trayForm, 0);
        label.setText(" Comparison Tray (* = selection in the upper tree):");
        trayForm.setTopLeft((Control)label);
        this.fTray = new TreeViewer((Composite)trayForm, 770);
        trayForm.setContent((Control)this.fTray.getTree());
        this.fTrayRoots = new ArrayList();
        this.fTray.setContentProvider((IContentProvider)new TrayContentProvider());
        TrayLabelProvider trayLabelProvider = new TrayLabelProvider();
        this.fTray.setLabelProvider((IBaseLabelProvider)trayLabelProvider);
        this.fTray.setAutoExpandLevel(-1);
        this.fTrayUpdater = event -> {
            Object first;
            IStructuredSelection viewerSelection = (IStructuredSelection)this.fViewer.getSelection();
            if (viewerSelection.size() == 1 && ASTView.unwrapAttribute(first = viewerSelection.getFirstElement()) != null) {
                trayLabelProvider.setViewerElement(first);
                return;
            }
            trayLabelProvider.setViewerElement(null);
        };
        this.fTray.addPostSelectionChangedListener(this.fTrayUpdater);
        this.fViewer.addPostSelectionChangedListener(this.fTrayUpdater);
        this.fTray.addDoubleClickListener(event -> this.performTrayDoubleClick());
        this.fTray.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.fDeleteAction.setEnabled(selection.size() >= 1 && this.fTray.getTree().isFocusControl());
        });
        this.fTray.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ASTView.this.fTray.getSelection();
                ASTView.this.fDeleteAction.setEnabled(selection.size() >= 1);
            }

            public void focusLost(FocusEvent e) {
                ASTView.this.fDeleteAction.setEnabled(false);
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.hookTrayContextMenu();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)new ASTViewSelectionProvider());
        try {
            IEditorPart part = EditorUtility.getActiveEditor();
            if (part instanceof ITextEditor) {
                this.setInput((ITextEditor)part);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (this.fTypeRoot == null) {
            this.clearView();
        } else {
            this.setASTUptoDate(this.fTypeRoot != null);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillContextMenu);
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void hookTrayContextMenu() {
        MenuManager menuMgr = new MenuManager("#TrayPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            manager.add((IAction)this.fCopyAction);
            manager.add((IAction)this.fDeleteAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new Separator("additions"));
        });
        Menu menu = menuMgr.createContextMenu(this.fTray.getControl());
        this.fTray.getControl().setMenu(menu);
        this.getSite().registerContextMenu("#TrayPopupMenu", menuMgr, (ISelectionProvider)this.fTray);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fFocusAction);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        IHandlerService handlerService = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.linkWithEditor", (IHandler)new ActionHandler((IAction)this.fLinkWithEditor));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        ASTLevelToggle action;
        Action[] actionArray = this.fASTVersionToggleActions;
        int n = this.fASTVersionToggleActions.length;
        int n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            manager.add((IAction)action);
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fCreateBindingsAction);
        manager.add((IAction)this.fStatementsRecoveryAction);
        manager.add((IAction)this.fBindingsRecoveryAction);
        manager.add((IAction)this.fIgnoreMethodBodiesAction);
        manager.add((IContributionItem)new Separator());
        actionArray = this.fASTInputKindActions;
        n = this.fASTInputKindActions.length;
        n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            manager.add((IAction)action);
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fFindDeclaringNodeAction);
        manager.add((IAction)this.fParseBindingFromKeyAction);
        manager.add((IAction)this.fParseBindingFromElementAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fFilterNonRelevantAction);
        manager.add((IAction)this.fLinkWithEditor);
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (!selection.isEmpty() && ((IStructuredSelection)selection).getFirstElement() instanceof IJavaElement) {
            MenuManager showInSubMenu = new MenuManager(this.getShowInMenuLabel());
            IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
            showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(workbenchWindow));
            manager.add((IContributionItem)showInSubMenu);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.fFocusAction);
        manager.add((IAction)this.fRefreshAction);
        manager.add((IAction)this.fClearAction);
        manager.add((IAction)this.fCollapseAction);
        manager.add((IAction)this.fExpandAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fCopyAction);
        if (this.fAddToTrayAction.isEnabled()) {
            manager.add((IAction)this.fAddToTrayAction);
        }
        manager.add((IContributionItem)new Separator());
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private String getShowInMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return "Sho&w In\t" + keyBinding;
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fFocusAction);
        manager.add((IAction)this.fRefreshAction);
        manager.add((IAction)this.fClearAction);
        manager.add((IContributionItem)new Separator());
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fExpandAction);
        manager.add((IAction)this.fCollapseAction);
        manager.add((IAction)this.fLinkWithEditor);
    }

    private void setASTUptoDate(boolean isuptoDate) {
        this.fRefreshAction.setEnabled(!isuptoDate && this.fTypeRoot != null);
    }

    private void makeActions() {
        this.fRefreshAction = new Action(){

            public void run() {
                ASTView.this.performRefresh();
            }
        };
        this.fRefreshAction.setText("&Refresh AST");
        this.fRefreshAction.setToolTipText("Refresh AST");
        this.fRefreshAction.setEnabled(false);
        ASTViewImages.setImageDescriptors((IAction)this.fRefreshAction, "refresh.png");
        this.fClearAction = new Action(){

            public void run() {
                ASTView.this.performClear();
            }
        };
        this.fClearAction.setText("&Clear AST");
        this.fClearAction.setToolTipText("Clear AST and release memory");
        this.fClearAction.setEnabled(false);
        ASTViewImages.setImageDescriptors((IAction)this.fClearAction, "clear.png");
        this.fASTInputKindActions = new ASTInputKindAction[]{new ASTInputKindAction("Use ASTParser.&createAST", 1), new ASTInputKindAction("Use ASTParser with &focal position", 4), new ASTInputKindAction("Use ICompilationUnit.&reconcile", 2), new ASTInputKindAction("Use SharedASTProvider.&getAST", 3)};
        this.fCreateBindingsAction = new Action("&Create Bindings", 2){

            public void run() {
                ASTView.this.performCreateBindings();
            }
        };
        this.fCreateBindingsAction.setChecked(this.fCreateBindings);
        this.fCreateBindingsAction.setToolTipText("Create Bindings");
        this.fCreateBindingsAction.setEnabled(true);
        this.fStatementsRecoveryAction = new Action("&Statements Recovery", 2){

            public void run() {
                ASTView.this.performStatementsRecovery();
            }
        };
        this.fStatementsRecoveryAction.setChecked(this.fStatementsRecovery);
        this.fStatementsRecoveryAction.setEnabled(true);
        this.fBindingsRecoveryAction = new Action("&Bindings Recovery", 2){

            public void run() {
                ASTView.this.performBindingsRecovery();
            }
        };
        this.fBindingsRecoveryAction.setChecked(this.fBindingsRecovery);
        this.fBindingsRecoveryAction.setEnabled(true);
        this.fIgnoreMethodBodiesAction = new Action("&Ignore Method Bodies", 2){

            public void run() {
                ASTView.this.performIgnoreMethodBodies();
            }
        };
        this.fIgnoreMethodBodiesAction.setChecked(this.fIgnoreMethodBodies);
        this.fIgnoreMethodBodiesAction.setEnabled(true);
        this.fFilterNonRelevantAction = new Action("&Hide Non-Relevant Attributes", 2){

            public void run() {
                ASTView.this.performFilterNonRelevant();
            }
        };
        this.fFilterNonRelevantAction.setChecked(!this.fNonRelevantFilter.isShowNonRelevant());
        this.fFilterNonRelevantAction.setToolTipText("Hide non-relevant binding attributes");
        this.fFilterNonRelevantAction.setEnabled(true);
        this.fFindDeclaringNodeAction = new Action("Find &Declaring Node...", 1){

            public void run() {
                ASTView.this.performFindDeclaringNode();
            }
        };
        this.fFindDeclaringNodeAction.setToolTipText("Find Declaring Node...");
        this.fFindDeclaringNodeAction.setEnabled(false);
        this.fParseBindingFromElementAction = new Action("&Parse Binding from &Element Handle...", 1){

            public void run() {
                ASTView.this.performParseBindingFromElement();
            }
        };
        this.fParseBindingFromElementAction.setToolTipText("Parse Binding from Element Handle...");
        this.fParseBindingFromElementAction.setEnabled(true);
        this.fParseBindingFromKeyAction = new Action("Parse Binding from &Key...", 1){

            public void run() {
                ASTView.this.performParseBindingFromKey();
            }
        };
        this.fParseBindingFromKeyAction.setToolTipText("Parse Binding from Key...");
        this.fParseBindingFromKeyAction.setEnabled(true);
        this.fFocusAction = new Action(){

            public void run() {
                ASTView.this.performSetFocus();
            }
        };
        this.fFocusAction.setText("&Show AST of active editor");
        this.fFocusAction.setToolTipText("Show AST of active editor");
        this.fFocusAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        ASTViewImages.setImageDescriptors((IAction)this.fFocusAction, "setfocus.png");
        this.fCollapseAction = new Action(){

            public void run() {
                ASTView.this.performCollapse();
            }
        };
        this.fCollapseAction.setText("C&ollapse");
        this.fCollapseAction.setToolTipText("Collapse Selected Node");
        this.fCollapseAction.setEnabled(false);
        ASTViewImages.setImageDescriptors((IAction)this.fCollapseAction, "collapseall.png");
        this.fExpandAction = new Action(){

            public void run() {
                ASTView.this.performExpand();
            }
        };
        this.fExpandAction.setText("E&xpand");
        this.fExpandAction.setToolTipText("Expand Selected Node");
        this.fExpandAction.setEnabled(false);
        ASTViewImages.setImageDescriptors((IAction)this.fExpandAction, "expandall.png");
        this.fCopyAction = new TreeCopyAction(new Tree[]{this.fViewer.getTree(), this.fTray.getTree()});
        this.fDoubleClickAction = new Action(){

            public void run() {
                ASTView.this.performDoubleClick();
            }
        };
        this.fLinkWithEditor = new Action(){

            public void run() {
                ASTView.this.performLinkWithEditor();
            }
        };
        this.fLinkWithEditor.setChecked(this.fDoLinkWithEditor);
        this.fLinkWithEditor.setText("&Link with Editor");
        this.fLinkWithEditor.setToolTipText("Link With Editor");
        this.fLinkWithEditor.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
        ASTViewImages.setImageDescriptors((IAction)this.fLinkWithEditor, "synced.png");
        this.fASTVersionToggleActions = new ASTLevelToggle[]{new ASTLevelToggle("AST Level &2 (1.2)", 2), new ASTLevelToggle("AST Level &3 (1.5)", 3), new ASTLevelToggle("AST Level &4 (1.7)", 4), new ASTLevelToggle("AST Level &8 (1.8)", 8), new ASTLevelToggle("AST Level &9 (9)", 9), new ASTLevelToggle("AST Level 1&0 (10)", 10), new ASTLevelToggle("AST Level 1&1 (11)", 11), new ASTLevelToggle("AST Level 1&2 (12)", 12), new ASTLevelToggle("AST Level 1&3 (13)", 13), new ASTLevelToggle("AST Level 1&4 (14)", 14), new ASTLevelToggle("AST Level 1&5 (15)", 15), new ASTLevelToggle("AST Level 1&6 (16)", 16), new ASTLevelToggle("AST Level 1&7 (17)", 17), new ASTLevelToggle("AST Level 1&8 (18)", 18), new ASTLevelToggle("AST Level 1&9 (19)", 19), new ASTLevelToggle("AST Level 2&0 (20)", 20), new ASTLevelToggle("AST Level 2&1 (21)", 21)};
        this.fAddToTrayAction = new Action(){

            public void run() {
                ASTView.this.performAddToTray();
            }
        };
        this.fAddToTrayAction.setText("&Add to Comparison Tray");
        this.fAddToTrayAction.setToolTipText("Add Selected Node to Comparison Tray");
        this.fAddToTrayAction.setEnabled(false);
        ASTViewImages.setImageDescriptors((IAction)this.fAddToTrayAction, "add.png");
        this.fDeleteAction = new Action(){

            public void run() {
                ASTView.this.performDelete();
            }
        };
        this.fDeleteAction.setText("&Delete");
        this.fDeleteAction.setToolTipText("Delete Binding from Tray");
        this.fDeleteAction.setEnabled(false);
        this.fDeleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.fDeleteAction.setId(ActionFactory.DELETE.getId());
        this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.refreshASTSettingsActions();
    }

    private void refreshAST() throws CoreException {
        ASTNode node = this.getASTNodeNearSelection((IStructuredSelection)this.fViewer.getSelection());
        int offset = 0;
        int length = 0;
        if (node != null) {
            offset = node.getStartPosition();
            length = node.getLength();
        }
        this.internalSetInput(this.fTypeRoot, offset, length);
    }

    protected void setASTLevel(int level, boolean doRefresh) {
        int oldLevel = this.fCurrentASTLevel;
        this.fCurrentASTLevel = level;
        this.fDialogSettings.put(SETTINGS_JLS, this.fCurrentASTLevel);
        if (doRefresh && this.fTypeRoot != null && oldLevel != this.fCurrentASTLevel) {
            try {
                this.refreshAST();
            }
            catch (CoreException e) {
                this.showAndLogError("Could not set AST to new level.", e);
                this.fCurrentASTLevel = oldLevel;
            }
        }
        ASTLevelToggle[] aSTLevelToggleArray = this.fASTVersionToggleActions;
        int n = this.fASTVersionToggleActions.length;
        int n2 = 0;
        while (n2 < n) {
            ASTLevelToggle action;
            action.setChecked((action = aSTLevelToggleArray[n2]).getLevel() == this.fCurrentASTLevel);
            ++n2;
        }
    }

    protected void setASTInputType(int inputKind) {
        if (inputKind != this.fCurrentInputKind) {
            this.fCurrentInputKind = inputKind;
            this.fDialogSettings.put(SETTINGS_INPUT_KIND, inputKind);
            ASTInputKindAction[] aSTInputKindActionArray = this.fASTInputKindActions;
            int n = this.fASTInputKindActions.length;
            int n2 = 0;
            while (n2 < n) {
                ASTInputKindAction action;
                action.setChecked((action = aSTInputKindActionArray[n2]).getInputKind() == inputKind);
                ++n2;
            }
            this.refreshASTSettingsActions();
            this.performRefresh();
        }
    }

    private ASTNode getASTNodeNearSelection(IStructuredSelection selection) {
        Object elem = selection.getFirstElement();
        if (elem instanceof ASTAttribute) {
            return ((ASTAttribute)elem).getParentASTNode();
        }
        if (elem instanceof ASTNode) {
            return (ASTNode)elem;
        }
        return null;
    }

    private void installModificationListener() {
        this.fCurrentDocument = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        this.fCurrentDocument.addDocumentListener((IDocumentListener)this.fSuperListener);
    }

    private void uninstallModificationListener() {
        if (this.fCurrentDocument != null) {
            this.fCurrentDocument.removeDocumentListener((IDocumentListener)this.fSuperListener);
            this.fCurrentDocument = null;
        }
    }

    protected void handleDocumentDisposed() {
        this.uninstallModificationListener();
    }

    protected void handleDocumentChanged() {
        this.setASTUptoDate(false);
    }

    protected void handleSelectionChanged(ISelection selection) {
        this.fExpandAction.setEnabled(!selection.isEmpty());
        this.fCollapseAction.setEnabled(!selection.isEmpty());
        this.fCopyAction.setEnabled(!selection.isEmpty());
        boolean addEnabled = false;
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() == 1 && this.fViewer.getTree().isFocusControl()) {
            Object first = structuredSelection.getFirstElement();
            Object unwrapped = ASTView.unwrapAttribute(first);
            addEnabled = unwrapped != null;
        }
        this.fAddToTrayAction.setEnabled(addEnabled);
    }

    protected void handleEditorPostSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (part == this.fEditor) {
            this.fViewer.getTree().setRedraw(false);
            try {
                this.fASTLabelProvider.setSelectedRange(textSelection.getOffset(), textSelection.getLength());
            }
            finally {
                this.fViewer.getTree().setRedraw(true);
            }
        }
        if (!this.fDoLinkWithEditor) {
            return;
        }
        if (this.fRoot == null || part != this.fEditor) {
            if (part instanceof ITextEditor && EditorUtility.getJavaInput((IEditorPart)((ITextEditor)part)) != null) {
                try {
                    this.setInput((ITextEditor)part);
                }
                catch (CoreException e) {
                    this.setContentDescription(e.getStatus().getMessage());
                }
            }
        } else {
            this.doLinkWithEditor(selection);
        }
    }

    private void doLinkWithEditor(ISelection selection) {
        int length;
        ITextSelection textSelection = (ITextSelection)selection;
        int offset = textSelection.getOffset();
        ASTNode covering = NodeFinder.perform((ASTNode)this.fRoot, (int)offset, (int)(length = textSelection.getLength()));
        if (covering != null) {
            this.fViewer.reveal((Object)covering);
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)covering));
        }
    }

    protected void handleDoubleClick() {
        this.fDoubleClickAction.run();
    }

    protected void performLinkWithEditor() {
        ISelectionProvider selectionProvider;
        this.fDoLinkWithEditor = this.fLinkWithEditor.isChecked();
        this.fDialogSettings.put(SETTINGS_LINK_WITH_EDITOR, this.fDoLinkWithEditor);
        if (this.fDoLinkWithEditor && this.fEditor != null && (selectionProvider = this.fEditor.getSelectionProvider()) != null) {
            this.doLinkWithEditor(selectionProvider.getSelection());
        }
    }

    protected void performCollapse() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.isEmpty()) {
            this.fViewer.collapseAll();
        } else {
            this.fViewer.getTree().setRedraw(false);
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                this.fViewer.collapseToLevel(s, -1);
                ++n2;
            }
            this.fViewer.getTree().setRedraw(true);
        }
    }

    protected void performExpand() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.isEmpty()) {
            this.fViewer.expandToLevel(3);
        } else {
            this.fViewer.getTree().setRedraw(false);
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                this.fViewer.expandToLevel(s, 3);
                ++n2;
            }
            this.fViewer.getTree().setRedraw(true);
        }
    }

    protected void performSetFocus() {
        IEditorPart part = EditorUtility.getActiveEditor();
        if (part instanceof ITextEditor) {
            try {
                this.setInput((ITextEditor)part);
            }
            catch (CoreException e) {
                this.showAndLogError("Could not set AST view input ", e);
            }
        }
    }

    protected void performRefresh() {
        if (this.fTypeRoot != null) {
            try {
                this.refreshAST();
            }
            catch (CoreException e) {
                this.showAndLogError("Could not set AST view input ", e);
            }
        }
    }

    protected void performClear() {
        this.fTypeRoot = null;
        try {
            this.setInput(null);
        }
        catch (CoreException e) {
            this.showAndLogError("Could not reset AST view ", e);
        }
        this.clearView();
    }

    private void showAndLogError(String message, CoreException e) {
        ASTViewPlugin.log(message, e);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"AST View", (String)message, (IStatus)e.getStatus());
    }

    private void showAndLogError(String message, Throwable e) {
        Status status = new Status(4, ASTViewPlugin.getPluginId(), 0, message, e);
        ASTViewPlugin.log((IStatus)status);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"AST View", null, (IStatus)status);
    }

    protected void performCreateBindings() {
        this.fCreateBindings = this.fCreateBindingsAction.isChecked();
        this.fDialogSettings.put(SETTINGS_NO_BINDINGS, !this.fCreateBindings);
        this.performRefresh();
    }

    protected void performStatementsRecovery() {
        this.fStatementsRecovery = this.fStatementsRecoveryAction.isChecked();
        this.fDialogSettings.put(SETTINGS_NO_STATEMENTS_RECOVERY, !this.fStatementsRecovery);
        this.performRefresh();
    }

    protected void performBindingsRecovery() {
        this.fBindingsRecovery = this.fBindingsRecoveryAction.isChecked();
        this.fDialogSettings.put(SETTINGS_NO_BINDINGS_RECOVERY, !this.fBindingsRecovery);
        this.performRefresh();
    }

    protected void performIgnoreMethodBodies() {
        this.fIgnoreMethodBodies = this.fIgnoreMethodBodiesAction.isChecked();
        this.fDialogSettings.put(SETTINGS_IGNORE_METHOD_BODIES, this.fIgnoreMethodBodies);
        this.performRefresh();
    }

    protected void performFilterNonRelevant() {
        boolean showNonRelevant = !this.fFilterNonRelevantAction.isChecked();
        this.fNonRelevantFilter.setShowNonRelevant(showNonRelevant);
        this.fDialogSettings.put(SETTINGS_SHOW_NON_RELEVANT, showNonRelevant);
        this.fViewer.refresh();
    }

    protected void performFindDeclaringNode() {
        String msg = "Find Declaring Node from Key";
        String key = this.askForKey(msg);
        if (key == null) {
            return;
        }
        ASTNode node = this.fRoot.findDeclaringNode(key);
        if (node != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
        } else {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Find Declaring Node from Key", (String)("The declaring node for key '" + key + "' could not be found"));
        }
    }

    private String askForKey(String dialogTitle) {
        InputDialog dialog = new InputDialog(this.getSite().getShell(), dialogTitle, "Key: (optionally surrounded by <KEY: \"> and <\">)", "", null);
        if (dialog.open() != 0) {
            return null;
        }
        String key = dialog.getValue();
        if (key.startsWith("KEY: \"") && key.endsWith("\"")) {
            key = key.substring(6, key.length() - 1);
        }
        return key;
    }

    protected void performParseBindingFromKey() {
        ASTAttribute item;
        String msg = "Parse Binding from Key";
        String key = this.askForKey(msg);
        if (key == null) {
            return;
        }
        ASTParser parser = ASTParser.newParser((int)this.fCurrentASTLevel);
        parser.setResolveBindings(true);
        parser.setProject(this.fTypeRoot.getJavaProject());
        class MyASTRequestor
        extends ASTRequestor {
            String fBindingKey;
            IBinding fBinding;

            MyASTRequestor() {
            }

            public void acceptBinding(String bindingKey, IBinding binding) {
                this.fBindingKey = bindingKey;
                this.fBinding = binding;
            }
        }
        MyASTRequestor requestor = new MyASTRequestor();
        Object viewerInput = this.fViewer.getInput();
        try {
            parser.createASTs(new ICompilationUnit[0], new String[]{key}, (ASTRequestor)requestor, null);
            if (requestor.fBindingKey != null) {
                String name = String.valueOf(requestor.fBindingKey) + ": " + Binding.getBindingLabel(requestor.fBinding);
                item = new Binding(viewerInput, name, requestor.fBinding, true);
            } else {
                item = new Error(viewerInput, "Key not resolved: " + key, null);
            }
        }
        catch (RuntimeException e) {
            item = new Error(viewerInput, "Error resolving key: " + key, e);
        }
        this.fViewer.add(viewerInput, (Object)item);
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
    }

    protected void performParseBindingFromElement() {
        ASTAttribute item;
        InputDialog dialog = new InputDialog(this.getSite().getShell(), "Parse Binding from Java Element", "IJavaElement#getHandleIdentifier():", "", null);
        if (dialog.open() != 0) {
            return;
        }
        String handleIdentifier = dialog.getValue();
        IJavaElement handle = JavaCore.create((String)handleIdentifier);
        Object viewerInput = this.fViewer.getInput();
        if (handle == null) {
            item = new Error(viewerInput, "handleIdentifier not resolved: " + handleIdentifier, null);
        } else if (!handle.exists()) {
            item = new Error(viewerInput, "element does not exist: " + handleIdentifier, null);
        } else if (handle.getJavaProject() == null) {
            item = new Error(viewerInput, "getJavaProject() is null: " + handleIdentifier, null);
        } else {
            IJavaProject project = handle.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)this.fCurrentASTLevel);
            parser.setProject(project);
            IBinding[] bindings = parser.createBindings(new IJavaElement[]{handle}, null);
            String name = String.valueOf(handleIdentifier) + ": " + Binding.getBindingLabel(bindings[0]);
            item = new Binding(viewerInput, name, bindings[0], true);
        }
        this.fViewer.add(viewerInput, (Object)item);
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
    }

    protected void performDoubleClick() {
        Throwable exception;
        if (this.fEditor == null) {
            return;
        }
        ISelection selection = this.fViewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        boolean isTripleClick = obj == this.fPreviousDouble;
        Object object = this.fPreviousDouble = isTripleClick ? null : obj;
        if (obj instanceof ExceptionAttribute && (exception = ((ExceptionAttribute)obj).getException()) != null) {
            String label = ((ExceptionAttribute)obj).getLabel();
            this.showAndLogError("An error occurred while calculating an AST View Label:\n" + label, exception);
            return;
        }
        ASTNode node = null;
        ASTNode nodeEnd = null;
        if (obj instanceof ASTNode) {
            node = (ASTNode)obj;
        } else if (obj instanceof NodeProperty) {
            Object val = ((NodeProperty)obj).getNode();
            if (val instanceof ASTNode) {
                node = (ASTNode)val;
            } else if (val instanceof List) {
                List list = (List)val;
                if (list.size() > 0) {
                    node = (ASTNode)list.get(0);
                    nodeEnd = (ASTNode)list.get(list.size() - 1);
                } else {
                    this.fViewer.getTree().getDisplay().beep();
                }
            }
        } else {
            if (obj instanceof Binding) {
                IBinding binding = ((Binding)obj).getBinding();
                ASTNode declaring = this.fRoot.findDeclaringNode(binding);
                if (declaring != null) {
                    this.fViewer.reveal((Object)declaring);
                    this.fViewer.setSelection((ISelection)new StructuredSelection((Object)declaring));
                } else {
                    this.fViewer.getTree().getDisplay().beep();
                }
                return;
            }
            if (obj instanceof ProblemNode) {
                ProblemNode problemNode = (ProblemNode)obj;
                EditorUtility.selectInEditor(this.fEditor, problemNode.getOffset(), problemNode.getLength());
                return;
            }
            if (obj instanceof JavaElement) {
                IJavaElement javaElement = ((JavaElement)obj).getJavaElement();
                if (javaElement instanceof IPackageFragment) {
                    try {
                        IViewPart packageExplorer = this.getSite().getPage().showView("org.eclipse.jdt.ui.PackageExplorer");
                        if (packageExplorer instanceof IShowInTarget) {
                            IShowInTarget showInTarget = (IShowInTarget)packageExplorer;
                            showInTarget.show(this.getShowInContext());
                        }
                    }
                    catch (PartInitException e) {
                        this.showAndLogError("Could not open Package Explorer.", (CoreException)((Object)e));
                    }
                } else {
                    try {
                        IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)javaElement);
                        if (editorPart != null) {
                            JavaUI.revealInEditor((IEditorPart)editorPart, (IJavaElement)javaElement);
                        }
                    }
                    catch (PartInitException e) {
                        this.showAndLogError("Could not open editor.", (CoreException)((Object)e));
                    }
                    catch (JavaModelException e) {
                        this.showAndLogError("Could not open editor.", (CoreException)((Object)e));
                    }
                }
                return;
            }
        }
        if (node != null) {
            int offset;
            int n = offset = isTripleClick ? this.fRoot.getExtendedStartPosition(node) : node.getStartPosition();
            int length = nodeEnd == null ? (isTripleClick ? this.fRoot.getExtendedLength(node) : node.getLength()) : (isTripleClick ? this.fRoot.getExtendedStartPosition(nodeEnd) + this.fRoot.getExtendedLength(nodeEnd) - this.fRoot.getExtendedStartPosition(node) : nodeEnd.getStartPosition() + nodeEnd.getLength() - node.getStartPosition());
            EditorUtility.selectInEditor(this.fEditor, offset, length);
        }
    }

    protected void performAddToTray() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (!this.fTrayRoots.contains(firstElement)) {
            this.fTrayRoots.add(firstElement);
            this.fTray.setInput(this.fTrayRoots);
        }
        if (this.fSash.getMaximizedControl() != null) {
            int trayHeight = this.fTray.getTree().getItemHeight() * 9;
            int sashHeight = this.fSash.getClientArea().height;
            this.fSash.setWeights(new int[]{sashHeight - trayHeight, trayHeight});
            this.fSash.setMaximizedControl(null);
        }
        this.setTraySelection(selection);
    }

    private void setTraySelection(IStructuredSelection selection) {
        this.fTray.setSelection((ISelection)selection, true);
        TreeItem[] itemSelection = this.fTray.getTree().getSelection();
        if (itemSelection.length > 0) {
            this.fTray.getTree().setTopItem(itemSelection[0]);
        }
    }

    protected void performTrayDoubleClick() {
        Throwable exception;
        IStructuredSelection selection = (IStructuredSelection)this.fTray.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof ExceptionAttribute && (exception = ((ExceptionAttribute)obj).getException()) != null) {
            String label = ((ExceptionAttribute)obj).getLabel();
            this.showAndLogError("An error occurred while calculating an AST View Label:\n" + label, exception);
            return;
        }
        if (obj instanceof Binding) {
            Binding binding = (Binding)obj;
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)binding), true);
        }
    }

    protected void performDelete() {
        boolean removed = false;
        IStructuredSelection selection = (IStructuredSelection)this.fTray.getSelection();
        for (Object obj : selection) {
            if (obj instanceof DynamicAttributeProperty) {
                obj = ((DynamicAttributeProperty)obj).getParent();
            }
            if (obj instanceof DynamicBindingProperty) {
                obj = ((DynamicBindingProperty)obj).getParent();
            }
            removed |= this.fTrayRoots.remove(obj);
        }
        if (removed) {
            this.fTray.setInput(this.fTrayRoots);
        }
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext(null, this.getSite().getSelectionProvider().getSelection());
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.jdt.jeview.views.JavaElementView", "org.eclipse.jdt.ui.PackageExplorer"};
    }

    static Object unwrapAttribute(Object attribute) {
        if (attribute instanceof Binding) {
            return ((Binding)attribute).getBinding();
        }
        if (attribute instanceof JavaElement) {
            return ((JavaElement)attribute).getJavaElement();
        }
        if (attribute instanceof ASTNode) {
            return attribute;
        }
        return null;
    }

    private class ASTInputKindAction
    extends Action {
        public static final int USE_PARSER = 1;
        public static final int USE_RECONCILE = 2;
        public static final int USE_CACHE = 3;
        public static final int USE_FOCAL = 4;
        private int fInputKind;

        public ASTInputKindAction(String label, int inputKind) {
            super(label, 8);
            this.fInputKind = inputKind;
            if (inputKind == ASTView.this.getCurrentInputKind()) {
                this.setChecked(true);
            }
        }

        public int getInputKind() {
            return this.fInputKind;
        }

        public void run() {
            ASTView.this.setASTInputType(this.fInputKind);
        }
    }

    private class ASTLevelToggle
    extends Action {
        private int fLevel;

        public ASTLevelToggle(String label, int level) {
            super(label, 8);
            this.fLevel = level;
            if (level == ASTView.this.getCurrentASTLevel()) {
                this.setChecked(true);
            }
        }

        public int getLevel() {
            return this.fLevel;
        }

        public void run() {
            ASTView.this.setASTLevel(this.fLevel, true);
        }
    }

    private class ASTViewSelectionProvider
    implements ISelectionProvider {
        ListenerList<ISelectionChangedListener> fListeners = new ListenerList(1);

        private ASTViewSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            IStructuredSelection selection = (IStructuredSelection)ASTView.this.fViewer.getSelection();
            ArrayList<Object> externalSelection = new ArrayList<Object>();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object unwrapped = ASTView.unwrapAttribute(iter.next());
                if (unwrapped == null) continue;
                externalSelection.add(unwrapped);
            }
            return new StructuredSelection(externalSelection);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
        }
    }

    private static class ListenerMix
    implements ISelectionListener,
    IFileBufferListener,
    IDocumentListener,
    ISelectionChangedListener,
    IDoubleClickListener,
    IPartListener2 {
        private boolean fASTViewVisible = true;
        private ASTView fView;

        public ListenerMix(ASTView view) {
            this.fView = view;
        }

        public void dispose() {
            this.fView = null;
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (this.fASTViewVisible) {
                this.fView.handleEditorPostSelectionChanged(part, selection);
            }
        }

        public void bufferCreated(IFileBuffer buffer) {
        }

        public void bufferDisposed(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer) {
                this.fView.handleDocumentDisposed();
            }
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.fView.handleDocumentChanged();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fView.handleSelectionChanged(event.getSelection());
        }

        public void doubleClick(DoubleClickEvent event) {
            this.fView.handleDoubleClick();
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part == this.fView) {
                this.fASTViewVisible = false;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part == this.fView) {
                this.fASTViewVisible = true;
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            this.fView.notifyWorkbenchPartClosed(partRef);
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }

    private static final class StatementChecker
    extends ASTVisitor {
        private StatementChecker() {
        }

        public boolean visit(YieldStatement node) {
            block7: {
                Expression exp;
                List statements;
                block9: {
                    block8: {
                        if (node == null || !node.isImplicit() || !this.isInSwitchExpression(node)) break block7;
                        ASTNode parent = node.getParent();
                        statements = null;
                        if (parent instanceof Block) {
                            statements = ((Block)parent).statements();
                        } else if (parent instanceof SwitchExpression) {
                            statements = ((SwitchExpression)parent).statements();
                        }
                        if (statements != null) break block8;
                        return true;
                    }
                    exp = node.getExpression();
                    if (exp != null) break block9;
                    return true;
                }
                try {
                    int index = statements.indexOf(node);
                    statements.remove(node);
                    node.setExpression(null);
                    ExpressionStatement exprStmt = node.getAST().newExpressionStatement(exp);
                    exprStmt.setSourceRange(node.getStartPosition(), node.getLength());
                    statements.add(index, exprStmt);
                    exprStmt.accept((ASTVisitor)this);
                    return false;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            return true;
        }

        private boolean isInSwitchExpression(YieldStatement node) {
            boolean result = false;
            YieldStatement parent = node;
            while (parent != null) {
                if (parent instanceof SwitchExpression) {
                    result = true;
                    break;
                }
                parent = parent.getParent();
            }
            return result;
        }
    }
}

