/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class SourceElementQualifierProvider
extends LabelProvider
implements ILabelProvider {
    private JavaElementLabelProvider fJavaLabels = new JavaElementLabelProvider();

    public String getText(Object element) {
        if (element instanceof IJavaElement) {
            IJavaElement parent = ((IJavaElement)element).getParent();
            return this.fJavaLabels.getText((Object)parent);
        }
        if (element instanceof ZipEntryStorage) {
            ZipEntryStorage storage = (ZipEntryStorage)element;
            try {
                Throwable throwable = null;
                Object var4_9 = null;
                try (ZipFile archive = storage.getArchive();){
                    String zipFileName = archive.getName();
                    Path path = new Path(zipFileName);
                    IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path);
                    IResource res = entry.getResource();
                    if (res == null) {
                        return zipFileName;
                    }
                    return res.getName();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (element instanceof LocalFileStorage) {
            LocalFileStorage storage = (LocalFileStorage)element;
            File extFile = storage.getFile();
            return extFile.getParent();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IJavaElement) {
            IJavaElement parent = ((IJavaElement)element).getParent();
            return this.fJavaLabels.getImage((Object)parent);
        }
        if (element instanceof ZipEntryStorage) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_src_obj.gif");
        }
        if (element instanceof LocalFileStorage) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return super.getImage(element);
    }

    public void dispose() {
        super.dispose();
        this.fJavaLabels.dispose();
        this.fJavaLabels = null;
    }
}

