/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class RepeatingClosure<A>
implements Closure<A> {
    private final int count;
    private final Closure<? super A> closure;

    public RepeatingClosure(Closure<? super A> closure, int count) {
        if (closure == null) {
            throw new NullPointerException();
        }
        if (count <= 0) {
            throw new IndexOutOfBoundsException("invalid count: " + count);
        }
        this.closure = closure;
        this.count = count;
    }

    @Override
    public void execute(A argument) {
        int i = this.count;
        while (i-- > 0) {
            this.closure.execute(argument);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.closure);
    }
}

