/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import java.util.Arrays;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;

public class TextAlignMeta
extends CSSPropertyMeta {
    static final String[] KEYWORDS = new String[]{"left", "right", "center", "justify"};
    private static final String[] HOR_SLIGN_HTMLTAGS = new String[]{"table", "hr", "legend", "applet", "iframe", "img", "input", "object", "caption"};

    public TextAlignMeta() {
        super(true, NOT_SPECIFIED);
    }

    @Override
    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    @Override
    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        this._inherited = !"table".equalsIgnoreCase(htmltag);
        if (Arrays.asList(HOR_SLIGN_HTMLTAGS).contains(htmltag.toLowerCase())) {
            return null;
        }
        String align = DOMUtil.getAttributeIgnoreCase(element, "align");
        String value = this.checkKeywordValues(align);
        if (value != null) {
            return value;
        }
        if ("middle".equalsIgnoreCase(align)) {
            return "center";
        }
        return null;
    }
}

