/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.linuxtools.internal.docker.ui.Messages;
import org.eclipse.linuxtools.internal.docker.ui.TarEntry;
import org.eclipse.linuxtools.internal.docker.ui.TarException;

public class TarInputStream
extends FilterInputStream {
    private static final String TarImport_invalid_tar_format = "TarImport_invalid_tar_format";
    private int nextEntry = 0;
    private int nextEOF = 0;
    private int filepos = 0;
    private int bytesread = 0;
    private TarEntry firstEntry = null;
    private String longLinkName = null;

    public TarInputStream(InputStream in) throws TarException, IOException {
        super(in);
        this.firstEntry = this.getNextEntry();
    }

    TarInputStream(InputStream in, TarEntry entry) throws TarException, IOException {
        super(in);
        this.skipToEntry(entry);
    }

    private long headerChecksum(byte[] header) {
        long sum = 0L;
        for (int i = 0; i < 512; ++i) {
            sum += (long)(header[i] & 0xFF);
        }
        return sum;
    }

    boolean skipToEntry(TarEntry entry) throws TarException, IOException {
        int bytestoskip = entry.filepos - this.bytesread;
        if (bytestoskip < 0) {
            return false;
        }
        while (bytestoskip > 0) {
            long ret = this.in.skip(bytestoskip);
            if (ret < 0L) {
                throw new IOException("early end of stream");
            }
            bytestoskip = (int)((long)bytestoskip - ret);
            this.bytesread = (int)((long)this.bytesread + ret);
        }
        this.filepos = entry.filepos;
        this.nextEntry = 0;
        this.nextEOF = 0;
        this.getNextEntry();
        return true;
    }

    private boolean isValidTarHeader(byte[] header) {
        long fileChecksum;
        int i;
        int pos = 148;
        StringBuilder checksumString = new StringBuilder();
        for (i = 0; i < 8; ++i) {
            if (header[pos + i] == 32) continue;
            if (header[pos + i] == 0 || !Character.isDigit((char)header[pos + i])) break;
            checksumString.append((char)header[pos + i]);
        }
        if (checksumString.length() == 0) {
            return false;
        }
        if (checksumString.charAt(0) != '0') {
            checksumString.insert(0, '0');
        }
        try {
            fileChecksum = Long.decode(checksumString.toString());
        }
        catch (NumberFormatException exception) {
            return false;
        }
        for (i = 0; i < 8; ++i) {
            header[pos + i] = 32;
        }
        long calculatedChecksum = this.headerChecksum(header);
        return fileChecksum == calculatedChecksum;
    }

    TarEntry getNextEntryInternal() throws TarException, IOException {
        int fileSize;
        int i;
        TarEntry entry;
        byte[] header = new byte[512];
        int pos = 0;
        if (this.firstEntry != null) {
            TarEntry entryReturn = this.firstEntry;
            this.firstEntry = null;
            return entryReturn;
        }
        while (this.nextEntry > 0) {
            long ret = this.in.skip(this.nextEntry);
            if (ret < 0L) {
                throw new IOException("early end of stream");
            }
            this.nextEntry = (int)((long)this.nextEntry - ret);
            this.bytesread = (int)((long)this.bytesread + ret);
        }
        int bytestoread = 512;
        while (bytestoread > 0) {
            int ret = super.read(header, 512 - bytestoread, bytestoread);
            if (ret < 0) {
                throw new IOException("early end of stream");
            }
            bytestoread -= ret;
            this.bytesread += ret;
        }
        if (this.headerChecksum(header) == 0L) {
            if (this.filepos > 0) {
                return null;
            }
            throw new TarException("not in tar format");
        }
        if (!this.isValidTarHeader(header)) {
            throw new TarException("not in tar format");
        }
        while (pos < 100 && header[pos] != 0) {
            ++pos;
        }
        Object name = new String(header, 0, pos, "UTF8");
        pos = 345;
        if (header[pos] != 0) {
            while (pos < 500 && header[pos] != 0) {
                ++pos;
            }
            String prefix = new String(header, 345, pos - 345, "UTF8");
            name = prefix + "/" + (String)name;
        }
        if (this.longLinkName != null) {
            entry = new TarEntry(this.longLinkName, this.filepos);
            this.longLinkName = null;
        } else {
            entry = new TarEntry((String)name, this.filepos);
        }
        if (header[156] != 0) {
            entry.setFileType(header[156]);
        }
        pos = 100;
        StringBuilder mode = new StringBuilder();
        for (i = 0; i < 8 && header[pos + i] != 0; ++i) {
            if (header[pos + i] == 32) continue;
            mode.append((char)header[pos + i]);
        }
        if (mode.length() > 0 && mode.charAt(0) != '0') {
            mode.insert(0, '0');
        }
        try {
            long fileMode = Long.decode(mode.toString());
            entry.setMode(fileMode);
        }
        catch (NumberFormatException nfe) {
            throw new TarException(Messages.getString(TarImport_invalid_tar_format), nfe);
        }
        pos = 124;
        StringBuilder size = new StringBuilder();
        for (i = 0; i < 12 && header[pos + i] != 0; ++i) {
            if (header[pos + i] == 32) continue;
            size.append((char)header[pos + i]);
        }
        if (size.charAt(0) != '0') {
            size.insert(0, '0');
        }
        try {
            fileSize = Integer.decode(size.toString());
        }
        catch (NumberFormatException nfe) {
            throw new TarException(Messages.getString(TarImport_invalid_tar_format), nfe);
        }
        entry.setSize(fileSize);
        this.nextEOF = fileSize;
        this.nextEntry = fileSize % 512 > 0 ? fileSize + (512 - fileSize % 512) : fileSize;
        this.filepos += this.nextEntry + 512;
        return entry;
    }

    public TarEntry getNextEntry() throws TarException, IOException {
        TarEntry entry = this.getNextEntryInternal();
        if (entry != null && entry.getName().equals("././@LongLink")) {
            int pos;
            int cur;
            byte[] longNameData = new byte[(int)entry.getSize()];
            for (int bytesread = 0; bytesread < longNameData.length; bytesread += cur) {
                cur = this.read(longNameData, bytesread, longNameData.length - bytesread);
                if (cur >= 0) continue;
                throw new IOException("early end of stream");
            }
            for (pos = 0; pos < longNameData.length && longNameData[pos] != 0; ++pos) {
            }
            this.longLinkName = new String(longNameData, 0, pos, "UTF8");
            return this.getNextEntryInternal();
        }
        return entry;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.nextEOF == 0) {
            return -1;
        }
        if (len > this.nextEOF) {
            len = this.nextEOF;
        }
        int size = super.read(b, off, len);
        this.nextEntry -= size;
        this.nextEOF -= size;
        this.bytesread += size;
        return size;
    }

    @Override
    public int read() throws IOException {
        byte[] data = new byte[1];
        int size = this.read(data, 0, 1);
        if (size < 0) {
            return size;
        }
        return data[0];
    }
}

