/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.RepositoryNode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class RepositoryViewLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IColorProvider,
IFontProvider {
    private final Font italicFont;

    public RepositoryViewLabelProvider(Font treeFont) {
        int size = 0;
        FontData[] data = treeFont.getFontData();
        if (data == null) {
            size = 12;
        } else {
            FontData[] fontDataArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                FontData element = fontDataArray[n2];
                size = Math.max(size, element.getHeight());
                ++n2;
            }
        }
        this.italicFont = M2EUIUtils.deriveFont(treeFont, 2, size);
    }

    public void dispose() {
        this.italicFont.dispose();
        super.dispose();
    }

    public String getText(Object obj) {
        if (obj instanceof IMavenRepositoryNode var2_3) {
            return repoNode.getName();
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof IMavenRepositoryNode var2_3) {
            return repoNode.getImage();
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof RepositoryNode var2_3 && !repoNode.hasChildren()) {
            return Display.getDefault().getSystemColor(16);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Font getFont(Object element) {
        void repoNode;
        IMavenRepositoryNode iMavenRepositoryNode;
        Object object = element;
        return object instanceof IMavenRepositoryNode && (iMavenRepositoryNode = (IMavenRepositoryNode)object) == (IMavenRepositoryNode)object && repoNode.isUpdating() ? this.italicFont : null;
    }

    public StyledString getStyledText(Object element) {
        return new StyledString(this.getText(element));
    }
}

