/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.PrimeFinder;

public final class SetInt
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BIG_CAPACITY = PrimeFinder.findPrevPrime(0x7FFFFFF8) - 1;
    private int capacity;
    private int step;
    private int limit;
    private int size;
    private boolean[] used;
    private int[] keys;
    private transient int mod;

    public SetInt() {
        this(10);
    }

    public SetInt(int initialCapacity) {
        this.init(initialCapacity);
    }

    public boolean add(int key) {
        int hash = this.hash(key);
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return false;
            }
            hash = this.step(hash);
        }
        if (this.size == this.limit) {
            this.resize(this.capacity <= BIG_CAPACITY >> 1 ? this.capacity << 1 : (this.capacity < BIG_CAPACITY ? BIG_CAPACITY : this.capacity + 1));
            hash = this.hash(key);
            while (this.used[hash]) {
                if (this.keys[hash] == key) {
                    throw new ConcurrentModificationException();
                }
                hash = this.step(hash);
            }
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        ++this.size;
        ++this.mod;
        return true;
    }

    public boolean remove(int key) {
        int hash = this.hash(key);
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                this.used[hash] = false;
                --this.size;
                hash = this.step(hash);
                while (this.used[hash]) {
                    key = this.keys[hash];
                    this.used[hash] = false;
                    int newHash = this.hash(key);
                    while (this.used[newHash]) {
                        newHash = this.step(newHash);
                    }
                    this.used[newHash] = true;
                    this.keys[newHash] = key;
                    hash = this.step(hash);
                }
                ++this.mod;
                return true;
            }
            hash = this.step(hash);
        }
        return false;
    }

    public boolean contains(int key) {
        int hash = this.hash(key);
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return true;
            }
            hash = this.step(hash);
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.size = 0;
        this.used = new boolean[this.capacity];
        ++this.mod;
    }

    public IteratorInt iterator() {
        return new IteratorInt(){
            int n = 0;
            int i = -1;
            int mod0;
            {
                this.mod0 = SetInt.this.mod;
            }

            @Override
            public boolean hasNext() {
                return this.n < SetInt.this.size;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public int next() throws NoSuchElementException {
                if (this.mod0 == SetInt.access$0(SetInt.this)) ** GOTO lbl6
                throw new ConcurrentModificationException();
lbl-1000:
                // 1 sources

                {
                    if (!SetInt.access$2(SetInt.this)[this.i]) continue;
                    ++this.n;
                    return SetInt.access$3(SetInt.this)[this.i];
lbl6:
                    // 2 sources

                    ** while (++this.i < SetInt.access$2((SetInt)SetInt.this).length)
                }
lbl7:
                // 1 sources

                throw new NoSuchElementException();
            }
        };
    }

    public int[] toArray() {
        int[] array = new int[this.size];
        int j = 0;
        int i = 0;
        while (i < this.used.length) {
            if (this.used[i]) {
                array[j++] = this.keys[i];
            }
            ++i;
        }
        return array;
    }

    private int step(int hash) {
        if ((hash += this.step) >= this.capacity || hash < 0) {
            hash -= this.capacity;
        }
        return hash;
    }

    private int oldHash(int key) {
        return (key & Integer.MAX_VALUE) % this.capacity;
    }

    private int hash(int key) {
        int r = (int)(((long)key * -7046029254386353131L >>> 31) * (long)this.capacity >>> 33);
        return r;
    }

    private void init(int initialCapacity) {
        this.capacity = PrimeFinder.findNextPrime(initialCapacity);
        this.step = Math.max(1, PrimeFinder.findPrevPrime(initialCapacity / 3));
        this.limit = (int)((double)this.capacity * 0.75);
        this.clear();
        this.keys = new int[this.capacity];
    }

    private void resize(int newCapacity) {
        int oldSize = this.size;
        boolean[] oldUsed = this.used;
        int[] oldKeys = this.keys;
        this.keys = null;
        this.capacity = 0;
        this.init(newCapacity);
        int i = 0;
        while (i < oldUsed.length) {
            if (oldUsed[i]) {
                int key = oldKeys[i];
                int hash = this.hash(key);
                while (this.used[hash]) {
                    hash = this.step(hash);
                }
                this.used[hash] = true;
                this.keys[hash] = key;
            }
            ++i;
        }
        this.size = oldSize;
        ++this.mod;
    }

    private int calcInit() {
        int c1;
        int c2 = this.capacity - 1;
        int c1c = PrimeFinder.findPrevPrime(this.capacity);
        int c1s = (this.step + 1) * 3;
        int c = c1 = Math.max(c1c, c1s);
        while (c <= c2) {
            int s1 = Math.max(1, PrimeFinder.findPrevPrime(c / 3));
            if (s1 == this.step) {
                return c;
            }
            ++c;
        }
        return c2;
    }

    private Object writeReplace() {
        SetInt out = new SetInt(this.calcInit());
        int i = 0;
        while (i < this.capacity) {
            if (this.used[i]) {
                int key = this.keys[i];
                int hash = out.oldHash(key);
                while (out.used[hash]) {
                    hash = out.step(hash);
                }
                out.used[hash] = true;
                out.keys[hash] = key;
                ++out.size;
            }
            ++i;
        }
        return out;
    }

    private Object readResolve() {
        SetInt out = new SetInt(this.calcInit());
        int i = 0;
        while (i < this.capacity) {
            if (this.used[i]) {
                out.add(this.keys[i]);
            }
            ++i;
        }
        return out;
    }

    static /* synthetic */ boolean[] access$2(SetInt setInt) {
        return setInt.used;
    }

    static /* synthetic */ int[] access$3(SetInt setInt) {
        return setInt.keys;
    }
}

