/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.snapshot.actions.ExportInfo;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.swt.widgets.Display;

public abstract class CopyActions
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument
    public List<IContextObject> elements;
    @Argument
    public Display display;

    public IResult execute(IProgressListener listener) throws Exception {
        try {
            final StringBuilder buf = new StringBuilder(128);
            String lineSeparator = System.getProperty("line.separator");
            listener.beginTask(Messages.CopyActions_CopyingToClipboard, this.elements.size());
            for (IContextObject argument : this.elements) {
                int objectId = argument.getObjectId();
                if (objectId >= 0) {
                    IObject object = this.snapshot.getObject(objectId);
                    if (buf.length() > 0) {
                        buf.append(lineSeparator);
                    }
                    this.appendValue(buf, object);
                } else {
                    this.appendValue(buf, argument);
                }
                listener.worked(1);
                if (listener.isCanceled()) break;
            }
            listener.done();
            if (buf.length() > 0) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Copy.copyToClipboard(buf.toString(), CopyActions.this.display);
                    }
                });
            }
            throw new IProgressListener.OperationCanceledException();
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void appendValue(StringBuilder var1, IObject var2) throws SnapshotException;

    protected void appendValue(StringBuilder buf, IContextObject ctx) throws SnapshotException {
    }

    @Icon(value="/icons/copy.gif")
    @HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/copy.html#ref_inspections_copy__address")
    public static class Address
    extends CopyActions {
        @Override
        protected void appendValue(StringBuilder buf, IObject object) {
            buf.append("0x").append(Long.toHexString(object.getObjectAddress()));
        }

        @Override
        protected void appendValue(StringBuilder buf, IContextObject ctx) throws SnapshotException {
            String addr;
            String dummy;
            IContextObjectSet ctxs;
            String oql;
            if (ctx instanceof IContextObjectSet && (oql = (ctxs = (IContextObjectSet)ctx).getOQL()) != null && ctxs.getObjectIds().length == 0 && oql.startsWith((dummy = OQL.forAddress((long)0L)).substring(0, dummy.length() - 3)) && (addr = oql.substring(dummy.length() - 3)).matches("0[xX][0-9A-Fa-f]+")) {
                if (buf.length() > 0) {
                    buf.append(System.lineSeparator());
                }
                buf.append(addr);
            }
        }
    }

    static abstract class CopyActions2
    extends CopyActions {
        CopyActions2() {
        }

        @Override
        protected void appendValue(StringBuilder buf, IContextObject ctx) throws SnapshotException {
            String addr;
            String dummy;
            IContextObjectSet ctxs;
            String oql;
            if (ctx instanceof IContextObjectSet && (oql = (ctxs = (IContextObjectSet)ctx).getOQL()) != null && ctxs.getObjectIds().length == 0 && oql.startsWith((dummy = OQL.forAddress((long)0L)).substring(0, dummy.length() - 3)) && (addr = oql.substring(dummy.length() - 3)).matches("0[xX][0-9A-Fa-f]+")) {
                long l = Long.parseUnsignedLong(addr.substring(2), 16);
                ObjectReference ref = new ObjectReference(this.snapshot, l);
                IObject obj = ref.getObject();
                if (buf.length() > 0) {
                    buf.append(System.lineSeparator());
                }
                this.appendValue(buf, obj);
            }
        }
    }

    @Icon(value="/icons/copy.gif")
    @HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/copy.html#ref_inspections_copy__fqclassname")
    public static class FQClassName
    extends CopyActions2 {
        @Override
        protected void appendValue(StringBuilder buf, IObject object) {
            if (object instanceof IClass) {
                buf.append(((IClass)object).getName());
            } else {
                buf.append(object.getClazz().getName());
            }
        }
    }

    @Icon(value="/icons/copy.gif")
    @HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/copy.html#ref_inspections_copy__value")
    public static class Value
    extends CopyActions2 {
        @Override
        protected void appendValue(StringBuilder buf, IObject object) throws SnapshotException {
            ExportInfo info = ExportInfo.of(object);
            if (info != null) {
                int length = info.getLength();
                int end = Math.min(info.getOffset() + info.getCount(), length);
                int offset = info.getOffset();
                while (offset < end) {
                    int read = Math.min(4092, end - offset);
                    char[] array = info.getChars(offset, read);
                    buf.append(new String(array));
                    offset += read;
                }
            } else {
                String name = object.getClassSpecificName();
                buf.append(name != null ? name : object.getTechnicalName());
            }
        }
    }
}

