/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.ide.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.context.ui.SearchInterestFilter;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.ui.IViewPart;

public class FocusSearchResultsViewAction
extends AbstractFocusViewAction {
    private static final List<String> WHITELISTED_IDS = Arrays.asList("org.eclipse.search.text.FileSearchResultPage", "org.eclipse.jdt.ui.JavaSearchResultPage");

    public FocusSearchResultsViewAction() {
        super((InterestFilter)new SearchInterestFilter(), true, true, true);
    }

    public List<StructuredViewer> getViewers() {
        ArrayList<StructuredViewer> viewers = new ArrayList<StructuredViewer>();
        ISearchResultPage page = this.getCurrentPage();
        if (page instanceof AbstractTextSearchViewPage) {
            try {
                Method getViewer = AbstractTextSearchViewPage.class.getDeclaredMethod("getViewer", new Class[0]);
                getViewer.setAccessible(true);
                StructuredViewer viewer = (StructuredViewer)getViewer.invoke((Object)page, new Object[0]);
                viewers.add(viewer);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return viewers;
    }

    private ISearchResultPage getCurrentPage() {
        IViewPart view = super.getPartForAction();
        return ((SearchView)view).getActivePage();
    }

    public boolean isEnabled() {
        List<StructuredViewer> viewers = this.getViewers();
        ISearchResultPage page = this.getCurrentPage();
        return viewers.size() > 0 && WHITELISTED_IDS.contains(page.getID());
    }

    protected void updateEnablement(IAction action) {
        action.setEnabled(this.isEnabled());
    }
}

