/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.Messages;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsImages;
import org.eclipse.mylyn.internal.reviews.ui.compare.Direction;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileItemNode;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewCompareAnnotationSupport;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public abstract class ReviewItemCompareEditorInput
extends CompareEditorInput {
    private static final String NAVIGATION_GROUP = "navigation";
    private static final String ID_NEXT_COMMENT = "org.eclipse.mylyn.reviews.uinavigate.comment.next";
    private static final String ID_PREVIOUS_COMMENT = "org.eclipse.mylyn.reviews.uinavigate.comment.previous";
    final ReviewBehavior behavior;
    private ReviewCompareAnnotationSupport currentSupport;

    public ReviewItemCompareEditorInput(CompareConfiguration configuration, ReviewBehavior behavior) {
        super(configuration);
        this.behavior = behavior;
    }

    /*
     * WARNING - void declaration
     */
    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer structureViewer = super.findStructureViewer(oldViewer, input, parent);
        Viewer viewer = structureViewer;
        if (viewer instanceof StructureDiffViewer) {
            void diffViewer;
            StructureDiffViewer structureDiffViewer = (StructureDiffViewer)viewer;
            StructureDiffViewer cfr_ignored_0 = (StructureDiffViewer)viewer;
            diffViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ITypedElement) {
                        return ((ITypedElement)element).getName();
                    }
                    return "<no name>";
                }

                /*
                 * WARNING - void declaration
                 */
                public Image getImage(Object element) {
                    Object object = element;
                    if (object instanceof IDiffElement) {
                        void input;
                        IDiffElement iDiffElement = (IDiffElement)object;
                        IDiffElement cfr_ignored_0 = (IDiffElement)object;
                        int kind = input.getKind();
                        if (kind == 1) {
                            kind = 2;
                        } else if (kind == 2) {
                            kind = 1;
                        }
                        return ReviewItemCompareEditorInput.this.getCompareConfiguration().getImage(input.getImage(), kind);
                    }
                    return null;
                }
            });
        }
        return structureViewer;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer contentViewer = super.findContentViewer(oldViewer, input, parent);
        if (input instanceof FileItemNode && ((FileItemNode)input).getFileItem() != null) {
            this.currentSupport = ReviewCompareAnnotationSupport.getAnnotationSupport(contentViewer);
            this.currentSupport.setReviewItem(((FileItemNode)input).getFileItem(), this.behavior);
            this.initializeGotoCommentHandlers(parent);
        }
        return contentViewer;
    }

    public void gotoComment(IComment comment) {
        if (this.currentSupport != null) {
            this.currentSupport.gotoAnnotationWithComment(comment);
        }
    }

    private void initializeGotoCommentHandlers(Composite parent) {
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)parent);
        if (tbm != null) {
            if (tbm.find(NAVIGATION_GROUP) != null) {
                if (tbm.find(ID_NEXT_COMMENT) == null) {
                    Action goToNextAction = new Action(Messages.Reviews_NextComment, ReviewsImages.NEXT_COMMENT){

                        public void run() {
                            if (ReviewItemCompareEditorInput.this.currentSupport != null) {
                                ReviewItemCompareEditorInput.this.currentSupport.gotoAnnotation(Direction.FORWARDS);
                            }
                        }
                    };
                    goToNextAction.setId(ID_NEXT_COMMENT);
                    goToNextAction.setToolTipText(Messages.Reviews_NextComment_Tooltip);
                    tbm.appendToGroup(NAVIGATION_GROUP, (IAction)goToNextAction);
                }
                if (tbm.find(ID_PREVIOUS_COMMENT) == null) {
                    Action goToPreviousAction = new Action(Messages.Reviews_PreviousComment, ReviewsImages.PREVIOUS_COMMENT){

                        public void run() {
                            if (ReviewItemCompareEditorInput.this.currentSupport != null) {
                                ReviewItemCompareEditorInput.this.currentSupport.gotoAnnotation(Direction.BACKWARDS);
                            }
                        }
                    };
                    goToPreviousAction.setId(ID_PREVIOUS_COMMENT);
                    goToPreviousAction.setToolTipText(Messages.Reviews_PreviousComment_Tooltip);
                    tbm.appendToGroup(NAVIGATION_GROUP, (IAction)goToPreviousAction);
                }
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Could not create comment navigation buttons", (Throwable)new Exception()));
            }
            tbm.update(true);
        }
    }

    public String getItemTaskId() {
        return this.behavior.getTask().getTaskId();
    }
}

