/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public abstract class AbstractTaskRepositoryAction
extends BaseSelectionListenerAction {
    private boolean singleSelect;

    public AbstractTaskRepositoryAction(String text) {
        super(text);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object[] array;
            if (this.singleSelect && (array = selection.toArray()).length != 1) {
                return false;
            }
            return this.getTaskRepository(selection.getFirstElement()) != null;
        }
        return false;
    }

    protected TaskRepository getTaskRepository(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            return this.getTaskRepository(selection.getFirstElement());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected TaskRepository getTaskRepository(Object selectedObject) {
        TaskRepository taskRepository = null;
        if (selectedObject instanceof TaskRepository) {
            taskRepository = (TaskRepository)selectedObject;
        } else {
            Object object = selectedObject;
            if (object instanceof IRepositoryQuery) {
                void query;
                IRepositoryQuery iRepositoryQuery = (IRepositoryQuery)object;
                IRepositoryQuery cfr_ignored_0 = (IRepositoryQuery)object;
                taskRepository = TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
            }
        }
        if (taskRepository != null && this.isUserManaged(taskRepository)) {
            return taskRepository;
        }
        return null;
    }

    protected boolean isUserManaged(TaskRepository taskRepository) {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(taskRepository.getConnectorKind());
        return connector != null && connector.isUserManaged();
    }

    protected boolean isSingleSelect() {
        return this.singleSelect;
    }

    protected void setSingleSelect(boolean singleSelect) {
        this.singleSelect = singleSelect;
    }
}

