/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.PresentationFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestFilter;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

public class TaskListContentProvider
extends AbstractTaskListContentProvider {
    protected static Object[] EMPTY_ARRRY = new Object[0];

    public TaskListContentProvider(AbstractTaskListView taskListView) {
        super(taskListView);
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.taskListView.expandToActiveTasks();
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.taskListView.getViewSite())) {
            return this.applyFilter(TasksUiPlugin.getTaskList().getRootElements()).toArray();
        }
        return this.getChildren(parent);
    }

    /*
     * WARNING - void declaration
     */
    public Object getParent(Object child) {
        Object object = child;
        if (object instanceof ITask) {
            void task;
            ITask iTask = (ITask)object;
            ITask cfr_ignored_0 = (ITask)object;
            AbstractTaskCategory parent = TaskCategory.getParentTaskCategory((ITask)task);
            if (parent != null) {
                return parent;
            }
            Set parents = ((AbstractTask)task).getParentContainers();
            Iterator it = parents.iterator();
            if (it.hasNext()) {
                return parents.iterator().next();
            }
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        return this.getFilteredChildrenFor(parent).toArray();
    }

    public boolean hasChildren(Object parent) {
        Object[] children = this.getChildren(parent);
        return children != null && children.length > 0;
    }

    protected List<AbstractTaskContainer> applyFilter(Set<AbstractTaskContainer> roots) {
        ArrayList<AbstractTaskContainer> filteredRoots = new ArrayList<AbstractTaskContainer>();
        for (AbstractTaskContainer element : roots) {
            if (!this.selectContainer((ITaskContainer)element)) continue;
            filteredRoots.add(element);
        }
        return filteredRoots;
    }

    private boolean containsNoFilterText(String filterText) {
        return filterText == null || filterText.trim().length() == 0;
    }

    private boolean selectContainer(ITaskContainer container) {
        return !this.filter(null, container);
    }

    protected List<IRepositoryElement> getFilteredChildrenFor(Object parent) {
        if (this.containsNoFilterText(this.taskListView.getFilteredTree().getFilterString())) {
            ArrayList<IRepositoryElement> children = new ArrayList<IRepositoryElement>();
            if (parent instanceof ITask) {
                Collection subTasks = ((AbstractTask)parent).getChildren();
                for (ITask task : subTasks) {
                    if (this.filter(parent, task)) continue;
                    children.add((IRepositoryElement)task);
                }
                return children;
            }
            if (parent instanceof ITaskContainer) {
                return this.getFilteredRootChildren((ITaskContainer)parent);
            }
        } else {
            ArrayList<IRepositoryElement> children = new ArrayList<IRepositoryElement>();
            if (parent instanceof ITaskContainer) {
                children.addAll(((ITaskContainer)parent).getChildren());
                return children;
            }
        }
        return Collections.emptyList();
    }

    private List<IRepositoryElement> getFilteredRootChildren(ITaskContainer parent) {
        ArrayList<IRepositoryElement> result = new ArrayList<IRepositoryElement>();
        if (TasksUiPlugin.getDefault().groupSubtasks(parent)) {
            Collection parentTasks = parent.getChildren();
            HashSet<ITask> parents = new HashSet<ITask>();
            HashSet children = new HashSet();
            for (ITask element : parentTasks) {
                if (!(element instanceof ITaskContainer)) continue;
                children.addAll(((ITaskContainer)element).getChildren());
            }
            for (ITask task : parentTasks) {
                if (this.filter(parent, task) || children.contains(task)) continue;
                parents.add(task);
            }
            result.addAll(parents);
        } else {
            for (IRepositoryElement element : parent.getChildren()) {
                if (this.filter(parent, element)) continue;
                result.add(element);
            }
        }
        return result;
    }

    protected boolean filter(Object parent, Object object) {
        boolean notSearching = this.containsNoFilterText(this.taskListView.getFilteredTree().getFilterString());
        for (AbstractTaskListFilter filter : this.taskListView.getFilters()) {
            if (!notSearching && !filter.applyToFilteredText() || filter.select(parent, object)) continue;
            return true;
        }
        return false;
    }

    protected boolean filter(TreePath path, Object parent, Object object) {
        boolean emptyFilterText = this.containsNoFilterText(this.taskListView.getFilteredTree().getFilterString());
        for (AbstractTaskListFilter filter : this.taskListView.getFilters()) {
            if (!emptyFilterText && !filter.applyToFilteredText() || !(filter instanceof TaskListInterestFilter ? !((TaskListInterestFilter)filter).select(path.getLastSegment(), object) : !filter.select(parent, object))) continue;
            return true;
        }
        return false;
    }

    public boolean isSearching() {
        return !this.containsNoFilterText(this.taskListView.getFilteredTree().getFilterString());
    }

    public Object[] getChildren(TreePath parentPath) {
        ITaskContainer container;
        Object parent = parentPath.getLastSegment();
        if (PresentationFilter.getInstance().isFilterNonMatching() && ((container = (ITaskContainer)parentPath.getFirstSegment()) instanceof IRepositoryQuery || container instanceof UnmatchedTaskContainer)) {
            if (parent instanceof ITask && container instanceof RepositoryQuery && !TasksUiPlugin.getDefault().groupSubtasks(container)) {
                return EMPTY_ARRRY;
            }
            List<IRepositoryElement> children = this.getFilteredChildrenFor(parent);
            if (!this.isSearching() && parent instanceof ITask) {
                Iterator<IRepositoryElement> it = children.iterator();
                while (it.hasNext()) {
                    IRepositoryElement element = it.next();
                    if (container.getChildren().contains(element)) continue;
                    it.remove();
                }
            }
            return children.toArray();
        }
        return this.getFilteredChildrenFor(parent).toArray();
    }

    public boolean hasChildren(TreePath path) {
        return this.getChildren(path).length > 0;
    }

    public TreePath[] getParents(Object element) {
        return new TreePath[0];
    }
}

