/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.util.ImageCache;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.AnnotationHyperlinkDetector;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.Util;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.ImageAnnotation;
import org.eclipse.mylyn.wikitext.ui.viewer.HtmlViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class ImageManager
implements ITextInputListener,
DisposeListener,
IDocumentListener,
ISelectionChangedListener {
    private final HtmlViewer viewer;
    private final Display display;
    private final ImageCache imageCache;
    private final Set<ImageAnnotation> annotations = new HashSet<ImageAnnotation>();
    private ImageResolver imageResolver;
    private boolean computingChanges;
    private final AnnotationPainter painter;
    private boolean armed = false;
    private Cursor cursor;
    private Cursor previousCursor;
    private static final AtomicInteger resolverIdSeed = new AtomicInteger(1);

    public ImageManager(HtmlViewer viewer, ImageCache imageCache, AnnotationPainter painter) {
        this.viewer = viewer;
        this.painter = painter;
        this.display = viewer.getTextWidget().getDisplay();
        this.imageCache = imageCache;
        this.inspect();
        viewer.getTextWidget().addDisposeListener((DisposeListener)this);
        viewer.addTextInputListener(this);
        if (viewer.getDocument() != null) {
            viewer.getDocument().addDocumentListener((IDocumentListener)this);
        }
        viewer.addSelectionChangedListener(this);
        viewer.addPostSelectionChangedListener(this);
        HyperlinkMouseListener mouseListener = new HyperlinkMouseListener();
        viewer.getTextWidget().addMouseMoveListener((MouseMoveListener)mouseListener);
        viewer.getTextWidget().addMouseListener((MouseListener)mouseListener);
    }

    private IHyperlink getHyperlink(MouseEvent e) {
        if (this.annotations.isEmpty()) {
            return null;
        }
        Point point = new Point(e.x, e.y);
        for (ImageAnnotation annotation : this.annotations) {
            AnnotationHyperlinkDetector detector;
            Rectangle region;
            if (annotation.getHyperlnkAnnotation() == null || (region = this.getRegion(annotation)) == null || !region.contains(point) || (detector = (AnnotationHyperlinkDetector)this.viewer.getTextWidget().getData(AnnotationHyperlinkDetector.class.getName())) == null) continue;
            return detector.createHyperlink((ISourceViewer)this.viewer, this.viewer.getAnnotationModel(), annotation.getHyperlnkAnnotation());
        }
        return null;
    }

    public void clicked(MouseEvent e) {
        IHyperlink hyperlink = this.getHyperlink(e);
        if (hyperlink != null) {
            this.disarm();
            hyperlink.open();
        }
    }

    private Rectangle getRegion(ImageAnnotation annotation) {
        if (annotation.getImage() == null) {
            return null;
        }
        Position position = this.viewer.getAnnotationModel().getPosition((Annotation)annotation);
        Point locationAtOffset = this.viewer.getTextWidget().getLocationAtOffset(position.offset);
        Rectangle bounds = annotation.getImage().getBounds();
        return new Rectangle(locationAtOffset.x, locationAtOffset.y, bounds.width, bounds.height);
    }

    void adjust(MouseEvent e) {
        IHyperlink hyperlink = this.getHyperlink(e);
        if (hyperlink == null) {
            this.disarm();
        } else {
            this.armed = true;
            Cursor currentCursor = this.viewer.getTextWidget().getCursor();
            if (this.cursor == null || currentCursor != this.cursor) {
                this.previousCursor = currentCursor;
                if (this.cursor == null) {
                    this.cursor = new Cursor((Device)this.viewer.getTextWidget().getDisplay(), 21);
                }
                this.viewer.getTextWidget().setCursor(this.cursor);
            }
        }
    }

    void disarm() {
        if (this.armed) {
            if (this.previousCursor != null) {
                this.viewer.getTextWidget().setCursor(this.previousCursor);
            }
            this.armed = false;
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        this.stop();
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput != null) {
            oldInput.removeDocumentListener((IDocumentListener)this);
        }
        if (newInput != null) {
            newInput.addDocumentListener((IDocumentListener)this);
        }
        this.inspect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void inspect() {
        Object iterator;
        ImageManager imageManager = this;
        synchronized (imageManager) {
            this.annotations.clear();
            if (this.viewer.getAnnotationModel() != null) {
                iterator = this.viewer.getAnnotationModel().getAnnotationIterator();
                while (iterator.hasNext()) {
                    void imageAnnotation;
                    Annotation annotation = (Annotation)iterator.next();
                    Annotation annotation2 = annotation;
                    if (!(annotation2 instanceof ImageAnnotation)) continue;
                    ImageAnnotation cfr_ignored_0 = (ImageAnnotation)annotation2;
                    ImageAnnotation cfr_ignored_1 = (ImageAnnotation)annotation2;
                    this.annotations.add((ImageAnnotation)imageAnnotation);
                }
            }
        }
        if (!this.annotations.isEmpty()) {
            ImageResolver resolver;
            iterator = this;
            synchronized (iterator) {
                resolver = this.imageResolver;
            }
            if (resolver != null) {
                try {
                    resolver.join();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            this.imageResolver = new ImageResolver();
            this.imageResolver.start();
        }
    }

    private synchronized void stop() {
        ImageResolver resolver = this.imageResolver;
        if (resolver != null) {
            resolver.interrupt();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.cursor != null) {
            this.cursor.dispose();
            this.cursor = null;
        }
        this.stop();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.computingChanges) {
            return;
        }
        this.stop();
    }

    public void documentChanged(DocumentEvent event) {
        if (this.computingChanges) {
            return;
        }
        this.inspect();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        GC gc = new GC((Drawable)this.viewer.getTextWidget());
        try {
            Event e = new Event();
            e.gc = gc;
            e.widget = this.viewer.getTextWidget();
            Rectangle bounds = this.viewer.getTextWidget().getBounds();
            e.height = bounds.height;
            e.width = bounds.width;
            e.x = 0;
            e.y = 0;
            PaintEvent paintEvent = new PaintEvent(e);
            this.painter.paintControl(paintEvent);
        }
        finally {
            gc.dispose();
        }
    }

    private class HyperlinkMouseListener
    implements MouseMoveListener,
    MouseListener {
        private HyperlinkMouseListener() {
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            ImageManager.this.disarm();
        }

        public void mouseMove(MouseEvent e) {
            ImageManager.this.adjust(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            ImageManager.this.clicked(e);
        }
    }

    private class ImageResolver
    extends Thread {
        public ImageResolver() {
            this.setName(ImageResolver.class.getSimpleName() + "-" + resolverIdSeed.getAndIncrement());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                HashMap<String, ImageData> urlToImageData = new HashMap<String, ImageData>();
                for (ImageAnnotation annotation : ImageManager.this.annotations) {
                    String imgSrc = annotation.getUrl();
                    if (imgSrc != null && !urlToImageData.containsKey(imgSrc)) {
                        try {
                            URL location = ImageManager.this.imageCache.getBase() == null ? new URL(imgSrc) : new URL(ImageManager.this.imageCache.getBase(), imgSrc);
                            try {
                                Throwable throwable = null;
                                Object var7_11 = null;
                                try (BufferedInputStream in = new BufferedInputStream(location.openStream());){
                                    urlToImageData.put(imgSrc, new ImageData((InputStream)in));
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (SWTException e) {
                                if (e.code != 40) {
                                    throw e;
                                }
                                urlToImageData.put(imgSrc, null);
                            }
                            catch (Exception e) {
                                if (WikiTextUiPlugin.getDefault() != null) {
                                    WikiTextUiPlugin.getDefault().log(4, NLS.bind((String)Messages.ImageManager_accessFailed, (Object[])new Object[]{location}), e);
                                }
                                urlToImageData.put(imgSrc, null);
                            }
                        }
                        catch (MalformedURLException e) {
                            urlToImageData.put(imgSrc, null);
                        }
                        ImageManager.this.display.asyncExec(() -> this.updateImage(imgSrc, (ImageData)urlToImageData.get(imgSrc)));
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
            }
            finally {
                ImageManager.this.imageResolver = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void updateImage(String imgSrc, ImageData imageData) {
            if (ImageManager.this.display.isDisposed() || ImageManager.this.viewer.getTextWidget().isDisposed()) {
                return;
            }
            Image image = imageData == null ? ImageManager.this.imageCache.getMissingImage() : ImageDescriptor.createFromImageData((ImageData)imageData).createImage();
            ImageManager.this.imageCache.putImage(imgSrc, image);
            HashSet<void> modifiedAnnotations = new HashSet<void>();
            AnnotationModel annotationModel = (AnnotationModel)ImageManager.this.viewer.getAnnotationModel();
            Object annotationLockObject = annotationModel.getLockObject();
            if (annotationLockObject == null) {
                annotationLockObject = annotationModel;
            }
            Object object = annotationLockObject;
            synchronized (object) {
                Iterator iterator = annotationModel.getAnnotationIterator();
                while (iterator.hasNext()) {
                    void imageAnnotation;
                    Annotation annotation = (Annotation)iterator.next();
                    Annotation annotation2 = annotation;
                    if (!(annotation2 instanceof ImageAnnotation)) continue;
                    ImageAnnotation cfr_ignored_0 = (ImageAnnotation)annotation2;
                    ImageAnnotation cfr_ignored_1 = (ImageAnnotation)annotation2;
                    if (!imgSrc.equals(imageAnnotation.getUrl())) continue;
                    imageAnnotation.setImage(image);
                    modifiedAnnotations.add(imageAnnotation);
                }
            }
            if (!modifiedAnnotations.isEmpty()) {
                ImageManager.this.computingChanges = true;
                try {
                    boolean rangesAdjusted = false;
                    ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
                    Iterator allStyleRangeIterator = ImageManager.this.viewer.getTextPresentation().getAllStyleRangeIterator();
                    while (allStyleRangeIterator.hasNext()) {
                        StyleRange range = (StyleRange)allStyleRangeIterator.next();
                        ranges.add((StyleRange)range.clone());
                    }
                    GC gc = new GC((Drawable)ImageManager.this.viewer.getTextWidget());
                    try {
                        ImageManager.this.viewer.getTextWidget().setRedraw(false);
                        TextPresentation textPresentation = ImageManager.this.viewer.getTextPresentation();
                        for (ImageAnnotation imageAnnotation : modifiedAnnotations) {
                            int numNewlines;
                            StyleRange styleRange;
                            int height = imageAnnotation.getImage().getBounds().height;
                            Position position = annotationModel.getPosition((Annotation)imageAnnotation);
                            String widgetText = ImageManager.this.viewer.getTextWidget().getText();
                            Font font = null;
                            if (widgetText.length() > 0 && widgetText.length() > position.offset && (styleRange = ImageManager.this.viewer.getTextWidget().getStyleRangeAtOffset(position.offset)) != null) {
                                font = styleRange.font;
                            }
                            if (font == null) {
                                font = ImageManager.this.viewer.getTextWidget().getFont();
                            }
                            gc.setFont(font);
                            Point extent = gc.textExtent("\n");
                            if (extent.y <= 0) continue;
                            int originalNewlines = numNewlines = (int)Math.ceil((double)height / (double)extent.y);
                            IDocument document = ImageManager.this.viewer.getDocument();
                            try {
                                int x = position.offset;
                                while (x < document.getLength()) {
                                    if (document.getChar(x) != '\n' || x != position.offset && Util.annotationsIncludeOffset(ImageManager.this.viewer.getAnnotationModel(), x)) break;
                                    --numNewlines;
                                    ++x;
                                }
                                if (numNewlines > 0) {
                                    Object newlines = "";
                                    int x2 = 0;
                                    while (x2 < numNewlines) {
                                        newlines = (String)newlines + "\n";
                                        ++x2;
                                    }
                                    document.replace(position.offset + 1, 0, (String)newlines);
                                } else if (numNewlines < 0) {
                                    document.replace(position.offset, -numNewlines, "");
                                }
                                if (numNewlines != 0) {
                                    for (StyleRange range : ranges) {
                                        if (range.start > position.offset) {
                                            range.start += numNewlines;
                                            rangesAdjusted = true;
                                            continue;
                                        }
                                        if (range.start + range.length <= position.offset) continue;
                                        range.length += numNewlines;
                                        rangesAdjusted = true;
                                    }
                                }
                                if (position.getLength() == originalNewlines) continue;
                                annotationModel.modifyAnnotationPosition((Annotation)imageAnnotation, new Position(position.offset, originalNewlines));
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        if (rangesAdjusted) {
                            TextPresentation textPresentation2 = new TextPresentation();
                            if (textPresentation.getDefaultStyleRange() != null) {
                                StyleRange defaultStyleRange = (StyleRange)textPresentation.getDefaultStyleRange().clone();
                                if (ImageManager.this.viewer.getDocument() != null && defaultStyleRange.length < ImageManager.this.viewer.getDocument().getLength()) {
                                    defaultStyleRange.length = ImageManager.this.viewer.getDocument().getLength();
                                }
                                textPresentation2.setDefaultStyleRange(defaultStyleRange);
                            }
                            for (StyleRange range : ranges) {
                                textPresentation2.addStyleRange(range);
                            }
                            ImageManager.this.viewer.setTextPresentation(textPresentation2);
                            ImageManager.this.viewer.invalidateTextPresentation();
                        }
                    }
                    finally {
                        ImageManager.this.viewer.getTextWidget().setRedraw(true);
                        gc.dispose();
                    }
                    ImageManager.this.viewer.getTextWidget().redraw();
                }
                finally {
                    ImageManager.this.computingChanges = false;
                }
            }
        }
    }
}

