/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.log;

import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.log.OMLogger;

public class Logger
implements OMLogger {
    private OMBundle bundle;

    public Logger(OMBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public OMBundle getBundle() {
        return this.bundle;
    }

    @Override
    public void log(OMLogger.Level level, String msg, Throwable t) {
        ((AbstractPlatform)this.bundle.getPlatform()).log(this, level, msg, t);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(OMLogger.Level.ERROR, msg, t);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(OMLogger.Level.WARN, msg, t);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(OMLogger.Level.INFO, msg, t);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(OMLogger.Level.DEBUG, msg, t);
    }

    @Override
    public void log(OMLogger.Level level, String msg) {
        this.log(level, msg, null);
    }

    @Override
    public void error(String msg) {
        this.log(OMLogger.Level.ERROR, msg);
    }

    @Override
    public void warn(String msg) {
        this.log(OMLogger.Level.WARN, msg);
    }

    @Override
    public void info(String msg) {
        this.log(OMLogger.Level.INFO, msg);
    }

    @Override
    public void debug(String msg) {
        this.log(OMLogger.Level.DEBUG, msg);
    }

    @Override
    public void log(OMLogger.Level level, Throwable t) {
        if (t != null) {
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.getClass().getSimpleName();
            }
            this.log(level, msg, t);
        }
    }

    @Override
    public void error(Throwable t) {
        this.log(OMLogger.Level.ERROR, t);
    }

    @Override
    public void warn(Throwable t) {
        this.log(OMLogger.Level.WARN, t);
    }

    @Override
    public void info(Throwable t) {
        this.log(OMLogger.Level.INFO, t);
    }

    @Override
    public void debug(Throwable t) {
        this.log(OMLogger.Level.DEBUG, t);
    }
}

