/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.validity.locator.AbstractPivotConstraintLocator;
import org.eclipse.ocl.examples.validity.plugin.OCLValidityPlugin;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class DelegateConstraintLocator
extends AbstractPivotConstraintLocator {
    public static @NonNull DelegateConstraintLocator INSTANCE = new DelegateConstraintLocator();

    protected @Nullable Constraint getConstraint(@NonNull PivotMetamodelManager metamodelManager, @NonNull ResultConstrainingNode resultConstrainingNode) throws ParserException {
        Class asType;
        EObject eClassifier;
        EStringToStringMapEntryImpl eEntry;
        EObject eAnnotation;
        Object constrainingObject = resultConstrainingNode.getParent().getConstrainingObject();
        if (constrainingObject instanceof EAnnotation) {
            EObject eObject = ((EAnnotation)constrainingObject).eContainer();
            if (eObject instanceof EOperation) {
                return (Constraint)((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)metamodelManager.getEnvironmentFactory()).getASOf(Constraint.class, eObject);
            }
        } else if (constrainingObject instanceof EStringToStringMapEntryImpl && (eAnnotation = (eEntry = (EStringToStringMapEntryImpl)constrainingObject).eContainer()) instanceof EAnnotation && (eClassifier = ((EAnnotation)eAnnotation).eContainer()) instanceof EClassifier && (asType = (Class)((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)metamodelManager.getEnvironmentFactory()).getASOf(Class.class, eClassifier)) != null) {
            return (Constraint)NameUtil.getNameable((Iterable)asType.getOwnedInvariants(), (String)eEntry.getKey());
        }
        return null;
    }

    protected EObject getConstrainedObject(@NonNull ResultConstrainingNode resultConstrainingNode) {
        ValidatableNode validatableNode = resultConstrainingNode.getResultValidatableNode().getParent();
        assert (validatableNode != null);
        return validatableNode.getConstrainedObject();
    }

    public @Nullable Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> getConstraints(@NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull Set<@NonNull Resource> resources, @NonNull Monitor monitor) {
        if (ePackage.eContainer() instanceof EAnnotation) {
            return null;
        }
        Map map = null;
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            String constraintName;
            if (monitor.isCanceled()) {
                return null;
            }
            EAnnotation oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
            if (oclAnnotation != null) {
                EMap details = oclAnnotation.getDetails();
                for (Map.Entry constraint : details.entrySet()) {
                    constraintName = (String)constraint.getKey();
                    if (constraintName == null) continue;
                    map = this.createLeafConstrainingNode(map, validityModel, (EObject)eClassifier, constraint, constraintName);
                }
            }
            if (!(eClassifier instanceof EClass)) continue;
            for (EOperation eOperation : ((EClass)eClassifier).getEOperations()) {
                String constraintBody;
                if (!EcoreUtil.isInvariant((EOperation)eOperation) || (oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation)) == null || (constraintBody = (String)oclAnnotation.getDetails().get((Object)"body")) == null || (constraintName = eOperation.getName()) == null) continue;
                map = this.createLeafConstrainingNode(map, validityModel, (EObject)eClassifier, oclAnnotation, constraintName);
            }
        }
        return map;
    }

    public Object getImage() {
        return OCLValidityPlugin.INSTANCE.getImage("OCLModelFile.gif");
    }

    public @NonNull ConstraintLocator getInstance() {
        return INSTANCE;
    }

    public @NonNull String getName() {
        return "Delegated OCL constraints";
    }

    public @Nullable String getSourceExpression(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (constrainingObject instanceof EAnnotation) {
            return (String)((EAnnotation)constrainingObject).getDetails().get((Object)"body");
        }
        if (constrainingObject instanceof EStringToStringMapEntryImpl) {
            return ((EStringToStringMapEntryImpl)constrainingObject).getValue();
        }
        return null;
    }

    protected @NonNull String print(@NonNull Map<EClassifier, @NonNull List<LeafConstrainingNode>> map) {
        StringBuilder s = new StringBuilder();
        ArrayList<EClassifier> sortedList = new ArrayList<EClassifier>(map.keySet());
        Collections.sort(sortedList, new Comparator<EClassifier>(){

            @Override
            public int compare(EClassifier o1, EClassifier o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (EClassifier eClassifier : sortedList) {
            s.append("\t" + eClassifier.getName() + ":");
            List<LeafConstrainingNode> constraints = map.get(eClassifier);
            assert (constraints != null);
            for (LeafConstrainingNode constraint : constraints) {
                s.append(" '" + constraint.getLabel() + "'");
            }
            s.append("\n");
        }
        return s.toString();
    }

    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        EObject constrainedObject = result.getValidatableNode().getConstrainedObject();
        ResultConstrainingNode resultConstrainingNode = result.getResultConstrainingNode();
        if (resultConstrainingNode == null) {
            return;
        }
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory((Object)constrainedObject);
        final PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        Constraint asConstraint = null;
        try {
            asConstraint = this.getConstraint(metamodelManager, resultConstrainingNode);
        }
        catch (ParserException e1) {
            e1.printStackTrace();
        }
        Severity severity = Severity.UNKNOWN;
        try {
            try {
                if (asConstraint == null) {
                    throw new ParserException("Failed to create pivot Constraint");
                }
                final Constraint finalConstraint = asConstraint;
                ExpressionInOCL query = this.getQuery(metamodelManager, asConstraint);
                EvaluationVisitor evaluationVisitor = this.createEvaluationVisitor(environmentFactory, query, constrainedObject, monitor);
                AbstractPivotConstraintLocator.AbstractConstraintEvaluatorWithContext constraintEvaluator = new AbstractPivotConstraintLocator.AbstractConstraintEvaluatorWithContext(query, constrainedObject){

                    protected String getObjectLabel() {
                        Type type = PivotUtil.getContainingType((EObject)finalConstraint);
                        Type primaryType = type != null ? metamodelManager.getPrimaryType(type) : null;
                        EClassifier classifier = primaryType != null ? (EClassifier)primaryType.getESObject() : null;
                        return classifier != null ? classifier.getName() : "??";
                    }
                };
                Diagnostic diagnostic = (Diagnostic)constraintEvaluator.evaluate(evaluationVisitor);
                result.setDiagnostic((Object)diagnostic);
                severity = diagnostic != null ? this.getSeverity(diagnostic) : Severity.OK;
            }
            catch (Throwable e) {
                result.setException(e);
                severity = Severity.FATAL;
                result.setSeverity(severity);
            }
        }
        finally {
            result.setSeverity(severity);
        }
    }
}

