/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser.php80;

import java.io.Reader;
import java.util.LinkedList;
import java_cup.runtime.Symbol;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.php.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.core.compiler.ast.nodes.Comment;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.ast.scanner.php80.PHPAstLexer;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.DocumentorLexer;

public class CompilerAstLexer
extends PHPAstLexer {
    private PHPDocBlock latestDocBlock;

    public CompilerAstLexer(Reader in) {
        super(in);
    }

    @Override
    protected void handleVarComment() {
        int end;
        int start;
        String content = this.yytext();
        VarComment varComment = ASTUtils.parseVarComment(content, start = this.getTokenStartPosition(), end = start + this.getTokenLength());
        if (varComment != null) {
            ((LinkedList)this.getCommentList()).add(varComment);
        }
    }

    @Override
    protected void addComment(int type) {
        int leftPosition = this.getTokenStartPosition();
        Comment comment = new Comment(this.commentStartPosition, leftPosition + this.getTokenLength(), type);
        ((LinkedList)this.getCommentList()).add(comment);
    }

    protected void addVarComment() {
    }

    @Override
    protected IDocumentorLexer getDocumentorLexer(Reader reader) {
        DocumentorLexer lexer = new DocumentorLexer(reader);
        return lexer;
    }

    @Override
    protected boolean parsePHPDoc() {
        boolean result = super.parsePHPDoc();
        if (result) {
            this.latestDocBlock = (PHPDocBlock)((Object)((LinkedList)this.getCommentList()).getLast());
        }
        return result;
    }

    @Override
    protected Symbol createFullSymbol(int symbolNumber) {
        Symbol symbol = super.createFullSymbol(symbolNumber);
        switch (symbolNumber) {
            case 36: 
            case 37: 
            case 47: 
            case 52: 
            case 53: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 157: 
            case 164: 
            case 166: {
                symbol.value = new PHPDocBlockSymbolPair((String)symbol.value, this.latestDocBlock);
                break;
            }
            case 66: {
                symbol.value = new PHPHeredocSymbolPair((String)symbol.value, this.lastHeredocIndentation);
            }
        }
        this.latestDocBlock = null;
        return symbol;
    }

    protected static class PHPDocBlockSymbolPair {
        public String value;
        public PHPDocBlock doc;

        public PHPDocBlockSymbolPair(String value, PHPDocBlock block) {
            this.value = value;
            this.doc = block;
        }
    }

    protected static class PHPHeredocSymbolPair {
        @NonNull
        public String value;
        @NonNull
        public String innerIndentation;

        public PHPHeredocSymbolPair(@NonNull String value, @NonNull String innerIndentation) {
            this.value = value;
            this.innerIndentation = innerIndentation;
        }
    }
}

