/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.typeinference.goals.AbstractMethodReturnTypeGoal;

public class PHPDocMethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IMethod[] iMethodArray = this.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.exists()) {
                String[] typeNames = null;
                if (method instanceof IPHPDocAwareElement) {
                    typeNames = ((IPHPDocAwareElement)method).getReturnTypes();
                } else {
                    try {
                        String returnType = method.getType();
                        if (returnType != null) {
                            typeNames = new String[]{returnType};
                        } else {
                            LinkedList<String> returnTypeList = new LinkedList<String>();
                            this.evaluateReturnType(returnTypeList, method);
                            typeNames = returnTypeList.toArray(new String[returnTypeList.size()]);
                        }
                    }
                    catch (ModelException e) {
                        Logger.logException(e);
                    }
                }
                if (typeNames != null) {
                    AbstractMethodReturnTypeGoal goal = (AbstractMethodReturnTypeGoal)this.getGoal();
                    IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
                    IType space = currentNamespace != null ? currentNamespace : method.getSourceModule();
                    try {
                        this.evaluated.addAll(Arrays.asList(PHPEvaluationUtils.evaluatePHPDocType(typeNames, (IModelElement)space, method.getSourceRange().getOffset(), goal.getTypes())));
                    }
                    catch (ModelException e) {
                        Logger.logException(e);
                    }
                }
            }
            ++n2;
        }
        return IGoal.NO_GOALS;
    }

    private void evaluateReturnType(List<String> returnTypeList, IMethod method) throws ModelException {
        IType[] superClasses;
        if (!PHPFlags.isInheritdoc(method.getFlags())) {
            return;
        }
        IType type = method.getDeclaringType();
        if (type == null) {
            return;
        }
        IContext context = this.goal.getContext();
        IModelAccessCache cache = null;
        if (context instanceof IModelCacheContext) {
            cache = ((IModelCacheContext)context).getCache();
        }
        IType[] iTypeArray = superClasses = PHPModelUtils.getSuperClasses(type, cache == null ? null : cache.getSuperTypeHierarchy(type, null));
        int n = superClasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType superClass = iTypeArray[n2];
            IMethod superClassMethod = superClass.getMethod(method.getElementName());
            if (superClassMethod != null && superClassMethod.exists()) {
                String returnType = superClassMethod.getType();
                if (returnType != null) {
                    Collections.addAll(returnTypeList, StringUtils.split((String)returnType, (char)'|'));
                }
                this.evaluateReturnType(returnTypeList, superClassMethod);
            }
            ++n2;
        }
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

