/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import java.util.ArrayList;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageSection;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.engine.IProfileSessionListener;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.views.AbstractProfilerView;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class CodeCoverageSummaryView
extends AbstractProfilerView
implements IProfileSessionListener {
    private CodeCoverageSection fCodeCoverageSection;
    private ProfilerDB input;

    public void createPartControl(Composite parent) {
        this.createCodeCoverageForm(parent);
        ProfileSessionsManager.addProfileSessionListener((IProfileSessionListener)this);
        this.setInput(ProfileSessionsManager.getCurrent());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.code_coverage_summary_view");
    }

    private ViewForm createCodeCoverageForm(Composite parent) {
        ViewForm codeCoverageForm = new ViewForm(parent, 0);
        this.fCodeCoverageSection = new CodeCoverageSection((Composite)codeCoverageForm, (ViewPart)this, null);
        codeCoverageForm.setContent(this.fCodeCoverageSection.getComposite());
        return codeCoverageForm;
    }

    public void showCodeCoverage(final CodeCoverageData[] coveredFiles) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                CodeCoverageSummaryView.this.fCodeCoverageSection.showCodeCoverage(coveredFiles);
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.fCodeCoverageSection.dispose();
    }

    @Override
    public ProfilerDB getInput() {
        return this.input;
    }

    @Override
    public void setInput(ProfilerDB profilerDB) {
        if (profilerDB != null) {
            ArrayList<CodeCoverageData> codeCoverageDatas = new ArrayList<CodeCoverageData>();
            ProfilerFileData[] files = profilerDB.getFiles();
            int i = 0;
            while (i < files.length) {
                CodeCoverageData codeCoverageData = files[i].getCodeCoverageData();
                if (codeCoverageData != null) {
                    codeCoverageDatas.add(codeCoverageData);
                }
                ++i;
            }
            this.showCodeCoverage(codeCoverageDatas.toArray(new CodeCoverageData[codeCoverageDatas.size()]));
        } else {
            this.showCodeCoverage(null);
        }
        this.input = profilerDB;
    }

    public void currentSessionChanged(final ProfilerDB current) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CodeCoverageSummaryView.this.setInput(current);
            }
        });
    }

    public void profileSessionAdded(ProfilerDB db) {
    }

    public void profileSessionRemoved(ProfilerDB db) {
    }
}

