/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.wizards.types.NewPHPElementData;
import org.eclipse.php.internal.ui.wizards.types.PHPElementTemplate;

public class PHPClassTemplate
extends PHPElementTemplate {
    private String requiredPHPsBlock;

    @Override
    public String getTemplatePath() {
        return "resources/templates/ClassTemplate.tpl.php";
    }

    @Override
    public String processTemplate(NewPHPElementData data) {
        String interfaceName;
        this.set("default_phpdoc", "");
        this.extract("input", "superclass", "superclass_compiled");
        this.set("superclass", "");
        if (data.superClass != null) {
            String superClass = data.superClass.getElementName();
            if (!this.isImported(data, data.superClass)) {
                superClass = "\\" + superClass;
            }
            this.set("superclass_name", superClass);
            this.compile("superclass_compiled", "superclass", true);
        }
        this.extract("input", "interfaces", "interfaces_compiled");
        this.set("interfaces", "");
        if (data.interfaces.length > 0) {
            int i = 0;
            while (i < data.interfaces.length) {
                interfaceName = data.interfaces[i].getElementName();
                if (!this.isImported(data, data.interfaces[i])) {
                    interfaceName = "\\" + interfaceName;
                }
                if (i + 1 < data.interfaces.length) {
                    interfaceName = String.valueOf(interfaceName) + ", ";
                }
                this.set("interface_name", interfaceName);
                this.compile("interfaces_compiled", "interfaces", true);
                ++i;
            }
        }
        this.extract("input", "implements", "implements_compiled");
        this.set("implements", "");
        if (data.interfaces.length > 0) {
            this.compile("implements_compiled", "implements", true);
        }
        this.extract("input", "traits", "traits_compiled");
        this.set("traits", "");
        if (data.traits.length > 0) {
            int i = 0;
            while (i < data.traits.length) {
                interfaceName = data.traits[i].getElementName();
                if (!this.isImported(data, data.traits[i])) {
                    interfaceName = "\\" + interfaceName;
                }
                if (i + 1 < data.traits.length) {
                    interfaceName = String.valueOf(interfaceName) + ", ";
                }
                this.set("trait_name", interfaceName);
                this.compile("traits_compiled", "traits", true);
                ++i;
            }
        }
        this.extract("input", "usetrait", "usetrait_compiled");
        this.set("usetrait", "");
        if (data.traits.length > 0) {
            this.compile("usetrait_compiled", "usetrait", true);
        }
        this.extract("input", "func_params", "func_params_compiled");
        this.extract("input", "func_phpdoc_params", "func_phpdoc_params_compiled");
        this.extract("input", "func_phpdoc", "func_phpdoc_compiled");
        this.extract("input", "functions", "functions_compiled");
        this.set("func_params", "");
        this.set("func_phpdoc", "");
        this.set("functions", "");
        this.set("func_modifier", "");
        this.set("func_static_modifier", "");
        this.set("func_parent_call", "");
        if (data.isGenerateConstructor && !this.containsFunction(data.funcsToAdd, "__construct")) {
            this.generateConstructor(data);
        }
        this.set("todo_text", "");
        if (data.funcsToAdd.length > 0) {
            this.generateInheritedMethods(data, data.funcsToAdd);
            this.set("todo_text", "");
        } else if (data.isGenerateTODOs) {
            this.set("todo_text", "//TODO - Insert your code here");
        }
        if (data.isGenerateDestructor && !this.containsFunction(data.funcsToAdd, "__destruct")) {
            this.generateDestructor(data);
        }
        this.extract("input", "class", "class_compiled");
        this.set("class", "");
        this.set("abstract_var", "");
        this.set("final_var", "");
        if (data.isFinal) {
            this.set("final_var", "final");
        }
        if (data.isAbstract) {
            this.set("abstract_var", "abstract");
        }
        if (data.isGeneratePHPDoc) {
            this.set("default_phpdoc", this.getDefaultPHPDoc());
        }
        this.set("class_name", data.className);
        this.set("element_type", "class");
        this.compile("class_compiled", "class", false);
        this.extract("input", "namespace", "namespace_compiled");
        this.set("namespace", "");
        if (data.namespace != null && !data.namespace.isEmpty()) {
            this.set("namespace_name", data.namespace);
            this.compile("namespace_compiled", "namespace", true);
        }
        this.handleRequires(data);
        this.extract("input", "use", "use_compiled");
        this.set("use", "");
        int i = 0;
        while (i < data.imports.length) {
            this.set("use_full_name", data.imports[i]);
            this.compile("use_compiled", "use", true);
            ++i;
        }
        this.extract("class", "namespace_in_file", "namespace_in_file_compiled");
        this.set("namespace_in_file", "");
        this.extract("class", "use_in_file", "use_in_file_compiled");
        this.set("use_in_file", "");
        if (data.isExistingFile && data.isInFirstBlock) {
            if (data.namespace != null && !data.namespace.isEmpty()) {
                this.set("namespace_name", data.namespace);
                this.compile("namespace_in_file_compiled", "namespace_in_file", true);
            }
            i = 0;
            while (i < data.imports.length) {
                this.set("use_full_name", data.imports[i]);
                this.compile("use_in_file_compiled", "use_in_file", true);
                ++i;
            }
        }
        this.extract("input", "php_content", "php_content_compiled");
        this.compile("php_content_compiled", "php_content", false);
        if (!data.isExistingFile || data.isExistingFile && !data.isInFirstBlock || data.isExistingFile && data.isInFirstBlock && !data.hasFirstBlock) {
            this.compile(this.get("php_content"));
            return this.compile(this.get("input"));
        }
        return this.compile(this.get("class"));
    }

    private void generateInheritedMethods(NewPHPElementData data, IMethod[] methodsToOverride) {
        MethodDeclaration decl = null;
        ISourceModule sourceModule = null;
        int i = 0;
        while (i < methodsToOverride.length) {
            int flags;
            IMethod func;
            block22: {
                func = methodsToOverride[i];
                sourceModule = func.getSourceModule();
                ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                try {
                    decl = PHPModelUtils.getNodeByMethod((ModuleDeclaration)module, (IMethod)func);
                }
                catch (ModelException e) {
                    PHPUiPlugin.log(e);
                    return;
                }
                if (data.isGeneratePHPDoc) {
                    this.set("func_phpdoc_param", "(non-PHPdoc)");
                    String targetTypeName = func.getDeclaringType().getTypeQualifiedName(PHPModelUtils.ENCLOSING_TYPE_SEPARATOR);
                    if (targetTypeName.indexOf(PHPModelUtils.ENCLOSING_TYPE_SEPARATOR) > 0) {
                        targetTypeName = String.valueOf(PHPModelUtils.ENCLOSING_TYPE_SEPARATOR) + targetTypeName;
                    }
                    this.set("func_phpdoc_see", "* @see " + targetTypeName + "::" + func.getElementName() + "()\n");
                    this.compile("func_phpdoc_params_compiled", "func_phpdoc_params", false);
                    this.compile("func_phpdoc_compiled", "func_phpdoc", false);
                }
                List paramsList = decl.getArguments();
                FormalParameter[] params = paramsList.toArray(new FormalParameter[paramsList.size()]);
                this.set("func_param_name", "");
                this.compile("func_params_compiled", "func_params", false);
                int k = 0;
                while (k < params.length) {
                    SimpleReference referenceType = null;
                    if (params[k].getParameterType() != null) {
                        referenceType = params[k].getParameterType();
                    }
                    String argType = null;
                    if (referenceType != null) {
                        argType = referenceType.getName();
                        boolean isExcluded = false;
                        String[] stringArray = EXCLUDE_PARAM_TYPES_LIST;
                        int n = EXCLUDE_PARAM_TYPES_LIST.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String comparedType = stringArray[n2];
                            if (comparedType.equalsIgnoreCase(argType)) {
                                isExcluded = true;
                                break;
                            }
                            ++n2;
                        }
                        argType = isExcluded ? "" : String.valueOf(argType) + " ";
                    } else {
                        argType = "";
                    }
                    String funcParam = String.valueOf(argType) + params[k].getName();
                    ASTNode node = params[k].getInitialization();
                    String sourceCode = null;
                    try {
                        String defaultValue = null;
                        if (node != null && (sourceCode = sourceModule.getSource()) != null) {
                            defaultValue = sourceCode.substring(node.sourceStart(), node.sourceEnd());
                        }
                        if (defaultValue != null && !defaultValue.equals("")) {
                            funcParam = String.valueOf(funcParam) + " = " + defaultValue;
                        }
                        if (k + 1 < params.length) {
                            funcParam = String.valueOf(funcParam) + ",";
                        }
                        this.set("func_param_name", funcParam);
                        this.compile("func_params_compiled", "func_params", true);
                    }
                    catch (ModelException e) {
                        Logger.logException(e);
                    }
                    ++k;
                }
                if (data.isGenerateTODOs) {
                    this.set("todo_text", "//TODO - Insert your code here");
                } else {
                    this.set("todo_text", "");
                }
                this.set("func_parent_call", "");
                flags = 0;
                try {
                    flags = func.getFlags();
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block22;
                    e.printStackTrace();
                }
            }
            String funcModifier = this.getVisibilityModifier(flags);
            this.set("func_modifier", funcModifier);
            if (this.isStaticFunction(func.getElementType())) {
                this.set("func_static_modifier", "static");
            } else {
                this.set("func_static_modifier", "");
            }
            this.set("func_name", func.getElementName());
            this.compile("functions_compiled", "functions", true);
            ++i;
        }
    }

    private void generateConstructor(NewPHPElementData data) {
        String funcParam;
        MethodDeclaration decl;
        IMethod func;
        block32: {
            func = null;
            if (data.superClass != null) {
                IMethod[] methods = null;
                try {
                    methods = data.superClass.getMethods();
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
                if (methods != null) {
                    IMethod[] iMethodArray = methods;
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod m = iMethodArray[n2];
                        String elName = m.getElementName();
                        if (elName.equalsIgnoreCase(data.superClass.getElementName()) || elName.equalsIgnoreCase("__construct")) {
                            func = m;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            decl = null;
            if (func != null) {
                ISourceModule sourceModule = func.getSourceModule();
                ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                try {
                    decl = PHPModelUtils.getNodeByMethod((ModuleDeclaration)module, func);
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block32;
                    e.printStackTrace();
                }
            }
        }
        if (data.isGeneratePHPDoc) {
            this.set("func_phpdoc_param", "");
            this.set("func_phpdoc_see", "");
            this.compile("func_phpdoc_params_compiled", "func_phpdoc_params", false);
            if (func != null) {
                List paramsList;
                FormalParameter[] params;
                PHPDocBlock docBlock = null;
                if (decl != null && decl instanceof IPHPDocAwareDeclaration) {
                    IPHPDocAwareDeclaration docDecl = (IPHPDocAwareDeclaration)decl;
                    docBlock = docDecl.getPHPDoc();
                }
                if (docBlock != null) {
                    PHPDocTag[] tags;
                    PHPDocTag[] pHPDocTagArray = tags = docBlock.getTags();
                    int elName = tags.length;
                    int n = 0;
                    while (n < elName) {
                        PHPDocTag docTag = pHPDocTagArray[n];
                        String phpdocParamType = docTag.getTagText().getValue();
                        String phpdocParamValue = docTag.getValue();
                        phpdocParamValue = phpdocParamValue.replaceFirst("(\\r\\n?|\\n)$", "");
                        this.set("func_phpdoc_param", String.valueOf(phpdocParamType) + phpdocParamValue);
                        this.compile("func_phpdoc_params_compiled", "func_phpdoc_params", true);
                        ++n;
                    }
                } else if (decl != null && (params = (paramsList = decl.getArguments()).toArray(new FormalParameter[paramsList.size()])) != null) {
                    int k = 0;
                    while (k < params.length) {
                        funcParam = params[k].getName();
                        if (params[k].getParameterType() != null) {
                            funcParam = String.valueOf(params[k].getParameterType().getName()) + " " + funcParam;
                        }
                        this.set("func_phpdoc_param", " @param " + funcParam + "\n");
                        this.compile("func_phpdoc_params_compiled", "func_phpdoc_params", true);
                        ++k;
                    }
                }
            }
            this.compile("func_phpdoc_compiled", "func_phpdoc", false);
        }
        FormalParameter[] params = null;
        if (decl != null) {
            List paramsList = decl.getArguments();
            params = paramsList.toArray(new FormalParameter[paramsList.size()]);
        }
        StringBuilder paramsOverriden = new StringBuilder();
        if (func != null) {
            paramsOverriden.append("parent::__construct(");
        }
        this.set("func_param_name", "");
        this.compile("func_params_compiled", "func_params", false);
        String defaultValue = null;
        if (params != null) {
            int k = 0;
            while (k < params.length) {
                funcParam = params[k].getName();
                ASTNode argumentDefaultValueNode = params[k].getInitialization();
                if (argumentDefaultValueNode instanceof Scalar) {
                    Scalar scalarNode = (Scalar)argumentDefaultValueNode;
                    defaultValue = scalarNode.getValue();
                }
                if (defaultValue != null && !defaultValue.equals("")) {
                    funcParam = String.valueOf(funcParam) + " = " + defaultValue;
                }
                if (k + 1 < params.length) {
                    funcParam = String.valueOf(funcParam) + ",";
                }
                paramsOverriden.append(funcParam);
                if (params[k].getParameterType() != null) {
                    funcParam = String.valueOf(params[k].getParameterType().getName()) + " " + funcParam;
                }
                this.set("func_param_name", funcParam);
                this.compile("func_params_compiled", "func_params", true);
                ++k;
            }
        }
        if (func != null) {
            paramsOverriden.append(");");
        }
        this.set("func_parent_call", paramsOverriden.toString());
        if (data.isGenerateTODOs) {
            this.set("todo_text", "//TODO - Insert your code here");
        } else {
            this.set("todo_text", "");
        }
        String funcModifier = "public";
        String funcName = "__construct";
        if (func != null) {
            int flags;
            block33: {
                flags = 0;
                try {
                    flags = func.getFlags();
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block33;
                    e.printStackTrace();
                }
            }
            funcModifier = this.getVisibilityModifier(flags);
            funcName = func.getElementName();
        }
        this.set("func_modifier", funcModifier);
        this.set("func_name", funcName);
        this.compile("functions_compiled", "functions", true);
    }

    private void generateDestructor(NewPHPElementData data) {
        this.set("func_parent_call", "");
        if (data.isGeneratePHPDoc) {
            this.set("func_phpdoc_param", "");
            this.set("func_phpdoc_see", "");
            this.compile("func_phpdoc_params_compiled", "func_phpdoc_params", false);
            this.compile("func_phpdoc_compiled", "func_phpdoc", false);
        }
        this.set("func_param_name", "");
        this.compile("func_params_compiled", "func_params", false);
        if (data.isGenerateTODOs) {
            this.set("todo_text", "//TODO - Insert your code here");
        } else {
            this.set("todo_text", "");
        }
        this.set("func_modifier", "");
        this.set("func_name", "__destruct");
        this.compile("functions_compiled", "functions", true);
    }

    @Override
    public String getRequiredPHPs() {
        return this.requiredPHPsBlock;
    }

    private boolean containsFunction(IMethod[] funcs, String name) {
        int i = 0;
        while (i < funcs.length) {
            if (funcs[i].getElementName().equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

