/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.core.model.ISystemProfileOperation;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.persistence.RSEEnvelope;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SystemImportConnectionAction
extends SystemBaseAction {
    public SystemImportConnectionAction() {
        super(SystemResources.RESID_IMPORT_CONNECTION_ACTION_LABEL, SystemResources.RESID_IMPORT_CONNECTION_ACTION_TOOLTIP, null);
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.ui.ActionImportConnectionDefinitions");
    }

    public boolean checkObjectType(Object obj) {
        return obj instanceof ISystemProfile || obj instanceof IHost;
    }

    public void run() {
        FileDialog openDialog = new FileDialog(this.shell, 4096);
        String path = openDialog.open();
        if (path != null) {
            File inFile = new File(path);
            if (inFile.exists()) {
                if (inFile.canRead()) {
                    ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                    ISystemProfileManager profileManager = registry.getSystemProfileManager();
                    ISystemProfile profile = profileManager.getDefaultPrivateSystemProfile();
                    IStructuredSelection selection = this.getSelection();
                    if (selection != null && selection.size() > 0) {
                        Object selected = this.getFirstSelection();
                        if (selected instanceof IHost) {
                            profile = ((IHost)selected).getSystemProfile();
                        } else if (selected instanceof ISystemProfile) {
                            profile = (ISystemProfile)selected;
                        }
                    }
                    ImportJob importJob = new ImportJob(inFile, profile);
                    importJob.schedule();
                } else {
                    String title = SystemResources.SystemImportConnectionAction_Error;
                    String message = MessageFormat.format((String)SystemResources.SystemImportConnectionAction_FileNotReadableCondition, (Object[])new String[]{path});
                    MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
                }
            } else {
                String title = SystemResources.SystemImportConnectionAction_Error;
                String message = MessageFormat.format((String)SystemResources.SystemImportConnectionAction_FileNotFoundCondition, (Object[])new String[]{path});
                MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
            }
        }
    }

    private class ImportJob
    extends Job {
        private ISystemProfile profile;
        private File inFile;

        public ImportJob(File inFile, ISystemProfile profile) {
            super(SystemResources.SystemImportConnectionAction_ImportJobName);
            this.profile = null;
            this.inFile = null;
            this.inFile = inFile;
            this.profile = profile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            try {
                FileInputStream in = new FileInputStream(this.inFile);
                status = SystemProfileManager.run((ISystemProfileOperation)new ISystemProfileOperation(this, in, monitor){
                    final /* synthetic */ ImportJob this$1;
                    private final /* synthetic */ FileInputStream val$in;
                    private final /* synthetic */ IProgressMonitor val$monitor;
                    {
                        this.this$1 = importJob;
                        this.val$in = fileInputStream;
                        this.val$monitor = iProgressMonitor;
                    }

                    public IStatus run() {
                        IStatus operationStatus = Status.OK_STATUS;
                        try {
                            RSEEnvelope envelope = new RSEEnvelope();
                            envelope.get((InputStream)this.val$in, this.val$monitor);
                            envelope.mergeWith(ImportJob.access$0(this.this$1));
                        }
                        catch (CoreException e) {
                            operationStatus = e.getStatus();
                            String message = operationStatus.getMessage();
                            if (message == null) {
                                message = SystemResources.SystemImportConnectionAction_CoreExceptionFound;
                            }
                            SystemBasePlugin.logError(message, e);
                        }
                        return operationStatus;
                    }
                });
            }
            catch (FileNotFoundException e) {
                SystemBasePlugin.logError(SystemResources.SystemImportConnectionAction_UnexpectedException, e);
            }
            return status;
        }

        static /* synthetic */ ISystemProfile access$0(ImportJob importJob) {
            return importJob.profile;
        }
    }
}

