/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import java.awt.GradientPaint;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.util.GraphicsUtilities;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusGraphicsToGraphics2DAdaptor;
import org.eclipse.sirius.ext.draw2d.figure.ViewGradientFigureDesc;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Pattern;

public final class GradientHelper {
    private GradientHelper() {
    }

    public static void setColorsGradation(Graphics graphics, ViewGradientFigureDesc figure) {
        Rectangle zoomedBounds = GraphicsUtilities.zoomFillRectangle(graphics, figure.getBounds());
        if (zoomedBounds != null) {
            SWTGraphics swtGraphics = GraphicsUtilities.getSWTGraphics(graphics);
            if (swtGraphics != null) {
                Pattern pattern = GradientHelper.getGradientPattern(figure.getBackgroundStyle(), zoomedBounds, figure.getBackgroundColor(), figure.getGradientColor());
                swtGraphics.setBackgroundPattern(pattern);
            } else {
                SiriusGraphicsToGraphics2DAdaptor siriusGraphics2DAdaptor = GraphicsUtilities.getSiriusGraphicsToGraphics2DAdaptor(graphics);
                if (siriusGraphics2DAdaptor != null) {
                    siriusGraphics2DAdaptor.setBackgroundPattern(figure.getBackgroundStyle(), zoomedBounds, figure.getBackgroundColor(), figure.getGradientColor());
                }
            }
        }
    }

    public static Pattern getGradientPattern(int backgroundStyle, Rectangle bounds, Color backgroundColor, Color gradientColor) {
        return switch (backgroundStyle) {
            case 3 -> GradientHelper.getGradientTopToBottom(bounds, backgroundColor, gradientColor);
            case 1 -> GradientHelper.getGradientDiag(bounds, backgroundColor, gradientColor);
            default -> GradientHelper.getGradientLeftToRight(bounds, backgroundColor, gradientColor);
        };
    }

    public static GradientPaint getGradientPaint(int backgroundStyle, Rectangle bounds, Color backgroundColor, Color gradientColor) {
        return switch (backgroundStyle) {
            case 3 -> GradientHelper.getGradientPaintTopToBottom(bounds, backgroundColor, gradientColor);
            case 1 -> GradientHelper.getGradientPaintDiag(bounds, backgroundColor, gradientColor);
            default -> GradientHelper.getGradientPaintLeftToRight(bounds, backgroundColor, gradientColor);
        };
    }

    public static Pattern getGradientLeftToRight(Rectangle bounds, Color backgroundColor, Color gradientColor) {
        return VisualBindingManager.getDefault().getPatternFromValue(bounds.x, bounds.y, bounds.width, 0, backgroundColor, gradientColor);
    }

    public static Pattern getGradientDiag(Rectangle bounds, Color backgroundColor, Color gradientColor) {
        int gradientZoneHeight;
        int x = bounds.x;
        int y = bounds.y;
        int i = (bounds.width + bounds.height) / 2;
        int gradientZoneWidth = Math.max(bounds.width, i);
        if (gradientZoneWidth != bounds.width) {
            x = bounds.x - (i - bounds.width) / 2;
        }
        if ((gradientZoneHeight = Math.max(bounds.height, i)) != bounds.height) {
            y = bounds.y - (i - bounds.height) / 2;
        }
        return VisualBindingManager.getDefault().getPatternFromValue(x, y, gradientZoneWidth, gradientZoneHeight, backgroundColor, gradientColor);
    }

    public static Pattern getGradientTopToBottom(Rectangle bounds, Color backgroundColor, Color gradientColor) {
        return VisualBindingManager.getDefault().getPatternFromValue(bounds.x, bounds.y, 0, bounds.height, backgroundColor, gradientColor);
    }

    public static GradientPaint getGradientPaintLeftToRight(Rectangle bounds, Color backgroundColor, Color gradientColor) {
        return VisualBindingManager.getDefault().getGradientPaintFromValue(bounds.x, bounds.y, bounds.width, 0, backgroundColor, gradientColor);
    }

    public static GradientPaint getGradientPaintDiag(Rectangle bounds, Color backgroundColor, Color gradientColor) {
        int gradientZoneHeight;
        int x = bounds.x;
        int y = bounds.y;
        int i = (bounds.width + bounds.height) / 2;
        int gradientZoneWidth = Math.max(bounds.width, i);
        if (gradientZoneWidth != bounds.width) {
            x = bounds.x - (i - bounds.width) / 2;
        }
        if ((gradientZoneHeight = Math.max(bounds.height, i)) != bounds.height) {
            y = bounds.y - (i - bounds.height) / 2;
        }
        return VisualBindingManager.getDefault().getGradientPaintFromValue(x, y, gradientZoneWidth, gradientZoneHeight, backgroundColor, gradientColor);
    }

    public static GradientPaint getGradientPaintTopToBottom(Rectangle bounds, Color backgroundColor, Color gradientColor) {
        return VisualBindingManager.getDefault().getGradientPaintFromValue(bounds.x, bounds.y, 0, bounds.height, backgroundColor, gradientColor);
    }
}

