/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.refresh;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.DiagramDialectUIServices;
import org.eclipse.sirius.diagram.ui.internal.refresh.DiagramRefresherHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.part.DDiagramHelper;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RetargetAction;

public class RefreshDiagramAction
extends RetargetAction {
    private ISelection selection;

    public RefreshDiagramAction(String actionID, ImageDescriptor imageDescriptor) {
        super(actionID, DiagramDialectUIServices.REFRESH_DIAGRAM, 1);
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        this.selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        RefreshDiagramAction.refresh(this.selection);
    }

    public static void refresh(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Collection<EditPart> minimizedSelection = RefreshDiagramAction.minimizeSelection(Arrays.asList(structuredSelection.toArray()));
            DDiagram diagram = null;
            if (!minimizedSelection.isEmpty()) {
                diagram = DDiagramHelper.findParentDDiagram((IGraphicalEditPart)Iterables.filter(minimizedSelection, IGraphicalEditPart.class).iterator().next());
            }
            DiagramRefresherHelper.refreshEditParts(diagram, minimizedSelection);
        }
    }

    public void runWithEvent(Event event) {
        super.runWithEvent(event);
        this.run();
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<EditPart> minimizeSelection(List<?> selection) {
        ArrayList<EditPart> result = new ArrayList<EditPart>(selection.size());
        Iterator<?> iterSelection = new ArrayList(selection).iterator();
        while (iterSelection.hasNext()) {
            Object next = iterSelection.next();
            Object obj = next;
            if (obj instanceof EditPart) {
                void editPart;
                EditPart cfr_ignored_0 = (EditPart)obj;
                EditPart cfr_ignored_1 = (EditPart)obj;
                if (RefreshDiagramAction.isNotAChild((EditPart)editPart, selection)) {
                    result.add((EditPart)editPart);
                    continue;
                }
                iterSelection.remove();
                continue;
            }
            iterSelection.remove();
        }
        return result;
    }

    private static boolean isNotAChild(EditPart editPart, Collection<?> selection) {
        boolean result = true;
        Iterator<?> iterEditParts = selection.iterator();
        while (iterEditParts.hasNext() && result) {
            EditPart currentEditPart = (EditPart)iterEditParts.next();
            if (currentEditPart == editPart || !iterEditParts.hasNext()) continue;
            boolean bl = result = !RefreshDiagramAction.isAChild(editPart, (EditPart)iterEditParts.next());
        }
        return result;
    }

    private static boolean isAChild(EditPart mayBeChild, EditPart editPart) {
        boolean res = false;
        if (editPart.getChildren().contains(mayBeChild)) {
            res = true;
        }
        Iterator iterChildren = editPart.getChildren().iterator();
        while (iterChildren.hasNext() && !res) {
            EditPart currentEditPart = (EditPart)iterChildren.next();
            res = RefreshDiagramAction.isAChild(mayBeChild, currentEditPart);
        }
        return res;
    }

    public boolean isEnabled() {
        return true;
    }

    public void dispose() {
        super.dispose();
        this.selection = null;
    }
}

