/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

class InventoryColorDescriptor
extends ImageDescriptor {
    public static final Point ICON_SIZE = new Point(20, 20);
    private static final RGB OUTLINE_COLOR = new RGB(192, 192, 192);
    private RGB rgb;

    InventoryColorDescriptor(RGB colorValue) {
        this.rgb = colorValue;
    }

    public ImageData getImageData() {
        ImageData data = new ImageData(InventoryColorDescriptor.ICON_SIZE.x, InventoryColorDescriptor.ICON_SIZE.y, 1, new PaletteData(new RGB[]{this.rgb, OUTLINE_COLOR}));
        int i = 0;
        while (i < InventoryColorDescriptor.ICON_SIZE.y) {
            data.setPixel(0, i, 1);
            ++i;
        }
        i = 0;
        while (i < InventoryColorDescriptor.ICON_SIZE.y) {
            data.setPixel(InventoryColorDescriptor.ICON_SIZE.x - 1, i, 1);
            ++i;
        }
        i = 0;
        while (i < InventoryColorDescriptor.ICON_SIZE.x) {
            data.setPixel(i, 0, 1);
            ++i;
        }
        i = 0;
        while (i < InventoryColorDescriptor.ICON_SIZE.x) {
            data.setPixel(i, InventoryColorDescriptor.ICON_SIZE.y - 1, 1);
            ++i;
        }
        return data;
    }

    public Image createImage() {
        Display device = Display.getCurrent();
        ImageData data = this.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
        }
        try {
            if (data.transparentPixel >= 0) {
                ImageData maskData = data.getTransparencyMask();
                return new Image((Device)device, data, maskData);
            }
            return new Image((Device)device, data);
        }
        catch (SWTException sWTException) {
            try {
                return new Image((Device)device, DEFAULT_IMAGE_DATA);
            }
            catch (SWTException sWTException2) {
                return null;
            }
        }
    }
}

