/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;

public class MRUList
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    private String prefKey;

    public MRUList(String prefKey) {
        this.prefKey = prefKey;
        this.initData();
    }

    private void initData() {
        IPreferenceStore prefStore = UIPlugin.getDefault().getPreferenceStore();
        String mruList = prefStore.getString(this.prefKey);
        if (mruList != null) {
            StringTokenizer st = new StringTokenizer(mruList, "|");
            while (st.hasMoreTokens()) {
                this.add(st.nextToken());
            }
        }
    }

    public void updateMRUList(List<String> deltaList) {
        for (String id : deltaList) {
            if (this.contains(id)) continue;
            this.add(id);
        }
        IPreferenceStore prefStore = UIPlugin.getDefault().getPreferenceStore();
        int max = prefStore.getInt(String.valueOf(this.prefKey) + ".max");
        if (max == 0) {
            max = 3;
        }
        int length = this.size();
        List<String> newList = this;
        if (length > max) {
            newList = this.subList(length - max, length);
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < newList.size()) {
            String id = newList.get(i);
            if (i > 0) {
                builder.append("|");
            }
            builder.append(id);
            ++i;
        }
        prefStore.setValue(this.prefKey, builder.toString());
    }
}

