/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.markdown.marked;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.markdown.marked.HTMLRenderer;
import org.eclipse.tm4e.markdown.marked.IRenderer;
import org.eclipse.tm4e.markdown.marked.InlineLexer;
import org.eclipse.tm4e.markdown.marked.Options;
import org.eclipse.tm4e.markdown.marked.Token;
import org.eclipse.tm4e.markdown.marked.Tokens;

public class Parser {
    private final Options options;
    private final IRenderer renderer;
    private @Nullable Token token;

    public Parser(@Nullable Options options, @Nullable IRenderer renderer) {
        this.options = options != null ? options : Options.DEFAULTS;
        this.renderer = renderer != null ? renderer : new HTMLRenderer();
    }

    public static IRenderer parse(Tokens src, @Nullable Options options, @Nullable IRenderer renderer) {
        Parser parser = new Parser(options, renderer);
        return parser.parse(src);
    }

    private IRenderer parse(Tokens src) {
        InlineLexer inline = new InlineLexer(src.links, this.options, this.renderer);
        Tokens tokens = src.reverse();
        while (this.next(tokens)) {
            this.tok(inline);
        }
        return this.renderer;
    }

    private boolean next(Tokens tokens) {
        this.token = tokens.pop();
        return this.token != null;
    }

    private void tok(InlineLexer inline) {
        Token token = this.token;
        if (token == null) {
            return;
        }
        switch (token.type) {
            case space: {
                break;
            }
            case hr: {
                this.renderer.hr();
                break;
            }
            case heading: {
                this.renderer.heading(StringUtils.nullToEmpty((String)token.text), token.depth, StringUtils.nullToEmpty((String)token.text));
                break;
            }
            case code: {
                this.renderer.code(StringUtils.nullToEmpty((String)token.text), token.lang, token.escaped);
                break;
            }
            case paragraph: {
                this.renderer.startParagraph();
                inline.output(StringUtils.nullToEmpty((String)token.text));
                this.renderer.endParagraph();
            }
        }
    }
}

