/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.registry.IGrammarSource;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.registry.Registry;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.ITMScope;
import org.eclipse.tm4e.registry.internal.TMScope;

abstract class AbstractGrammarRegistryManager
implements IGrammarRegistryManager {
    protected final GrammarDefinitions pluginDefinitions = new GrammarDefinitions();
    protected final GrammarDefinitions userDefinitions = new GrammarDefinitions();
    protected final Map<IContentType, ContentTypeToScopeBinding> contentTypeToScopeBindings = new HashMap<IContentType, ContentTypeToScopeBinding>();
    protected final Map<String, Collection<String>> injections = new HashMap<String, Collection<String>>();
    private final Registry registry;

    static String getQualifiedScopeName(String scopeName, String pluginId) {
        return scopeName + "@" + pluginId;
    }

    protected AbstractGrammarRegistryManager() {
        this.registry = new Registry(new IRegistryOptions(){

            public @Nullable Collection<String> getInjections(String scopeName) {
                return AbstractGrammarRegistryManager.this.getInjections(scopeName);
            }

            public @Nullable IGrammarSource getGrammarSource(String scopeName) {
                @Nullable IGrammarDefinition definition = AbstractGrammarRegistryManager.this.userDefinitions.getBestForScope(scopeName);
                if (definition == null) {
                    definition = AbstractGrammarRegistryManager.this.pluginDefinitions.getBestForScope(scopeName);
                }
                if (definition == null) {
                    return null;
                }
                final IGrammarDefinition definition_ = definition;
                return new IGrammarSource(){

                    public String getFilePath() {
                        return (String)NullSafetyHelper.defaultIfNull((Object)definition_.getPath(), (Object)"unknown");
                    }

                    public Reader getReader() throws IOException {
                        return new InputStreamReader(definition_.getInputStream());
                    }
                };
            }
        });
    }

    AbstractGrammarRegistryManager(IRegistryOptions options) {
        this.registry = new Registry(options);
    }

    @Override
    public @Nullable IGrammar getGrammarFor(IContentType ... contentTypes) {
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            while (contentType != null) {
                ContentTypeToScopeBinding binding = (ContentTypeToScopeBinding)NullSafetyHelper.castNullable((Object)this.contentTypeToScopeBindings.get(contentType));
                if (binding == null) {
                    contentType = contentType.getBaseType();
                    continue;
                }
                IGrammar grammar = this.getGrammarForScope(binding.scope.getQualifiedName());
                if (grammar != null) {
                    return grammar;
                }
                grammar = this.getGrammarForScope(binding.scope.getName());
                if (grammar == null) continue;
                return grammar;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public @Nullable IGrammar getGrammarForScope(ITMScope scope) {
        return this.getGrammarForScope(scope.getQualifiedName());
    }

    private @Nullable IGrammar getGrammarForScope(String scopeName) {
        IGrammar grammar = this.registry.grammarForScopeName(scopeName);
        if (grammar != null) {
            return grammar;
        }
        return this.registry.loadGrammar(scopeName);
    }

    @Override
    public @Nullable IGrammar getGrammarForFileExtension(String fileExt) {
        String desiredFileExtension;
        String string = desiredFileExtension = fileExt.startsWith(".") ? fileExt.substring(1) : fileExt;
        if (desiredFileExtension.isBlank()) {
            return null;
        }
        block0: for (ContentTypeToScopeBinding binding : this.contentTypeToScopeBindings.values()) {
            String[] stringArray = binding.contentType.getFileSpecs(8);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contentTypeFileExtension = stringArray[n2];
                if (contentTypeFileExtension.equals(desiredFileExtension)) {
                    IGrammar grammar = this.getGrammarForScope(binding.scope.getQualifiedName());
                    if (grammar != null) {
                        return grammar;
                    }
                    grammar = this.getGrammarForScope(binding.scope.getName());
                    if (grammar == null) continue block0;
                    return grammar;
                }
                ++n2;
            }
        }
        return Stream.concat(this.userDefinitions.stream(), this.pluginDefinitions.stream()).map(definition -> {
            IGrammar grammarForScope = this.getGrammarForScope(definition.getScope());
            return grammarForScope != null && grammarForScope.getFileTypes().contains(desiredFileExtension) ? grammarForScope : null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public @Nullable IGrammarDefinition[] getDefinitions() {
        return (IGrammarDefinition[])Stream.concat(this.pluginDefinitions.stream(), this.userDefinitions.stream()).toArray(IGrammarDefinition[]::new);
    }

    @Override
    public @Nullable Collection<String> getInjections(String scopeName) {
        return this.injections.get(scopeName);
    }

    void registerInjection(String scopeName, String injectTo) {
        @Nullable Collection<String> injectionsOfScope = this.getInjections(injectTo);
        if (injectionsOfScope == null) {
            injectionsOfScope = new ArrayList<String>();
            this.injections.put(injectTo, injectionsOfScope);
        }
        injectionsOfScope.add(scopeName);
    }

    @Override
    public @Nullable Collection<IContentType> getContentTypesForScope(ITMScope scope) {
        return this.contentTypeToScopeBindings.values().stream().filter(binding -> scope.equals(binding.scope)).map(binding -> binding.contentType).toList();
    }

    void registerContentTypeToScopeBinding(String pluginId, IContentType contentType, String scopeName) {
        this.contentTypeToScopeBindings.put(contentType, new ContentTypeToScopeBinding(pluginId, contentType, scopeName));
    }

    void registerGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userDefinitions.add(definition);
        } else {
            this.pluginDefinitions.add(definition);
        }
    }

    void unregisterGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userDefinitions.remove(definition);
        } else {
            this.pluginDefinitions.remove(definition);
        }
    }

    static final class ContentTypeToScopeBinding {
        final IContentType contentType;
        final TMScope scope;

        ContentTypeToScopeBinding(String pluginId, IContentType contentType, String scopeName) {
            this.contentType = contentType;
            this.scope = new TMScope(scopeName, pluginId);
        }

        public String toString() {
            return "ContentTypeToScopeBinding [contentType=" + String.valueOf(this.contentType) + ", scope=" + String.valueOf(this.scope) + "]";
        }
    }

    static final class GrammarDefinitions {
        final Map<String, @Nullable IGrammarDefinition> byQualifiedScopeName = new HashMap<String, IGrammarDefinition>();
        final Map<String, List<IGrammarDefinition>> byUnqualifiedScopeName = new HashMap<String, List<IGrammarDefinition>>();

        GrammarDefinitions() {
        }

        void add(IGrammarDefinition definition) {
            ITMScope scope = definition.getScope();
            if (scope.isQualified()) {
                this.byQualifiedScopeName.put(scope.getQualifiedName(), definition);
            }
            this.byUnqualifiedScopeName.computeIfAbsent(scope.getName(), unused -> new ArrayList()).add(definition);
        }

        @Nullable IGrammarDefinition getBestForScope(String scopeName) {
            IGrammarDefinition definition = this.byQualifiedScopeName.get(scopeName);
            if (definition != null) {
                return definition;
            }
            @Nullable List definitionsOfScope = (List)NullSafetyHelper.castNullable(this.byUnqualifiedScopeName.get(scopeName));
            return definitionsOfScope == null ? null : (IGrammarDefinition)definitionsOfScope.get(0);
        }

        void remove(IGrammarDefinition definition) {
            List definitionsOfScope;
            ITMScope scope = definition.getScope();
            if (scope.isQualified()) {
                this.byQualifiedScopeName.remove(scope.getQualifiedName());
            }
            if ((definitionsOfScope = (List)NullSafetyHelper.castNullable(this.byUnqualifiedScopeName.get(scope.getName()))) != null) {
                definitionsOfScope.remove(definition);
                if (definitionsOfScope.isEmpty()) {
                    this.byUnqualifiedScopeName.remove(scope.getName());
                }
            }
        }

        Stream<IGrammarDefinition> stream() {
            return this.byUnqualifiedScopeName.values().stream().flatMap(Collection::stream);
        }
    }
}

