/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.parser;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskGroup;
import org.eclipse.ui.internal.cheatsheets.composite.parser.IStatusContainer;
import org.eclipse.ui.internal.cheatsheets.composite.parser.ITaskParseStrategy;
import org.eclipse.ui.internal.cheatsheets.composite.parser.MarkupParser;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParserException;
import org.eclipse.ui.internal.cheatsheets.data.ParserStatusUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompositeCheatSheetParser
implements IStatusContainer {
    private IStatus status;
    private int nextTaskId = 0;

    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public void addStatus(int severity, String message, Throwable exception) {
        this.status = ParserStatusUtility.addStatus(this.status, severity, message, exception);
    }

    /*
     * Exception decompiling
     */
    public CompositeCheatSheetModel parseGuide(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompositeCheatSheetModel parseCompositeCheatSheet(Document document, URL url) {
        this.status = Status.OK_STATUS;
        try {
            if (document != null) {
                Element rootnode = document.getDocumentElement();
                if (!rootnode.getNodeName().equals("compositeCheatsheet")) {
                    String message = NLS.bind((String)Messages.ERROR_PARSING_ROOT_NODE_TYPE, (Object[])new Object[]{"compositeCheatsheet"});
                    throw new CheatSheetParserException(message);
                }
                String name = "";
                boolean nameFound = false;
                String explorerId = "tree";
                NamedNodeMap attributes = rootnode.getAttributes();
                if (attributes != null) {
                    int x = 0;
                    while (x < attributes.getLength()) {
                        Node attribute = attributes.item(x);
                        String attributeName = attribute.getNodeName();
                        if (attributeName != null && attributeName.equals("name")) {
                            nameFound = true;
                            name = attribute.getNodeValue();
                        }
                        if (attributeName.equals("explorer")) {
                            explorerId = attribute.getNodeValue();
                        }
                        ++x;
                    }
                }
                CompositeCheatSheetModel compositeCS = new CompositeCheatSheetModel(name, name, explorerId);
                this.parseCompositeCheatSheetChildren(rootnode, compositeCS);
                compositeCS.getDependencies().resolveDependencies(this);
                if (compositeCS.getRootTask() == null) {
                    this.addStatus(4, Messages.ERROR_PARSING_NO_ROOT, null);
                }
                if (!nameFound) {
                    this.addStatus(4, Messages.ERROR_PARSING_CCS_NO_NAME, null);
                }
                if (this.status.getSeverity() != 4) {
                    compositeCS.setContentUrl(url);
                    return compositeCS;
                }
            }
            return null;
        }
        catch (CheatSheetParserException e) {
            this.addStatus(4, e.getMessage(), null);
            return null;
        }
    }

    private void parseCompositeCheatSheetChildren(Node compositeCSNode, CompositeCheatSheetModel model) {
        this.nextTaskId = 0;
        NodeList childNodes = compositeCSNode.getChildNodes();
        int index = 0;
        while (index < childNodes.getLength()) {
            Node nextNode = childNodes.item(index);
            if (CompositeCheatSheetParser.isAbstractTask(nextNode.getNodeName())) {
                AbstractTask task = this.parseAbstractTask(nextNode, model);
                if (model.getRootTask() == null) {
                    model.setRootTask(task);
                    this.parseTaskChildren(nextNode, task, model);
                } else {
                    this.addStatus(4, Messages.ERROR_PARSING_MULTIPLE_ROOT, null);
                }
            }
            ++index;
        }
    }

    public static boolean isAbstractTask(String nodeName) {
        return nodeName == "task" || nodeName == "taskGroup";
    }

    private void parseTaskChildren(Node parentNode, AbstractTask parentTask, CompositeCheatSheetModel model) {
        NodeList childNodes = parentNode.getChildNodes();
        ITaskParseStrategy strategy = parentTask.getParserStrategy();
        strategy.init();
        int index = 0;
        while (index < childNodes.getLength()) {
            Node childNode = childNodes.item(index);
            if (childNode.getNodeType() == 1) {
                String nodeName = childNode.getNodeName();
                if (nodeName == "param") {
                    this.addParameter(parentTask, childNode.getAttributes());
                } else if (nodeName == "intro") {
                    parentTask.setDescription(MarkupParser.parseAndTrimTextMarkup(childNode));
                } else if (nodeName == "onCompletion") {
                    parentTask.setCompletionMessage(MarkupParser.parseAndTrimTextMarkup(childNode));
                } else if (nodeName == "dependsOn") {
                    this.parseDependency(childNode, parentTask, model);
                } else if (CompositeCheatSheetParser.isAbstractTask(nodeName)) {
                    if (parentTask instanceof TaskGroup) {
                        AbstractTask task = this.parseAbstractTask(childNode, model);
                        ((TaskGroup)parentTask).addSubtask(task);
                        this.parseTaskChildren(childNode, task, model);
                    }
                } else if (!strategy.parseElementNode(childNode, parentNode, parentTask, this)) {
                    String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{nodeName, parentNode.getNodeName()});
                    this.addStatus(2, message, null);
                }
            }
            ++index;
        }
        strategy.parsingComplete(parentTask, this);
    }

    private void parseDependency(Node taskNode, AbstractTask task, CompositeCheatSheetModel model) {
        NamedNodeMap attributes = taskNode.getAttributes();
        if (attributes != null) {
            Node taskAttribute = attributes.getNamedItem("task");
            if (taskAttribute != null) {
                String requiredTaskId = taskAttribute.getNodeValue();
                model.getDependencies().addDependency(task, requiredTaskId);
            } else {
                this.addStatus(4, Messages.ERROR_PARSING_NO_ID, null);
            }
        }
    }

    private void addParameter(AbstractTask parentTask, NamedNodeMap attributes) {
        String name = null;
        String value = null;
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("name")) {
                        name = attribute.getNodeValue();
                    }
                    if (attributeName.equals("value")) {
                        value = attribute.getNodeValue();
                    }
                }
                ++x;
            }
        }
        if (name == null) {
            this.addStatus(2, Messages.ERROR_PARSING_NO_NAME, null);
            return;
        }
        if (value == null) {
            this.addStatus(2, Messages.ERROR_PARSING_NO_VALUE, null);
            return;
        }
        parentTask.getParameters().put(name, value);
    }

    private AbstractTask parseAbstractTask(Node taskNode, CompositeCheatSheetModel model) {
        String message;
        NamedNodeMap attributes = taskNode.getAttributes();
        String kind = null;
        String name = null;
        String id = null;
        boolean skippable = false;
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("kind")) {
                        kind = attribute.getNodeValue();
                    }
                    if (attributeName.equals("name")) {
                        name = attribute.getNodeValue();
                    }
                    if (attributeName.equals("id")) {
                        id = attribute.getNodeValue();
                    }
                    if (attributeName.equals("skip")) {
                        skippable = "true".equalsIgnoreCase(attribute.getNodeValue());
                    }
                }
                ++x;
            }
        }
        String nodeName = taskNode.getNodeName();
        if (id == null) {
            id = this.autoGenerateId();
        }
        if (name == null) {
            message = NLS.bind((String)Messages.ERROR_PARSING_TASK_NO_NAME, (Object[])new Object[]{nodeName});
            this.addStatus(4, message, null);
        }
        AbstractTask task = this.createTask(nodeName, model, kind, id, name);
        task.setSkippable(skippable);
        if (model.getDependencies().getTask(id) != null) {
            message = NLS.bind((String)Messages.ERROR_PARSING_DUPLICATE_TASK_ID, (Object[])new Object[]{id});
            this.addStatus(4, message, null);
        } else {
            model.getDependencies().saveId(task);
        }
        return task;
    }

    private AbstractTask createTask(String nodeKind, CompositeCheatSheetModel model, String kind, String id, String name) {
        AbstractTask task = "taskGroup".equals(nodeKind) ? new TaskGroup(model, id, name, kind) : new EditableTask(model, id, name, kind);
        task.setCompletionMessage(Messages.COMPLETED_TASK);
        return task;
    }

    private String autoGenerateId() {
        return "TaskId_" + this.nextTaskId++;
    }
}

