/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.model.WorkbenchMarker;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

class MarkerEntry
extends MarkerSupportItem
implements IAdaptable {
    private static final String LOCATION_STRING = "LOCATION_STRING";
    private static final Object CACHED_NULL;
    private MarkerCategory category;
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private static Map<String, CollationKey> collationCache;
    private boolean stale;
    private long creationTime;
    private String markerType;
    private String markerTypeName;
    private final IMarker marker;

    static {
        Platform.getAdapterManager().registerAdapters(new IAdapterFactory(){

            public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
                if (adapterType == IMarker.class && adaptableObject instanceof MarkerEntry) {
                    return adapterType.cast(((MarkerEntry)adaptableObject).getMarker());
                }
                return null;
            }

            public Class<?>[] getAdapterList() {
                return new Class[]{IMarker.class};
            }
        }, MarkerEntry.class);
        CACHED_NULL = new Object();
        collationCache = new ConcurrentHashMap<String, CollationKey>();
    }

    public MarkerEntry(IMarker marker) {
        this.marker = marker;
        this.stale = false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IMarker.class)) {
            return adapter.cast(this.marker);
        }
        if (adapter.equals(IWorkbenchAdapter.class)) {
            return adapter.cast(new WorkbenchMarker(){

                @Override
                public Object getParent(Object o) {
                    return super.getParent(MarkerEntry.this.marker);
                }

                @Override
                public String getLabel(Object o) {
                    return MarkerEntry.this.getMarkerTypeName();
                }

                @Override
                public ImageDescriptor getImageDescriptor(Object object) {
                    return super.getImageDescriptor(MarkerEntry.this.marker);
                }
            });
        }
        return null;
    }

    @Override
    public boolean getAttributeValue(String attribute, boolean defaultValue) {
        Object value = this.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    @Override
    public int getAttributeValue(String attribute, int defaultValue) {
        Object value = this.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value;
    }

    Object getAttributeValue(String attribute) {
        Object value = this.getCachedValueOrCompute(attribute, () -> {
            Object v;
            if (this.stale) {
                return null;
            }
            try {
                v = this.marker.getAttribute(attribute);
            }
            catch (CoreException e) {
                this.checkIfMarkerStale();
                v = null;
            }
            return v;
        });
        return value;
    }

    @Override
    public String getAttributeValue(String attribute, String defaultValue) {
        Object value = this.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    MarkerCategory getCategory() {
        return this.category;
    }

    @Override
    MarkerSupportItem[] getChildren() {
        return MarkerSupportInternalUtilities.EMPTY_MARKER_ITEM_ARRAY;
    }

    CollationKey getCollationKey(String attribute, String defaultValue) {
        String attributeValue = this.getAttributeValue(attribute, defaultValue);
        if (attributeValue.isEmpty()) {
            return MarkerSupportInternalUtilities.EMPTY_COLLATION_KEY;
        }
        CollationKey key = collationCache.computeIfAbsent(attributeValue, k -> Collator.getInstance().getCollationKey(attributeValue));
        return key;
    }

    @Override
    long getCreationTime() {
        if (this.creationTime != 0L) {
            return this.creationTime;
        }
        if (this.stale) {
            this.creationTime = -1L;
            return this.creationTime;
        }
        try {
            this.creationTime = this.marker.getCreationTime();
            return this.creationTime;
        }
        catch (CoreException e) {
            this.checkIfMarkerStale();
            Policy.handle(e);
            this.creationTime = -1L;
            return this.creationTime;
        }
    }

    @Override
    String getDescription() {
        return this.getAttributeValue("message", MarkerSupportInternalUtilities.UNKNOWN_ATRRIBTE_VALUE_STRING);
    }

    @Override
    long getID() {
        return this.marker.getId();
    }

    @Override
    public String getLocation() {
        Object value = this.getCachedValueOrCompute(LOCATION_STRING, () -> {
            String locationString = this.getAttributeValue("location", "");
            if (locationString.length() > 0) {
                return locationString;
            }
            int lineNumber = this.getAttributeValue("lineNumber", -1);
            String lineNumberString = lineNumber < 0 ? MarkerMessages.Unknown : NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(lineNumber));
            return lineNumberString;
        });
        return (String)value;
    }

    @Override
    public IMarker getMarker() {
        return this.marker;
    }

    @Override
    String getMarkerTypeName() {
        if (this.markerTypeName != null) {
            return this.markerTypeName;
        }
        if (this.stale) {
            this.markerTypeName = NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
            return this.markerTypeName;
        }
        try {
            this.markerTypeName = MarkerTypesModel.getInstance().getType(this.marker.getType()).getLabel();
            return this.markerTypeName;
        }
        catch (CoreException e) {
            this.checkIfMarkerStale();
            Policy.handle(e);
            this.markerTypeName = NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
            return this.markerTypeName;
        }
    }

    String getMarkerTypeId() {
        if (this.markerType != null) {
            return this.markerType;
        }
        if (this.stale) {
            this.markerType = NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
            return this.markerType;
        }
        try {
            this.markerType = this.marker.getType();
            return this.markerType;
        }
        catch (CoreException e) {
            this.checkIfMarkerStale();
            Policy.handle(e);
            this.markerType = NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
            return this.markerType;
        }
    }

    @Override
    MarkerSupportItem getParent() {
        return this.category;
    }

    @Override
    public String getPath() {
        Object value = this.getCachedValueOrCompute("org.eclipse.ui.views.markers.path", () -> {
            if (this.stale || this.checkIfMarkerStale()) {
                return MarkerSupportInternalUtilities.UNKNOWN_ATRRIBTE_VALUE_STRING;
            }
            return this.getPath(this.marker.getResource());
        });
        return (String)value;
    }

    protected String getPath(IResource resource) {
        IPath path = resource.getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return super.getPath();
        }
        String folder = path.removeLastSegments(1).removeTrailingSeparator().toString();
        return folder;
    }

    @Override
    boolean isConcrete() {
        return true;
    }

    void setCategory(MarkerCategory markerCategory) {
        this.category = markerCategory;
    }

    protected Object getCachedValueOrCompute(String key, Supplier<Object> supplier) {
        Object cached = this.cache.computeIfAbsent(key, k -> {
            Object value = supplier.get();
            Object toCache = value != null ? value : CACHED_NULL;
            return toCache;
        });
        Object value = cached == CACHED_NULL ? null : cached;
        return value;
    }

    @Override
    void clearCache() {
        this.cache.clear();
    }

    static void clearCollationCache() {
        collationCache = new ConcurrentHashMap<String, CollationKey>();
    }

    boolean checkIfMarkerStale() {
        if (this.stale) {
            return true;
        }
        if (this.marker == null || !this.marker.exists()) {
            this.stale = true;
        }
        return this.stale;
    }

    boolean getStaleState() {
        return this.stale;
    }

    public int hashCode() {
        return Objects.hashCode(this.marker);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MarkerEntry)) {
            return false;
        }
        MarkerEntry other = (MarkerEntry)obj;
        return Objects.equals(this.marker, other.marker);
    }
}

