/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class WorkbenchViewerSetup {
    static Map<DisposeListener, ColumnViewer> registeredViewers = new ConcurrentHashMap<DisposeListener, ColumnViewer>();
    static final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!"largeViewLimit".equals(event.getProperty())) {
                return;
            }
            int itemsLimit = WorkbenchViewerSetup.getItemsLimit();
            registeredViewers.values().forEach(v -> {
                v.setDisplayIncrementally(itemsLimit);
                Object input = v.getInput();
                if (input != null) {
                    v.setInput(null);
                    v.setInput(input);
                } else {
                    v.refresh();
                }
            });
        }
    };

    static {
        WorkbenchViewerSetup.getPreferenceStore().addPropertyChangeListener(propertyChangeListener);
    }

    public static int getItemsLimit() {
        return WorkbenchViewerSetup.getPreferenceStore().getInt("largeViewLimit");
    }

    private static IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public static void setupViewer(ColumnViewer viewer) {
        viewer.setDisplayIncrementally(WorkbenchViewerSetup.getItemsLimit());
        Control control = viewer.getControl();
        if (control != null) {
            control.addDisposeListener((org.eclipse.swt.events.DisposeListener)new DisposeListener(viewer));
        }
    }

    private static class DisposeListener
    implements org.eclipse.swt.events.DisposeListener {
        public DisposeListener(ColumnViewer viewer) {
            registeredViewers.put(this, viewer);
        }

        public void widgetDisposed(DisposeEvent e) {
            registeredViewers.remove(this);
        }
    }
}

