/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.format;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.format.HTMLFormatterFactory;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;
import org.w3c.dom.Node;

public class HTMLFormatProcessorImpl
extends FormatProcessorXML {
    protected String getFileExtension() {
        return "html";
    }

    protected IStructuredFormatter getFormatter(Node node) {
        IStructuredFormatter formatter = HTMLFormatterFactory.getInstance().createFormatter(node, this.getFormatPreferences());
        return formatter;
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        if (this.fFormatPreferences == null) {
            this.fFormatPreferences = new StructuredFormatPreferencesXML();
            Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
            if (preferences != null) {
                this.fFormatPreferences.setLineWidth(preferences.getInt("lineWidth"));
                ((StructuredFormatPreferencesXML)this.fFormatPreferences).setSplitMultiAttrs(preferences.getBoolean("splitMultiAttrs"));
                ((StructuredFormatPreferencesXML)this.fFormatPreferences).setAlignEndBracket(preferences.getBoolean("alignEndBracket"));
                this.fFormatPreferences.setClearAllBlankLines(preferences.getBoolean("clearAllBlankLines"));
                char indentChar = ' ';
                String indentCharPref = preferences.getString("indentationChar");
                if ("tab".equals(indentCharPref)) {
                    indentChar = '\t';
                }
                int indentationWidth = preferences.getInt("indentationSize");
                StringBuffer indent = new StringBuffer();
                int i = 0;
                while (i < indentationWidth) {
                    indent.append(indentChar);
                    ++i;
                }
                this.fFormatPreferences.setIndent(indent.toString());
            }
        }
        return this.fFormatPreferences;
    }
}

