/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.parser.antlr.splitting;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyntacticPredicateFixup {
    public static final Pattern INVALID_ARG_PATTERN = Pattern.compile("^(\\s*rule\\w+)\\(([^;]*\\$rule\\w+\\.p_\\w+[^;]*)\\);$", 8);
    public static final Pattern SINGLE_ARG = Pattern.compile("\\$rule\\w+\\.(p_\\w+)");
    private final String content;

    public SyntacticPredicateFixup(String content) {
        this.content = content;
    }

    public String transform() {
        Matcher m;
        String result = this.content;
        int idx = 0;
        while ((m = INVALID_ARG_PATTERN.matcher(result)).find(idx)) {
            String argumentList = m.group(2);
            idx = m.start();
            String validArguments = this.toValidArguments(argumentList);
            String parameterList = this.toParameterList(argumentList);
            result = m.replaceFirst("$1(" + validArguments + ");");
            result = this.insertParameter(result, parameterList, idx);
        }
        return result;
    }

    private String toValidArguments(String argumentList) {
        Matcher matcher = SINGLE_ARG.matcher(argumentList);
        String result = matcher.replaceAll("$1");
        return result;
    }

    private String toParameterList(String argumentList) {
        Matcher matcher = SINGLE_ARG.matcher(argumentList);
        LinkedHashSet names = Sets.newLinkedHashSet();
        while (matcher.find()) {
            names.add(matcher.group(1));
        }
        StringBuilder result = new StringBuilder("boolean ");
        Joiner.on((String)", boolean ").appendTo(result, (Iterable)names);
        return result.toString();
    }

    private String insertParameter(String result, String parameterList, int idx) {
        String argumentList = parameterList.replaceAll("\\bboolean \\b", "");
        int paramListStart = result.lastIndexOf("() throws ", idx);
        int methodNameStart = result.lastIndexOf("synpred", paramListStart);
        int paramIdx = paramListStart + 1;
        result = String.valueOf(result.substring(0, paramIdx)) + parameterList + result.substring(paramIdx);
        String call = result.substring(methodNameStart, paramIdx);
        int callIdx = result.indexOf(String.valueOf(call) + ")");
        result = String.valueOf(result.substring(0, callIdx + call.length())) + argumentList + result.substring(callIdx + call.length());
        call = call.substring(0, call.length() - "_fragment(".length());
        result = result.replace(String.valueOf(call) + "() {", String.valueOf(call) + "(" + parameterList + ") {");
        result = result.replace(String.valueOf(call) + "()", String.valueOf(call) + "(" + argumentList + ")");
        return result;
    }
}

