/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers;

import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.internal.ZoomManager;

public class ZoomContributionViewItem
extends ContributionItem
implements ZoomListener {
    public static final String FIT_WIDTH = ZoomManager.FIT_WIDTH;
    public static final String FIT_HEIGHT = ZoomManager.FIT_HEIGHT;
    public static final String FIT_ALL = ZoomManager.FIT_ALL;
    private String[] zoomLevels;
    private ZoomManager zoomManager;
    private Combo combo;
    private Menu fMenu;
    private MenuAdapter menuAdapter = new MenuAdapter(){

        public void menuShown(MenuEvent e) {
            ZoomContributionViewItem.this.refresh(true);
        }
    };

    public ZoomContributionViewItem(IZoomableWorkbenchPart part) {
        this.zoomManager = part.getZoomableViewer().getZoomManager();
    }

    public void fill(Menu menu, int index) {
        if (this.fMenu == null || this.fMenu != menu) {
            if (this.fMenu != null) {
                this.fMenu.removeMenuListener((MenuListener)this.menuAdapter);
                this.fMenu = null;
            }
            this.fMenu = menu;
            menu.addMenuListener((MenuListener)this.menuAdapter);
        }
    }

    public void fill(CoolBar parent, int index) {
        CoolItem item = new CoolItem(parent, 4);
        Combo combo = this.createCombo((Composite)parent);
        item.setControl((Control)combo);
    }

    public void fill(ToolBar parent, int index) {
        ToolItem item = new ToolItem(parent, 2, index);
        Combo combo = this.createCombo((Composite)parent);
        item.setControl((Control)combo);
        item.setWidth(combo.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    private Combo createCombo(Composite parent) {
        this.combo = new Combo(parent, 12);
        if (this.zoomLevels == null) {
            this.zoomLevels = this.zoomManager.getZoomLevelsAsText();
        }
        this.combo.setItems(this.zoomLevels);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = ZoomContributionViewItem.this.combo.getSelectionIndex();
                if (selection > 0) {
                    ZoomContributionViewItem.this.doZoom(ZoomContributionViewItem.this.combo.getItem(selection));
                } else {
                    ZoomContributionViewItem.this.doZoom(ZoomContributionViewItem.this.combo.getItem(0));
                }
            }
        });
        this.combo.pack();
        return this.combo;
    }

    private void doZoom(String zoom) {
        if (this.zoomManager != null) {
            this.zoomManager.setZoomAsText(zoom);
        }
    }

    private void refresh(boolean rebuild) {
        if (this.combo != null && !this.combo.isDisposed()) {
            this.refreshCombo(rebuild);
        } else if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.refreshMenu(rebuild);
        }
    }

    private void refreshMenu(boolean rebuild) {
        MenuItem[] items;
        int n;
        this.fMenu.setEnabled(false);
        if (this.zoomManager == null) {
            return;
        }
        if (rebuild) {
            MenuItem[] oldItems;
            this.zoomLevels = this.zoomManager.getZoomLevelsAsText();
            Object[] objectArray = oldItems = this.fMenu.getItems();
            n = oldItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem oldItem = objectArray[n2];
                if (oldItem.getData() == this) {
                    oldItem.dispose();
                }
                ++n2;
            }
            objectArray = this.zoomLevels;
            n = this.zoomLevels.length;
            n2 = 0;
            while (n2 < n) {
                MenuItem zoomLevel = objectArray[n2];
                MenuItem item = new MenuItem(this.fMenu, 16);
                item.setText((String)zoomLevel);
                item.setData((Object)this);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MenuItem source = (MenuItem)e.getSource();
                        ZoomContributionViewItem.this.doZoom(source.getText());
                    }
                });
                ++n2;
            }
        }
        String zoom = this.zoomManager.getZoomAsText();
        MenuItem[] menuItemArray = items = this.fMenu.getItems();
        int n3 = items.length;
        n = 0;
        while (n < n3) {
            MenuItem item = menuItemArray[n];
            if (item.getData() == this) {
                item.setSelection(false);
                if (zoom.equalsIgnoreCase(item.getText())) {
                    item.setSelection(true);
                }
            }
            ++n;
        }
        this.fMenu.setEnabled(true);
    }

    private void refreshCombo(boolean rebuild) {
        String zoom;
        int index;
        this.combo.setEnabled(false);
        if (this.zoomManager == null) {
            return;
        }
        if (rebuild) {
            this.combo.setItems(this.zoomManager.getZoomLevelsAsText());
        }
        if ((index = this.combo.indexOf(zoom = this.zoomManager.getZoomAsText())) > 0) {
            this.combo.select(index);
        }
        this.combo.setEnabled(true);
    }

    public void zoomChanged(double z) {
        this.refresh(false);
    }

    public void dispose() {
        if (this.combo != null) {
            this.combo = null;
        }
        if (this.fMenu != null) {
            this.fMenu = null;
        }
        super.dispose();
    }
}

