/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.INestedContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.GraphItemStyler;
import org.eclipse.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;

public abstract class AbstractStylingModelFactory
implements IStylingGraphModelFactory {
    private AbstractStructuredGraphViewer viewer;
    private int connectionStyle;
    private int nodeStyle;
    private List constraintAdapters = new ArrayList();

    public AbstractStylingModelFactory(AbstractStructuredGraphViewer viewer) {
        this.viewer = viewer;
        this.connectionStyle = 0;
        this.nodeStyle = 0;
        if (viewer instanceof AbstractStructuredGraphViewer) {
            this.constraintAdapters = viewer.getConstraintAdapters();
        }
    }

    public void styleConnection(GraphConnection conn) {
        GraphNode source = conn.getSource();
        GraphNode dest = conn.getDestination();
        LinkedList rightList = this.getConnectionList(source, dest);
        LinkedList leftList = null;
        if (dest != source) {
            leftList = this.getConnectionList(dest, source);
        }
        int size = leftList != null ? leftList.size() + rightList.size() : rightList.size();
        this.adjustCurves(rightList, size);
        if (leftList != null) {
            this.adjustCurves(leftList, size);
        }
    }

    protected void adjustCurves(List connections, int size) {
        int i = 0;
        while (i < connections.size()) {
            GraphConnection conn = (GraphConnection)((Object)connections.get(i));
            int radius = 20;
            if (conn.getSource() == conn.getDestination()) {
                radius = 40;
            } else if (size < 2) {
                radius = 0;
            }
            conn.setCurveDepth((i + 1) * radius);
            ++i;
        }
    }

    private LinkedList getConnectionList(GraphNode source, GraphNode dest) {
        LinkedList<GraphConnection> list = new LinkedList<GraphConnection>();
        for (GraphConnection c : source.getSourceConnections()) {
            if (c.getDestination() != dest) continue;
            list.add(c);
        }
        return list;
    }

    public void styleItem(GraphItem item) {
        GraphItemStyler.styleItem(item, this.getLabelProvider());
        if (item instanceof GraphConnection) {
            this.styleConnection((GraphConnection)item);
        }
    }

    @Override
    public StructuredViewer getViewer() {
        return this.viewer;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.viewer.getLabelProvider();
    }

    @Override
    public IStructuredContentProvider getContentProvider() {
        return (IStructuredContentProvider)this.viewer.getContentProvider();
    }

    @Override
    public GraphConnection createConnection(Graph graph, Object element, Object source, Object dest) {
        IFigure figure;
        if (source == null || dest == null) {
            return null;
        }
        GraphConnection oldConnection = this.viewer.getGraphModelConnection(element);
        GraphNode sn = this.viewer.getGraphModelNode(source);
        GraphNode dn = this.viewer.getGraphModelNode(dest);
        if (oldConnection != null) {
            if (sn != oldConnection.getSource() || dn != oldConnection.getDestination()) {
                this.viewer.removeGraphModelConnection((Object)oldConnection);
            } else {
                this.styleItem(oldConnection);
                return oldConnection;
            }
        }
        IFigureProvider figureProvider = null;
        if (this.getLabelProvider() instanceof IFigureProvider) {
            figureProvider = (IFigureProvider)this.getLabelProvider();
        }
        if (sn == null) {
            figure = null;
            if (figureProvider != null) {
                figure = figureProvider.getFigure(source);
            }
            sn = figure != null ? this.createNode(graph, source, figure) : this.createNode(graph, source);
        }
        if (dn == null) {
            figure = null;
            if (figureProvider != null) {
                figure = figureProvider.getFigure(dest);
            }
            dn = figure != null ? this.createNode(graph, dest, figure) : this.createNode(graph, dest);
        }
        GraphConnection c = this.viewer.addGraphModelConnection(element, sn, dn);
        this.styleItem(c);
        return c;
    }

    public GraphNode createNode(Graph graph, Object element, IFigure figure) {
        boolean isContainer;
        GraphNode node = null;
        if (this.getContentProvider() instanceof INestedContentProvider && (isContainer = ((INestedContentProvider)this.getContentProvider()).hasChildren(element))) {
            node = this.viewer.addGraphModelContainer(element);
            this.styleItem(node);
            Object[] childNodes = ((INestedContentProvider)this.getContentProvider()).getChildren(element);
            childNodes = this.filter(this.getViewer().getInput(), childNodes);
            if (childNodes == null) {
                return node;
            }
            Object[] objectArray = childNodes;
            int n = childNodes.length;
            int n2 = 0;
            while (n2 < n) {
                Object childNode2 = objectArray[n2];
                GraphNode childNode = this.viewer.addGraphModelNode((IContainer)((Object)node), childNode2);
                this.styleItem(childNode);
                ++n2;
            }
            ((IContainer)((Object)node)).applyLayout();
            return node;
        }
        node = this.viewer.addGraphModelNode(element, figure);
        this.styleItem(node);
        return node;
    }

    @Override
    public GraphNode createNode(Graph graph, Object element) {
        IFigure nodeFigure = null;
        if (this.getLabelProvider() instanceof IFigureProvider) {
            nodeFigure = ((IFigureProvider)this.getLabelProvider()).getFigure(element);
        }
        return this.createNode(graph, element, nodeFigure);
    }

    @Override
    public void setConnectionStyle(int style) {
        this.connectionStyle = style;
    }

    @Override
    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    @Override
    public void setNodeStyle(int style) {
        this.nodeStyle = style;
    }

    public List getConstraintAdapters() {
        return this.constraintAdapters;
    }

    @Override
    public int getNodeStyle() {
        return this.nodeStyle;
    }

    @Override
    public void update(GraphItem item) {
        this.styleItem(item);
    }

    @Override
    public void update(GraphItem[] items) {
        GraphItem[] graphItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            GraphItem item = graphItemArray[n2];
            this.styleItem(item);
            ++n2;
        }
    }

    @Override
    public void refreshGraph(Graph graph) {
        HashMap oldMap = this.viewer.getNodesMap();
        HashMap nodesMap = new HashMap();
        for (Object key : oldMap.keySet()) {
            nodesMap.put(key, oldMap.get(key));
        }
        this.clearGraph(graph);
        this.doBuildGraph(graph);
        GraphNode[] nodes = this.getNodesArray(graph);
        if (nodes.length < nodesMap.keySet().size()) {
            GraphNode[] graphNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                GraphNode node = graphNodeArray[n2];
                GraphNode oldNode = (GraphNode)((Object)nodesMap.get(node.getData()));
                if (oldNode != null) {
                    node.setLocation(oldNode.getLocation().x, oldNode.getLocation().y);
                    if (oldNode.isSizeFixed()) {
                        node.setSize(oldNode.getSize().width, oldNode.getSize().height);
                    }
                }
                ++n2;
            }
        } else {
            for (Object key : nodesMap.keySet()) {
                GraphNode node = this.viewer.getGraphModelNode(key);
                if (node == null) continue;
                GraphNode oldNode = (GraphNode)((Object)nodesMap.get(key));
                node.setLocation(oldNode.getLocation().x, oldNode.getLocation().y);
                if (!oldNode.isSizeFixed()) continue;
                node.setSize(oldNode.getSize().width, oldNode.getSize().height);
            }
        }
    }

    public void clearGraph(Graph graph) {
        Object[] connectionElements;
        Object[] nodeElements;
        graph.setSelection(null);
        Object[] objectArray = nodeElements = this.viewer.getNodeElements();
        int n = nodeElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object nodeElement = objectArray[n2];
            this.viewer.removeGraphModelNode(nodeElement);
            ++n2;
        }
        Object[] objectArray2 = connectionElements = this.viewer.getConnectionElements();
        int n3 = connectionElements.length;
        n = 0;
        while (n < n3) {
            Object connectionElement = objectArray2[n];
            this.viewer.removeGraphModelConnection(connectionElement);
            ++n;
        }
    }

    protected void doBuildGraph(Graph model) {
        this.clearGraph(model);
        model.setConnectionStyle(this.getConnectionStyle());
        model.setNodeStyle(this.getNodeStyle());
        model.setConstraintAdapters(this.getConstraintAdapters());
    }

    protected boolean filterElement(Object parent, Object element) {
        ViewerFilter[] filters;
        ViewerFilter[] viewerFilterArray = filters = this.getViewer().getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            boolean selected = filter.select((Viewer)this.viewer, parent, element);
            if (!selected) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Object[] filter(Object parent, Object[] elements) {
        ViewerFilter[] filters;
        Object[] result = elements;
        ViewerFilter[] viewerFilterArray = filters = this.getViewer().getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            result = filter.filter((Viewer)this.viewer, parent, result);
            ++n2;
        }
        return result;
    }

    @Override
    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }

    protected GraphNode[] getNodesArray(Graph graph) {
        GraphNode[] nodesArray = new GraphNode[graph.getNodes().size()];
        nodesArray = graph.getNodes().toArray(nodesArray);
        return nodesArray;
    }

    protected GraphConnection[] getConnectionArray(Graph graph) {
        GraphConnection[] connectionArray = new GraphConnection[graph.getConnections().size()];
        connectionArray = graph.getConnections().toArray(connectionArray);
        return connectionArray;
    }
}

