/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IEntityConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IEntityStyleProvider;
import org.eclipse.zest.core.viewers.ISelfStyleProvider;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.ZestStyles;

public class GraphItemStyler {
    /*
     * WARNING - void declaration
     */
    public static void styleItem(GraphItem item, IBaseLabelProvider labelProvider) {
        GraphItem graphItem = item;
        if (graphItem instanceof GraphNode) {
            IBaseLabelProvider iBaseLabelProvider;
            IBaseLabelProvider iBaseLabelProvider2;
            void node;
            GraphNode graphNode = (GraphNode)graphItem;
            GraphNode cfr_ignored_0 = (GraphNode)graphItem;
            if (node.getGraphModel().getNodeStyle() != 0) {
                node.setNodeStyle(node.getGraphModel().getNodeStyle());
            } else {
                node.setNodeStyle(0);
            }
            Object entity = node.getData();
            if (labelProvider instanceof IEntityStyleProvider) {
                GraphItemStyler.styleNode((GraphNode)node, (IEntityStyleProvider)labelProvider);
            }
            if ((iBaseLabelProvider2 = labelProvider) instanceof IColorProvider) {
                void colorProvider;
                IColorProvider iColorProvider = (IColorProvider)iBaseLabelProvider2;
                IColorProvider cfr_ignored_1 = (IColorProvider)iBaseLabelProvider2;
                node.setForegroundColor(colorProvider.getForeground(entity));
                node.setBackgroundColor(colorProvider.getBackground(entity));
            }
            if ((iBaseLabelProvider = labelProvider) instanceof IFontProvider) {
                void fontProvider;
                IFontProvider iFontProvider = (IFontProvider)iBaseLabelProvider;
                IFontProvider cfr_ignored_2 = (IFontProvider)iBaseLabelProvider;
                node.setFont(fontProvider.getFont(entity));
            }
            if (labelProvider instanceof ILabelProvider) {
                String text = ((ILabelProvider)labelProvider).getText(node.getData());
                node.setText(text != null ? text : "");
                node.setImage(((ILabelProvider)labelProvider).getImage(node.getData()));
            }
            if (labelProvider instanceof ISelfStyleProvider) {
                ((ISelfStyleProvider)labelProvider).selfStyleNode(entity, (GraphNode)node);
            }
        } else {
            GraphItem graphItem2 = item;
            if (graphItem2 instanceof GraphConnection) {
                void conn;
                GraphConnection entity = (GraphConnection)graphItem2;
                GraphConnection cfr_ignored_3 = (GraphConnection)graphItem2;
                if (conn.getGraphModel().getConnectionStyle() != 0) {
                    int s = conn.getGraphModel().getConnectionStyle();
                    conn.setConnectionStyle(s);
                } else {
                    conn.setConnectionStyle(0);
                }
                if (labelProvider instanceof ILabelProvider) {
                    String text = ((ILabelProvider)labelProvider).getText(conn.getExternalConnection());
                    conn.setText(text != null ? text : "");
                    conn.setImage(((ILabelProvider)labelProvider).getImage(conn.getExternalConnection()));
                }
                if (labelProvider instanceof IEntityConnectionStyleProvider) {
                    GraphItemStyler.styleEntityConnection((GraphConnection)conn, (IEntityConnectionStyleProvider)labelProvider);
                } else if (labelProvider instanceof IConnectionStyleProvider) {
                    GraphItemStyler.styleConnection((GraphConnection)conn, (IConnectionStyleProvider)labelProvider);
                }
                int swt = GraphItemStyler.getLineStyleForZestStyle(conn.getConnectionStyle());
                conn.setLineStyle(swt);
                if (labelProvider instanceof ISelfStyleProvider) {
                    ((ISelfStyleProvider)labelProvider).selfStyleConnection(conn.getData(), (GraphConnection)conn);
                }
            }
        }
    }

    private static void styleConnection(GraphConnection conn, IConnectionStyleProvider provider) {
        IFigure tooltip;
        Color c;
        Object rel = conn.getExternalConnection();
        int style = provider.getConnectionStyle(rel);
        if (!ZestStyles.validateConnectionStyle(style)) {
            throw new SWTError(5);
        }
        if (style != 0) {
            conn.setConnectionStyle(style);
        }
        if ((c = provider.getHighlightColor(rel)) != null) {
            conn.setHighlightColor(c);
        }
        if ((c = provider.getColor(rel)) != null) {
            conn.setLineColor(c);
        }
        if ((tooltip = provider.getTooltip(rel)) != null) {
            conn.setTooltip(tooltip);
        }
        int w = -1;
        w = provider.getLineWidth(rel);
        if (w >= 0) {
            conn.setLineWidth(w);
        }
    }

    private static void styleEntityConnection(GraphConnection conn, IEntityConnectionStyleProvider provider) {
        Color c;
        Object dest;
        Object src = conn.getSource().getData();
        int style = provider.getConnectionStyle(src, dest = conn.getDestination().getData());
        if (!ZestStyles.validateConnectionStyle(style)) {
            throw new SWTError(5);
        }
        if (style != 0) {
            conn.setConnectionStyle(style);
        }
        if ((c = provider.getColor(src, dest)) != null) {
            conn.setLineColor(c);
        }
        if ((c = provider.getHighlightColor(src, dest)) != null) {
            conn.setHighlightColor(c);
        }
        int w = -1;
        w = provider.getLineWidth(src, dest);
        if (w >= 0) {
            conn.setLineWidth(w);
        }
    }

    private static void styleNode(GraphNode node, IEntityStyleProvider provider) {
        IFigure figure;
        Color c;
        Object entity = node.getData();
        int width = -1;
        if (provider.fisheyeNode(entity)) {
            node.setNodeStyle(node.getNodeStyle() | 4);
        }
        if ((c = provider.getBorderColor(entity)) != null) {
            node.setBorderColor(c);
        }
        if ((c = provider.getBorderHighlightColor(entity)) != null) {
            node.setBorderHighlightColor(c);
        }
        if ((c = provider.getNodeHighlightColor(entity)) != null) {
            node.setHighlightColor(c);
        }
        if ((c = provider.getBackgroundColour(entity)) != null) {
            node.setBackgroundColor(c);
        }
        if ((c = provider.getForegroundColour(entity)) != null) {
            node.setForegroundColor(c);
        }
        if ((width = provider.getBorderWidth(entity)) >= 0) {
            node.setBorderWidth(width);
        }
        if ((figure = provider.getTooltip(entity)) != null) {
            node.setTooltip(figure);
        }
    }

    public static int getLineStyleForZestStyle(int style) {
        int lineStyles = 60;
        if ((style &= lineStyles) == 0) {
            style = 4;
        }
        switch (style) {
            case 32: {
                return 4;
            }
            case 8: {
                return 2;
            }
            case 16: {
                return 3;
            }
        }
        return 1;
    }
}

