/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.client.impl;

import com.google.gwt.core.client.JsArray;
import com.google.gwt.requestfactory.client.impl.AbstractRequestContext;
import com.google.gwt.requestfactory.client.impl.EntityCodex;
import com.google.gwt.requestfactory.client.impl.SimpleEntityProxyId;
import com.google.gwt.requestfactory.client.impl.messages.JsonResults;
import com.google.gwt.requestfactory.client.impl.messages.JsonServerException;
import com.google.gwt.requestfactory.client.impl.messages.RelatedObjects;
import com.google.gwt.requestfactory.client.impl.messages.RequestData;
import com.google.gwt.requestfactory.client.impl.messages.ReturnRecord;
import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.EntityProxyId;
import com.google.gwt.requestfactory.shared.InstanceRequest;
import com.google.gwt.requestfactory.shared.Receiver;
import com.google.gwt.requestfactory.shared.Request;
import com.google.gwt.requestfactory.shared.RequestContext;
import com.google.gwt.requestfactory.shared.ServerFailure;
import com.google.gwt.requestfactory.shared.Violation;
import com.google.gwt.requestfactory.shared.WriteOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequest<T>
implements Request<T>,
InstanceRequest<EntityProxy, T> {
    protected final Set<String> propertyRefs = new HashSet<String>();
    protected final AbstractRequestContext requestContext;
    private Receiver<? super T> receiver;
    private RequestData requestData;

    protected AbstractRequest(AbstractRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    public void fire() {
        this.requestContext.fire();
    }

    @Override
    public void fire(Receiver<? super T> receiver) {
        this.to(receiver);
        this.fire();
    }

    public Set<String> getPropertyRefs() {
        return Collections.unmodifiableSet(this.propertyRefs);
    }

    public RequestData getRequestData() {
        if (this.requestData == null) {
            this.requestData = this.makeRequestData();
        }
        return this.requestData;
    }

    public void handleResponseText(String responseText) {
        JsonResults results = JsonResults.fromResults(responseText);
        JsonServerException cause = results.getException();
        if (cause != null) {
            this.fail(new ServerFailure(cause.getMessage(), cause.getType(), cause.getTrace()));
            return;
        }
        JsArray<ReturnRecord> violationsArray = results.getViolations();
        if (violationsArray != null) {
            this.processViolations(violationsArray);
        } else {
            this.requestContext.processSideEffects(results.getSideEffects());
            this.processRelated(results.getRelated());
            if (results.isNullResult()) {
                this.succeed(null);
            } else {
                this.handleResult(results.getResult());
            }
        }
    }

    @Override
    public RequestContext to(Receiver<? super T> receiver) {
        this.receiver = receiver;
        return this.requestContext;
    }

    @Override
    public Request<T> using(EntityProxy instanceObject) {
        this.getRequestData().getParameters()[0] = instanceObject;
        this.requestContext.addInvocation(this);
        return this;
    }

    @Override
    public Request<T> with(String ... propertyRefs) {
        this.propertyRefs.addAll(Arrays.asList(propertyRefs));
        return this;
    }

    protected <Q extends EntityProxy> Q decodeReturnObject(Class<Q> clazz, Object obj) {
        ReturnRecord jso = (ReturnRecord)obj;
        SimpleEntityProxyId<Q> id = this.requestContext.getRequestFactory().getId(clazz, jso.getSimpleId());
        Q proxy = this.requestContext.processReturnRecord(id, (ReturnRecord)obj, WriteOperation.UPDATE);
        return proxy;
    }

    protected <Q extends EntityProxy> void decodeReturnObjectList(Class<Q> elementType, Object obj, Collection<Q> accumulator) {
        JsArray array = (JsArray)obj;
        int j = array.length();
        for (int i = 0; i < j; ++i) {
            ReturnRecord record = (ReturnRecord)array.get(i);
            if (record == null) {
                accumulator.add(null);
                continue;
            }
            Q decoded = this.decodeReturnObject(elementType, record);
            assert (elementType.equals(decoded.stableId().getProxyClass()));
            accumulator.add(decoded);
        }
    }

    protected <Q> void decodeReturnValueList(Class<Q> elementType, Object obj, Collection<Q> accumulator) {
        List temp = (List)EntityCodex.decode(List.class, elementType, this.requestContext, obj);
        accumulator.addAll(temp);
    }

    protected void fail(ServerFailure failure) {
        this.requestContext.reuse();
        if (this.receiver != null) {
            this.receiver.onFailure(failure);
        }
    }

    protected abstract void handleResult(Object var1);

    protected boolean hasReceiver() {
        return this.receiver != null;
    }

    protected abstract RequestData makeRequestData();

    protected void processRelated(RelatedObjects related) {
        for (String token : related.getHistoryTokens()) {
            EntityProxyId id = this.requestContext.getRequestFactory().getProxyId(token);
            this.requestContext.processReturnRecord(id, related.getReturnRecord(token), new WriteOperation[0]);
        }
    }

    protected void succeed(T t) {
        if (this.receiver != null) {
            this.receiver.onSuccess(t);
        }
    }

    private void processViolations(JsArray<ReturnRecord> violationsArray) {
        int length = violationsArray.length();
        HashSet<Violation> errors = new HashSet<Violation>(length);
        for (int i = 0; i < length; ++i) {
            ReturnRecord violationRecord = violationsArray.get(i);
            final SimpleEntityProxyId key = this.requestContext.getRequestFactory().getId(violationRecord.getSchema(), violationRecord.getEncodedId(), violationRecord.getFutureId());
            HashMap<String, String> violations = new HashMap<String, String>();
            assert (violationRecord.hasViolations());
            violationRecord.fillViolations(violations);
            for (Map.Entry<String, String> entry : violations.entrySet()) {
                final String path = entry.getKey();
                final String message = entry.getValue();
                errors.add(new Violation(){

                    @Override
                    public String getMessage() {
                        return message;
                    }

                    @Override
                    public String getPath() {
                        return path;
                    }

                    @Override
                    public EntityProxyId<?> getProxyId() {
                        return key;
                    }
                });
            }
        }
        this.requestContext.reuse();
        this.requestContext.addErrors(errors);
        if (this.receiver != null) {
            this.receiver.onViolation(errors);
        }
    }
}

