/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.protobuf;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.jdbc.gen.CodeGenSupport;
import com.google.gwtorm.jdbc.gen.GeneratedClassLoader;
import com.google.gwtorm.protobuf.ProtobufCodec;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.schema.java.JavaColumnModel;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.WireFormat;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class CodecGen<T>
implements Opcodes {
    private static final Type string = Type.getType(String.class);
    private static final Type byteStringOutput = Type.getType(ByteString.Output.class);
    private static final Type byteString = Type.getType(ByteString.class);
    private static final Type object = Type.getType(Object.class);
    private static final Type codedOutputStream = Type.getType(CodedOutputStream.class);
    private static final Type codedInputStream = Type.getType(CodedInputStream.class);
    private final GeneratedClassLoader classLoader;
    private final Class<T> pojo;
    private final Type pojoType;
    private ClassWriter cw;
    private JavaColumnModel[] myFields;
    private String superTypeName;
    private String implClassName;
    private String implTypeName;

    public CodecGen(GeneratedClassLoader loader, Class<T> t) {
        this.classLoader = loader;
        this.pojo = t;
        this.pojoType = Type.getType(this.pojo);
    }

    public ProtobufCodec<T> create() throws OrmException {
        this.myFields = CodecGen.scanFields(this.pojo);
        this.init();
        this.implementConstructor();
        this.implementSizeof();
        this.implementEncode();
        this.implementDecode();
        this.cw.visitEnd();
        this.classLoader.defineClass(this.implClassName, this.cw.toByteArray());
        try {
            Class<?> c = Class.forName(this.implClassName, true, this.classLoader);
            return CodecGen.cast(c.newInstance());
        }
        catch (InstantiationException e) {
            throw new OrmException("Cannot create new encoder", e);
        }
        catch (IllegalAccessException e) {
            throw new OrmException("Cannot create new encoder", e);
        }
        catch (ClassNotFoundException e) {
            throw new OrmException("Cannot create new encoder", e);
        }
    }

    private static JavaColumnModel[] scanFields(Class<?> in) throws OrmException {
        ArrayList<JavaColumnModel> col = new ArrayList<JavaColumnModel>();
        while (in != null) {
            for (Field f : in.getDeclaredFields()) {
                if (f.getAnnotation(Column.class) == null) continue;
                col.add(new JavaColumnModel(f));
            }
            in = in.getSuperclass();
        }
        return CodecGen.sort(col);
    }

    private static JavaColumnModel[] sort(Collection<? extends ColumnModel> col) {
        JavaColumnModel[] out = col.toArray(new JavaColumnModel[col.size()]);
        Arrays.sort(out, new Comparator<JavaColumnModel>(){

            @Override
            public int compare(JavaColumnModel o1, JavaColumnModel o2) {
                return o1.getColumnID() - o2.getColumnID();
            }
        });
        return out;
    }

    private static <T> ProtobufCodec<T> cast(Object c) {
        return (ProtobufCodec)c;
    }

    private void init() {
        this.superTypeName = Type.getInternalName(ProtobufCodec.class);
        this.implClassName = this.pojo.getName() + "_protobuf_" + Util.createRandomName();
        this.implTypeName = this.implClassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        this.cw.visit(47, 49, this.implTypeName, null, this.superTypeName, new String[0]);
    }

    private void implementConstructor() {
        String consName = "<init>";
        String consDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", consDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.superTypeName, "<init>", consDesc);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementSizeof() throws OrmException {
        MethodVisitor mv = this.cw.visitMethod(1, "sizeof", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{object}), null, new String[0]);
        mv.visitCode();
        SizeofCGS cgs = new SizeofCGS(mv);
        cgs.setEntityType(this.pojoType);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.pojoType.getInternalName());
        mv.visitVarInsn(58, 1);
        cgs.push(0);
        mv.visitVarInsn(54, cgs.sizeVar);
        CodecGen.sizeofMessage(this.myFields, mv, cgs);
        mv.visitVarInsn(21, cgs.sizeVar);
        mv.visitInsn(172);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private static void sizeofMessage(JavaColumnModel[] myFields, MethodVisitor mv, SizeofCGS cgs) throws OrmException {
        for (JavaColumnModel f : myFields) {
            if (f.isNested()) {
                int msgVar;
                Label end = new Label();
                cgs.setFieldReference(f);
                cgs.pushFieldValue();
                mv.visitJumpInsn(198, end);
                int oldVar = cgs.sizeVar;
                cgs.sizeVar = msgVar = cgs.newLocal();
                cgs.push(0);
                mv.visitVarInsn(54, cgs.sizeVar);
                CodecGen.sizeofMessage(CodecGen.sort(f.getNestedColumns()), mv, cgs);
                cgs.sizeVar = oldVar;
                cgs.push(f.getColumnID());
                cgs.inc("computeTagSize", Type.INT_TYPE);
                mv.visitVarInsn(21, msgVar);
                cgs.inc("computeRawVarint32Size", Type.INT_TYPE);
                mv.visitVarInsn(21, msgVar);
                cgs.inc();
                cgs.freeLocal(msgVar);
                mv.visitLabel(end);
                continue;
            }
            CodecGen.sizeofScalar(mv, cgs, f);
        }
    }

    private static void sizeofScalar(MethodVisitor mv, SizeofCGS cgs, JavaColumnModel f) throws OrmException {
        cgs.setFieldReference(f);
        switch (Type.getType(f.getPrimitiveType()).getSort()) {
            case 1: {
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.inc("computeBoolSize", Type.INT_TYPE, Type.BOOLEAN_TYPE);
                break;
            }
            case 2: {
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.inc("computeUInt32Size", Type.INT_TYPE, Type.INT_TYPE);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.inc("computeSInt32Size", Type.INT_TYPE, Type.INT_TYPE);
                break;
            }
            case 6: {
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.inc("computeFloatSize", Type.INT_TYPE, Type.FLOAT_TYPE);
                break;
            }
            case 8: {
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.inc("computeDoubleSize", Type.INT_TYPE, Type.DOUBLE_TYPE);
                break;
            }
            case 7: {
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.inc("computeSInt64", Type.INT_TYPE, Type.LONG_TYPE);
                break;
            }
            case 9: 
            case 10: {
                Label end = new Label();
                cgs.pushFieldValue();
                mv.visitJumpInsn(198, end);
                if (f.getPrimitiveType() == byte[].class) {
                    cgs.push(f.getColumnID());
                    cgs.inc("computeTagSize", Type.INT_TYPE);
                    cgs.pushFieldValue();
                    mv.visitInsn(190);
                    cgs.inc("computeRawVarint32Size", Type.INT_TYPE);
                    cgs.pushFieldValue();
                    mv.visitInsn(190);
                    cgs.inc();
                } else if (f.getPrimitiveType() == String.class) {
                    cgs.push(f.getColumnID());
                    cgs.pushFieldValue();
                    cgs.inc("computeStringSize", Type.INT_TYPE, string);
                } else if (f.getPrimitiveType() == Timestamp.class || f.getPrimitiveType() == java.util.Date.class || f.getPrimitiveType() == Date.class) {
                    cgs.push(f.getColumnID());
                    String tsType = Type.getType(f.getPrimitiveType()).getInternalName();
                    mv.visitMethodInsn(182, tsType, "getTime", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]));
                    cgs.inc("computeFixed64Size", Type.INT_TYPE, Type.LONG_TYPE);
                } else {
                    throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
                }
                mv.visitLabel(end);
                break;
            }
            default: {
                throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
            }
        }
    }

    private void implementEncode() throws OrmException {
        MethodVisitor mv = this.cw.visitMethod(1, "encode", Type.getMethodDescriptor((Type)byteString, (Type[])new Type[]{object}), null, new String[0]);
        mv.visitCode();
        EncodeCGS cgs = new EncodeCGS(mv);
        cgs.setEntityType(this.pojoType);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.pojoType.getInternalName());
        mv.visitVarInsn(58, 1);
        CodecGen.encodeMessage(this.myFields, mv, cgs);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private static void encodeMessage(JavaColumnModel[] myFields, MethodVisitor mv, EncodeCGS cgs) throws OrmException {
        int oldVar = cgs.codedOutputStreamVar;
        cgs.codedOutputStreamVar = cgs.newLocal();
        int strVar = cgs.newLocal();
        mv.visitMethodInsn(184, byteString.getInternalName(), "newOutput", Type.getMethodDescriptor((Type)byteStringOutput, (Type[])new Type[0]));
        mv.visitVarInsn(58, strVar);
        mv.visitVarInsn(25, strVar);
        mv.visitMethodInsn(184, codedOutputStream.getInternalName(), "newInstance", Type.getMethodDescriptor((Type)codedOutputStream, (Type[])new Type[]{Type.getType(OutputStream.class)}));
        mv.visitVarInsn(58, cgs.codedOutputStreamVar);
        for (JavaColumnModel f : myFields) {
            if (f.isNested()) {
                Label end = new Label();
                cgs.setFieldReference(f);
                cgs.pushFieldValue();
                mv.visitJumpInsn(198, end);
                int v = cgs.newLocal();
                CodecGen.encodeMessage(CodecGen.sort(f.getNestedColumns()), mv, cgs);
                mv.visitVarInsn(58, v);
                mv.visitVarInsn(25, v);
                mv.visitMethodInsn(182, byteString.getInternalName(), "size", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]));
                mv.visitJumpInsn(153, end);
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                mv.visitVarInsn(25, v);
                cgs.write("writeBytes", byteString);
                cgs.freeLocal(v);
                mv.visitLabel(end);
                continue;
            }
            CodecGen.encodeScalar(mv, cgs, f);
        }
        cgs.pushCodedOutputStream();
        mv.visitMethodInsn(182, codedOutputStream.getInternalName(), "flush", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        cgs.freeLocal(cgs.codedOutputStreamVar);
        cgs.codedOutputStreamVar = oldVar;
        mv.visitVarInsn(25, strVar);
        mv.visitMethodInsn(182, byteStringOutput.getInternalName(), "toByteString", Type.getMethodDescriptor((Type)byteString, (Type[])new Type[0]));
        cgs.freeLocal(strVar);
    }

    private static void encodeScalar(MethodVisitor mv, EncodeCGS cgs, JavaColumnModel f) throws OrmException {
        cgs.setFieldReference(f);
        switch (Type.getType(f.getPrimitiveType()).getSort()) {
            case 1: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeBool", Type.BOOLEAN_TYPE);
                break;
            }
            case 2: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeUInt32", Type.INT_TYPE);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeSInt32", Type.INT_TYPE);
                break;
            }
            case 6: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeFloat", Type.FLOAT_TYPE);
                break;
            }
            case 8: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeDouble", Type.DOUBLE_TYPE);
                break;
            }
            case 7: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeSInt64", Type.LONG_TYPE);
                break;
            }
            case 9: 
            case 10: {
                Label end = new Label();
                cgs.pushFieldValue();
                mv.visitJumpInsn(198, end);
                if (f.getPrimitiveType() == byte[].class) {
                    cgs.pushCodedOutputStream();
                    cgs.push(f.getColumnID());
                    cgs.push(WireFormat.FieldType.BYTES.getWireType());
                    mv.visitMethodInsn(182, codedOutputStream.getInternalName(), "writeTag", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE}));
                    cgs.pushCodedOutputStream();
                    cgs.pushFieldValue();
                    mv.visitInsn(190);
                    mv.visitMethodInsn(182, codedOutputStream.getInternalName(), "writeRawVarint32", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}));
                    cgs.pushCodedOutputStream();
                    cgs.pushFieldValue();
                    mv.visitMethodInsn(182, codedOutputStream.getInternalName(), "writeRawBytes", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(byte[].class)}));
                } else {
                    cgs.pushCodedOutputStream();
                    cgs.push(f.getColumnID());
                    cgs.pushFieldValue();
                    if (f.getPrimitiveType() == String.class) {
                        cgs.write("writeString", string);
                    } else if (f.getPrimitiveType() == Timestamp.class || f.getPrimitiveType() == java.util.Date.class || f.getPrimitiveType() == Date.class) {
                        String tsType = Type.getType(f.getPrimitiveType()).getInternalName();
                        mv.visitMethodInsn(182, tsType, "getTime", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]));
                        cgs.write("writeFixed64", Type.LONG_TYPE);
                    } else {
                        throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
                    }
                }
                mv.visitLabel(end);
                break;
            }
            default: {
                throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
            }
        }
    }

    private void implementDecode() throws OrmException {
        Type retType = object;
        MethodVisitor mv = this.cw.visitMethod(4, "decode", Type.getMethodDescriptor((Type)retType, (Type[])new Type[]{codedInputStream}), null, new String[0]);
        mv.visitCode();
        DecodeCGS cgs = new DecodeCGS(mv);
        cgs.setEntityType(this.pojoType);
        mv.visitTypeInsn(187, this.pojoType.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, this.pojoType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        mv.visitVarInsn(58, cgs.objVar);
        int tagVar = cgs.newLocal();
        CodecGen.decodeMessage(this.myFields, mv, cgs);
        cgs.pushEntity();
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private static void decodeMessage(JavaColumnModel[] myFields, MethodVisitor mv, DecodeCGS cgs) throws OrmException {
        Label nextField = new Label();
        Label end = new Label();
        mv.visitLabel(nextField);
        cgs.call("readTag", Type.INT_TYPE);
        mv.visitInsn(89);
        mv.visitVarInsn(54, cgs.tagVar);
        cgs.push(3);
        mv.visitInsn(124);
        Label badField = new Label();
        int[] caseTags = new int[1 + myFields.length];
        Label[] caseLabels = new Label[caseTags.length];
        caseTags[0] = 0;
        caseLabels[0] = new Label();
        int gaps = 0;
        for (int i = 1; i < caseTags.length; ++i) {
            caseTags[i] = myFields[i - 1].getColumnID();
            caseLabels[i] = new Label();
            gaps += caseTags[i] - (caseTags[i - 1] + 1);
        }
        if (2 * gaps / 3 <= myFields.length) {
            boolean min = false;
            int max = caseTags[caseTags.length - 1];
            Object[] table = new Label[max + 1];
            Arrays.fill(table, badField);
            for (int idx = 0; idx < caseTags.length; ++idx) {
                table[caseTags[idx]] = caseLabels[idx];
            }
            mv.visitTableSwitchInsn(0, max, badField, (Label[])table);
        } else {
            mv.visitLookupSwitchInsn(badField, caseTags, caseLabels);
        }
        mv.visitLabel(caseLabels[0]);
        mv.visitJumpInsn(167, end);
        for (int idx = 1; idx < caseTags.length; ++idx) {
            JavaColumnModel f = myFields[idx - 1];
            mv.visitLabel(caseLabels[idx]);
            if (f.isNested()) {
                Label load = new Label();
                cgs.setFieldReference(f);
                cgs.pushFieldValue();
                mv.visitJumpInsn(199, load);
                cgs.fieldSetBegin();
                mv.visitTypeInsn(187, Type.getType(f.getNestedClass()).getInternalName());
                mv.visitInsn(89);
                mv.visitMethodInsn(183, Type.getType(f.getNestedClass()).getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
                cgs.fieldSetEnd();
                mv.visitLabel(load);
                int limitVar = cgs.newLocal();
                cgs.pushCodedInputStream();
                cgs.call("readRawVarint32", Type.INT_TYPE);
                cgs.ncallInt("pushLimit", Type.INT_TYPE);
                mv.visitVarInsn(54, limitVar);
                CodecGen.decodeMessage(CodecGen.sort(f.getNestedColumns()), mv, cgs);
                cgs.pushCodedInputStream();
                mv.visitVarInsn(21, limitVar);
                cgs.ncallInt("popLimit", Type.VOID_TYPE);
                cgs.freeLocal(limitVar);
            } else {
                CodecGen.decodeScalar(mv, cgs, f);
            }
            mv.visitJumpInsn(167, nextField);
        }
        mv.visitLabel(badField);
        cgs.pushCodedInputStream();
        mv.visitVarInsn(21, cgs.tagVar);
        cgs.ncallInt("skipField", Type.BOOLEAN_TYPE);
        mv.visitInsn(87);
        mv.visitJumpInsn(167, nextField);
        mv.visitLabel(end);
        cgs.pushCodedInputStream();
        cgs.push(0);
        cgs.ncallInt("checkLastTagWas", Type.VOID_TYPE);
    }

    private static void decodeScalar(MethodVisitor mv, DecodeCGS cgs, JavaColumnModel f) throws OrmException {
        cgs.setFieldReference(f);
        cgs.fieldSetBegin();
        switch (Type.getType(f.getPrimitiveType()).getSort()) {
            case 1: {
                cgs.call("readBool", Type.BOOLEAN_TYPE);
                break;
            }
            case 2: {
                cgs.call("readUInt32", Type.INT_TYPE);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cgs.call("readSInt32", Type.INT_TYPE);
                break;
            }
            case 6: {
                cgs.call("readFloat", Type.FLOAT_TYPE);
                break;
            }
            case 8: {
                cgs.call("readDouble", Type.DOUBLE_TYPE);
                break;
            }
            case 7: {
                cgs.call("readSInt64", Type.LONG_TYPE);
                break;
            }
            default: {
                if (f.getPrimitiveType() == byte[].class) {
                    cgs.call("readBytes", byteString);
                    mv.visitMethodInsn(182, byteString.getInternalName(), "toByteArray", Type.getMethodDescriptor((Type)Type.getType(byte[].class), (Type[])new Type[0]));
                    break;
                }
                if (f.getPrimitiveType() == String.class) {
                    cgs.call("readString", string);
                    break;
                }
                if (f.getPrimitiveType() == Timestamp.class || f.getPrimitiveType() == java.util.Date.class || f.getPrimitiveType() == Date.class) {
                    String tsType = Type.getType(f.getPrimitiveType()).getInternalName();
                    mv.visitTypeInsn(187, tsType);
                    mv.visitInsn(89);
                    cgs.call("readFixed64", Type.LONG_TYPE);
                    mv.visitMethodInsn(183, tsType, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
                    break;
                }
                throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
            }
        }
        cgs.fieldSetEnd();
    }

    private static final class DecodeCGS
    extends CodeGenSupport {
        final int codedInputStreamVar = 1;
        final int objVar = this.newLocal();
        final int tagVar = this.newLocal();

        private DecodeCGS(MethodVisitor method) {
            super(method);
        }

        void pushCodedInputStream() {
            this.mv.visitVarInsn(25, 1);
        }

        void call(String name, Type ret) {
            this.pushCodedInputStream();
            this.mv.visitMethodInsn(182, codedInputStream.getInternalName(), name, Type.getMethodDescriptor((Type)ret, (Type[])new Type[0]));
        }

        void ncallInt(String name, Type ret) {
            this.mv.visitMethodInsn(182, codedInputStream.getInternalName(), name, Type.getMethodDescriptor((Type)ret, (Type[])new Type[]{Type.INT_TYPE}));
        }

        @Override
        public void pushEntity() {
            this.mv.visitVarInsn(25, this.objVar);
        }
    }

    private static final class EncodeCGS
    extends CodeGenSupport {
        int codedOutputStreamVar;

        private EncodeCGS(MethodVisitor method) {
            super(method);
        }

        void pushCodedOutputStream() {
            this.mv.visitVarInsn(25, this.codedOutputStreamVar);
        }

        void write(String name, Type arg) {
            this.mv.visitMethodInsn(182, codedOutputStream.getInternalName(), name, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, arg}));
        }

        @Override
        public void pushEntity() {
            this.mv.visitVarInsn(25, 1);
        }
    }

    private static final class SizeofCGS
    extends CodeGenSupport {
        int sizeVar = this.newLocal();

        private SizeofCGS(MethodVisitor method) {
            super(method);
        }

        void inc(String name, Type ... args) {
            this.mv.visitMethodInsn(184, codedOutputStream.getInternalName(), name, Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])args));
            this.inc();
        }

        void inc() {
            this.mv.visitVarInsn(21, this.sizeVar);
            this.mv.visitInsn(96);
            this.mv.visitVarInsn(54, this.sizeVar);
        }

        @Override
        public void pushEntity() {
            this.mv.visitVarInsn(25, 1);
        }
    }
}

