/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.internal.traceability.engine.AbstractTrace;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.expressions.OCLExpression;

public class ExpressionTrace<C>
extends AbstractTrace {
    private final OCLExpression<C> referredExpression;

    public ExpressionTrace(OCLExpression<C> expression) {
        this.referredExpression = expression;
    }

    public ExpressionTrace(ExpressionTrace<C> other) {
        this.referredExpression = other.getReferredExpression();
        this.currentOffset = other.currentOffset;
        LinkedHashMap<InputElement, Set<GeneratedText>> temp = other.getTraces();
        for (InputElement key : temp.keySet()) {
            this.traces.put(key, new CompactLinkedHashSet((Collection)temp.get(key)));
        }
    }

    public void mergeTrace(InputElement input, Set<GeneratedText> regions) {
        Set associatedTraces = (Set)this.traces.get(input);
        if (associatedTraces == null) {
            associatedTraces = new CompactLinkedHashSet();
            this.traces.put(input, associatedTraces);
        }
        for (GeneratedText region : regions) {
            GeneratedText regionCopy = (GeneratedText)EcoreUtil.copy((EObject)region);
            int regionLength = region.getEndOffset() - region.getStartOffset();
            regionCopy.setStartOffset(this.currentOffset);
            regionCopy.setEndOffset(this.currentOffset + regionLength);
            this.currentOffset += regionLength;
            associatedTraces.add(regionCopy);
        }
    }

    public OCLExpression<C> getReferredExpression() {
        return this.referredExpression;
    }
}

